// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * With Amazon EMR release version 4.0 and later, the only accepted parameter is the application name. To pass arguments to applications, you use configuration classifications specified using configuration JSON objects. For more information, see [Configuring Applications](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html).
 *
 * With earlier Amazon EMR releases, the application is any Amazon or third-party software that you can add to the cluster. This structure contains a list of strings that indicates the software to use with the cluster and accepts a user argument list. Amazon EMR accepts and forwards the argument list to the corresponding installation script as bootstrap action argument.
 */
public class Application private constructor(builder: Builder) {
    /**
     * This option is for advanced users only. This is meta information about third-party applications that third-party vendors use for testing purposes.
     */
    public val additionalInfo: Map<String, String>? = builder.additionalInfo
    /**
     * Arguments for Amazon EMR to pass to the application.
     */
    public val args: List<String>? = builder.args
    /**
     * The name of the application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The version of the application.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.Application = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Application(")
        append("additionalInfo=$additionalInfo,")
        append("args=$args,")
        append("name=$name,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (args?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Application

        if (additionalInfo != other.additionalInfo) return false
        if (args != other.args) return false
        if (name != other.name) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.Application = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This option is for advanced users only. This is meta information about third-party applications that third-party vendors use for testing purposes.
         */
        public var additionalInfo: Map<String, String>? = null
        /**
         * Arguments for Amazon EMR to pass to the application.
         */
        public var args: List<String>? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The version of the application.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.Application) : this() {
            this.additionalInfo = x.additionalInfo
            this.args = x.args
            this.name = x.name
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.Application = Application(this)
    }
}
