// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.emr.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.emr.endpoints.EndpointParameters
import aws.sdk.kotlin.services.emr.endpoints.EndpointProvider
import aws.sdk.kotlin.services.emr.model.AddInstanceFleetRequest
import aws.sdk.kotlin.services.emr.model.AddInstanceFleetResponse
import aws.sdk.kotlin.services.emr.model.AddInstanceGroupsRequest
import aws.sdk.kotlin.services.emr.model.AddInstanceGroupsResponse
import aws.sdk.kotlin.services.emr.model.AddJobFlowStepsRequest
import aws.sdk.kotlin.services.emr.model.AddJobFlowStepsResponse
import aws.sdk.kotlin.services.emr.model.AddTagsRequest
import aws.sdk.kotlin.services.emr.model.AddTagsResponse
import aws.sdk.kotlin.services.emr.model.CancelStepsRequest
import aws.sdk.kotlin.services.emr.model.CancelStepsResponse
import aws.sdk.kotlin.services.emr.model.CreateSecurityConfigurationRequest
import aws.sdk.kotlin.services.emr.model.CreateSecurityConfigurationResponse
import aws.sdk.kotlin.services.emr.model.CreateStudioRequest
import aws.sdk.kotlin.services.emr.model.CreateStudioResponse
import aws.sdk.kotlin.services.emr.model.CreateStudioSessionMappingRequest
import aws.sdk.kotlin.services.emr.model.CreateStudioSessionMappingResponse
import aws.sdk.kotlin.services.emr.model.DeleteSecurityConfigurationRequest
import aws.sdk.kotlin.services.emr.model.DeleteSecurityConfigurationResponse
import aws.sdk.kotlin.services.emr.model.DeleteStudioRequest
import aws.sdk.kotlin.services.emr.model.DeleteStudioResponse
import aws.sdk.kotlin.services.emr.model.DeleteStudioSessionMappingRequest
import aws.sdk.kotlin.services.emr.model.DeleteStudioSessionMappingResponse
import aws.sdk.kotlin.services.emr.model.DescribeClusterRequest
import aws.sdk.kotlin.services.emr.model.DescribeClusterResponse
import aws.sdk.kotlin.services.emr.model.DescribeJobFlowsRequest
import aws.sdk.kotlin.services.emr.model.DescribeJobFlowsResponse
import aws.sdk.kotlin.services.emr.model.DescribeNotebookExecutionRequest
import aws.sdk.kotlin.services.emr.model.DescribeNotebookExecutionResponse
import aws.sdk.kotlin.services.emr.model.DescribeReleaseLabelRequest
import aws.sdk.kotlin.services.emr.model.DescribeReleaseLabelResponse
import aws.sdk.kotlin.services.emr.model.DescribeSecurityConfigurationRequest
import aws.sdk.kotlin.services.emr.model.DescribeSecurityConfigurationResponse
import aws.sdk.kotlin.services.emr.model.DescribeStepRequest
import aws.sdk.kotlin.services.emr.model.DescribeStepResponse
import aws.sdk.kotlin.services.emr.model.DescribeStudioRequest
import aws.sdk.kotlin.services.emr.model.DescribeStudioResponse
import aws.sdk.kotlin.services.emr.model.GetAutoTerminationPolicyRequest
import aws.sdk.kotlin.services.emr.model.GetAutoTerminationPolicyResponse
import aws.sdk.kotlin.services.emr.model.GetBlockPublicAccessConfigurationRequest
import aws.sdk.kotlin.services.emr.model.GetBlockPublicAccessConfigurationResponse
import aws.sdk.kotlin.services.emr.model.GetClusterSessionCredentialsRequest
import aws.sdk.kotlin.services.emr.model.GetClusterSessionCredentialsResponse
import aws.sdk.kotlin.services.emr.model.GetManagedScalingPolicyRequest
import aws.sdk.kotlin.services.emr.model.GetManagedScalingPolicyResponse
import aws.sdk.kotlin.services.emr.model.GetStudioSessionMappingRequest
import aws.sdk.kotlin.services.emr.model.GetStudioSessionMappingResponse
import aws.sdk.kotlin.services.emr.model.ListBootstrapActionsRequest
import aws.sdk.kotlin.services.emr.model.ListBootstrapActionsResponse
import aws.sdk.kotlin.services.emr.model.ListClustersRequest
import aws.sdk.kotlin.services.emr.model.ListClustersResponse
import aws.sdk.kotlin.services.emr.model.ListInstanceFleetsRequest
import aws.sdk.kotlin.services.emr.model.ListInstanceFleetsResponse
import aws.sdk.kotlin.services.emr.model.ListInstanceGroupsRequest
import aws.sdk.kotlin.services.emr.model.ListInstanceGroupsResponse
import aws.sdk.kotlin.services.emr.model.ListInstancesRequest
import aws.sdk.kotlin.services.emr.model.ListInstancesResponse
import aws.sdk.kotlin.services.emr.model.ListNotebookExecutionsRequest
import aws.sdk.kotlin.services.emr.model.ListNotebookExecutionsResponse
import aws.sdk.kotlin.services.emr.model.ListReleaseLabelsRequest
import aws.sdk.kotlin.services.emr.model.ListReleaseLabelsResponse
import aws.sdk.kotlin.services.emr.model.ListSecurityConfigurationsRequest
import aws.sdk.kotlin.services.emr.model.ListSecurityConfigurationsResponse
import aws.sdk.kotlin.services.emr.model.ListStepsRequest
import aws.sdk.kotlin.services.emr.model.ListStepsResponse
import aws.sdk.kotlin.services.emr.model.ListStudioSessionMappingsRequest
import aws.sdk.kotlin.services.emr.model.ListStudioSessionMappingsResponse
import aws.sdk.kotlin.services.emr.model.ListStudiosRequest
import aws.sdk.kotlin.services.emr.model.ListStudiosResponse
import aws.sdk.kotlin.services.emr.model.ModifyClusterRequest
import aws.sdk.kotlin.services.emr.model.ModifyClusterResponse
import aws.sdk.kotlin.services.emr.model.ModifyInstanceFleetRequest
import aws.sdk.kotlin.services.emr.model.ModifyInstanceFleetResponse
import aws.sdk.kotlin.services.emr.model.ModifyInstanceGroupsRequest
import aws.sdk.kotlin.services.emr.model.ModifyInstanceGroupsResponse
import aws.sdk.kotlin.services.emr.model.PutAutoScalingPolicyRequest
import aws.sdk.kotlin.services.emr.model.PutAutoScalingPolicyResponse
import aws.sdk.kotlin.services.emr.model.PutAutoTerminationPolicyRequest
import aws.sdk.kotlin.services.emr.model.PutAutoTerminationPolicyResponse
import aws.sdk.kotlin.services.emr.model.PutBlockPublicAccessConfigurationRequest
import aws.sdk.kotlin.services.emr.model.PutBlockPublicAccessConfigurationResponse
import aws.sdk.kotlin.services.emr.model.PutManagedScalingPolicyRequest
import aws.sdk.kotlin.services.emr.model.PutManagedScalingPolicyResponse
import aws.sdk.kotlin.services.emr.model.RemoveAutoScalingPolicyRequest
import aws.sdk.kotlin.services.emr.model.RemoveAutoScalingPolicyResponse
import aws.sdk.kotlin.services.emr.model.RemoveAutoTerminationPolicyRequest
import aws.sdk.kotlin.services.emr.model.RemoveAutoTerminationPolicyResponse
import aws.sdk.kotlin.services.emr.model.RemoveManagedScalingPolicyRequest
import aws.sdk.kotlin.services.emr.model.RemoveManagedScalingPolicyResponse
import aws.sdk.kotlin.services.emr.model.RemoveTagsRequest
import aws.sdk.kotlin.services.emr.model.RemoveTagsResponse
import aws.sdk.kotlin.services.emr.model.RunJobFlowRequest
import aws.sdk.kotlin.services.emr.model.RunJobFlowResponse
import aws.sdk.kotlin.services.emr.model.SetTerminationProtectionRequest
import aws.sdk.kotlin.services.emr.model.SetTerminationProtectionResponse
import aws.sdk.kotlin.services.emr.model.SetVisibleToAllUsersRequest
import aws.sdk.kotlin.services.emr.model.SetVisibleToAllUsersResponse
import aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest
import aws.sdk.kotlin.services.emr.model.StartNotebookExecutionResponse
import aws.sdk.kotlin.services.emr.model.StopNotebookExecutionRequest
import aws.sdk.kotlin.services.emr.model.StopNotebookExecutionResponse
import aws.sdk.kotlin.services.emr.model.TerminateJobFlowsRequest
import aws.sdk.kotlin.services.emr.model.TerminateJobFlowsResponse
import aws.sdk.kotlin.services.emr.model.UpdateStudioRequest
import aws.sdk.kotlin.services.emr.model.UpdateStudioResponse
import aws.sdk.kotlin.services.emr.model.UpdateStudioSessionMappingRequest
import aws.sdk.kotlin.services.emr.model.UpdateStudioSessionMappingResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * Amazon EMR is a web service that makes it easier to process large amounts of data efficiently. Amazon EMR uses Hadoop processing combined with several Amazon Web Services services to do tasks such as web indexing, data mining, log file analysis, machine learning, scientific simulation, and data warehouse management.
 */
public interface EmrClient : SdkClient {
    /**
     * EmrClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, EmrClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, EmrClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): EmrClient = DefaultEmrClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "EMR"

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an instance fleet to a running cluster.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.
     */
    public suspend fun addInstanceFleet(input: AddInstanceFleetRequest): AddInstanceFleetResponse

    /**
     * Adds one or more instance groups to a running cluster.
     */
    public suspend fun addInstanceGroups(input: AddInstanceGroupsRequest): AddInstanceGroupsResponse

    /**
     * AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.
     *
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop.
     *
     * A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each step is performed by the main function of the main class of the JAR file. The main class can be specified either in the manifest of the JAR or by using the MainFunction parameter of the step.
     *
     * Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run successfully.
     *
     * You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or WAITING.
     *
     * The string values passed into `HadoopJarStep` object cannot exceed a total of 10240 characters.
     */
    public suspend fun addJobFlowSteps(input: AddJobFlowStepsRequest): AddJobFlowStepsResponse

    /**
     * Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see [Tag Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
     */
    public suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a `PENDING` or `RUNNING` state. In earlier versions of Amazon EMR, you can only cancel steps that are in a `PENDING` state.
     */
    public suspend fun cancelSteps(input: CancelStepsRequest): CancelStepsResponse

    /**
     * Creates a security configuration, which is stored in the service and can be specified when a cluster is created.
     */
    public suspend fun createSecurityConfiguration(input: CreateSecurityConfigurationRequest): CreateSecurityConfigurationResponse

    /**
     * Creates a new Amazon EMR Studio.
     */
    public suspend fun createStudio(input: CreateStudioRequest): CreateStudioResponse

    /**
     * Maps a user or group to the Amazon EMR Studio specified by `StudioId`, and applies a session policy to refine Studio permissions for that user or group. Use `CreateStudioSessionMapping` to assign users to a Studio when you use IAM Identity Center authentication. For instructions on how to assign users to a Studio when you use IAM authentication, see [Assign a user or group to your EMR Studio](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups).
     */
    public suspend fun createStudioSessionMapping(input: CreateStudioSessionMappingRequest): CreateStudioSessionMappingResponse

    /**
     * Deletes a security configuration.
     */
    public suspend fun deleteSecurityConfiguration(input: DeleteSecurityConfigurationRequest): DeleteSecurityConfigurationResponse

    /**
     * Removes an Amazon EMR Studio from the Studio metadata store.
     */
    public suspend fun deleteStudio(input: DeleteStudioRequest): DeleteStudioResponse

    /**
     * Removes a user or group from an Amazon EMR Studio.
     */
    public suspend fun deleteStudioSessionMapping(input: DeleteStudioSessionMappingRequest): DeleteStudioSessionMappingResponse

    /**
     * Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.
     */
    public suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * This API is no longer supported and will eventually be removed. We recommend you use ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and ListBootstrapActions instead.
     *
     * DescribeJobFlows returns a list of job flows that match all of the supplied parameters. The parameters can include a list of job flow IDs, job flow states, and restrictions on job flow creation date and time.
     *
     * Regardless of supplied parameters, only job flows created within the last two months are returned.
     *
     * If no parameters are supplied, then job flows matching either of the following criteria are returned:
     * + Job flows created and completed in the last two weeks
     * +  Job flows created within the last two months that are in one of the following states: `RUNNING`, `WAITING`, `SHUTTING_DOWN`, `STARTING`
     *
     * Amazon EMR can return a maximum of 512 job flow descriptions.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeJobFlows(input: DescribeJobFlowsRequest = DescribeJobFlowsRequest {}): DescribeJobFlowsResponse

    /**
     * Provides details of a notebook execution.
     */
    public suspend fun describeNotebookExecution(input: DescribeNotebookExecutionRequest): DescribeNotebookExecutionResponse

    /**
     * Provides EMR release label details, such as releases available the region where the API request is run, and the available applications for a specific EMR release label. Can also list EMR release versions that support a specified version of Spark.
     */
    public suspend fun describeReleaseLabel(input: DescribeReleaseLabelRequest = DescribeReleaseLabelRequest {}): DescribeReleaseLabelResponse

    /**
     * Provides the details of a security configuration by returning the configuration JSON.
     */
    public suspend fun describeSecurityConfiguration(input: DescribeSecurityConfigurationRequest): DescribeSecurityConfigurationResponse

    /**
     * Provides more detail about the cluster step.
     */
    public suspend fun describeStep(input: DescribeStepRequest): DescribeStepResponse

    /**
     * Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.
     */
    public suspend fun describeStudio(input: DescribeStudioRequest): DescribeStudioResponse

    /**
     * Returns the auto-termination policy for an Amazon EMR cluster.
     */
    public suspend fun getAutoTerminationPolicy(input: GetAutoTerminationPolicyRequest): GetAutoTerminationPolicyResponse

    /**
     * Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see [Configure Block Public Access for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html) in the *Amazon EMR Management Guide*.
     */
    public suspend fun getBlockPublicAccessConfiguration(input: GetBlockPublicAccessConfigurationRequest = GetBlockPublicAccessConfigurationRequest {}): GetBlockPublicAccessConfigurationResponse

    /**
     * Provides temporary, HTTP basic credentials that are associated with a given runtime IAM role and used by a cluster with fine-grained access control activated. You can use these credentials to connect to cluster endpoints that support username and password authentication.
     */
    public suspend fun getClusterSessionCredentials(input: GetClusterSessionCredentialsRequest): GetClusterSessionCredentialsResponse

    /**
     * Fetches the attached managed scaling policy for an Amazon EMR cluster.
     */
    public suspend fun getManagedScalingPolicy(input: GetManagedScalingPolicyRequest): GetManagedScalingPolicyResponse

    /**
     * Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).
     */
    public suspend fun getStudioSessionMapping(input: GetStudioSessionMappingRequest): GetStudioSessionMappingResponse

    /**
     * Provides information about the bootstrap actions associated with a cluster.
     */
    public suspend fun listBootstrapActions(input: ListBootstrapActionsRequest): ListBootstrapActionsResponse

    /**
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the cluster list across multiple ListClusters calls.
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest {}): ListClustersResponse

    /**
     * Lists all available details about the instance fleets in a cluster.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     */
    public suspend fun listInstanceFleets(input: ListInstanceFleetsRequest): ListInstanceFleetsResponse

    /**
     * Provides all available details about the instance groups in a cluster.
     */
    public suspend fun listInstanceGroups(input: ListInstanceGroupsRequest): ListInstanceGroupsResponse

    /**
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.
     */
    public suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse

    /**
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status, time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a longer notebook execution list across multiple `ListNotebookExecution` calls.
     */
    public suspend fun listNotebookExecutions(input: ListNotebookExecutionsRequest = ListNotebookExecutionsRequest {}): ListNotebookExecutionsResponse

    /**
     * Retrieves release labels of EMR services in the region where the API is called.
     */
    public suspend fun listReleaseLabels(input: ListReleaseLabelsRequest = ListReleaseLabelsRequest {}): ListReleaseLabelsResponse

    /**
     * Lists all the security configurations visible to this account, providing their creation dates and times, and their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple ListSecurityConfigurations calls.
     */
    public suspend fun listSecurityConfigurations(input: ListSecurityConfigurationsRequest = ListSecurityConfigurationsRequest {}): ListSecurityConfigurationsResponse

    /**
     * Provides a list of steps for the cluster in reverse order unless you specify `stepIds` with the request or filter by `StepStates`. You can specify a maximum of 10 `stepIDs`. The CLI automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the CLI, specify a `Marker`, which is a pagination token that indicates the next set of steps to retrieve.
     */
    public suspend fun listSteps(input: ListStepsRequest): ListStepsResponse

    /**
     * Returns a list of all user or group session mappings for the Amazon EMR Studio specified by `StudioId`.
     */
    public suspend fun listStudioSessionMappings(input: ListStudioSessionMappingsRequest = ListStudioSessionMappingsRequest {}): ListStudioSessionMappingsResponse

    /**
     * Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes details such as ID, Studio Access URL, and creation time for each Studio.
     */
    public suspend fun listStudios(input: ListStudiosRequest = ListStudiosRequest {}): ListStudiosResponse

    /**
     * Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.
     */
    public suspend fun modifyCluster(input: ModifyClusterRequest): ModifyClusterResponse

    /**
     * Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     */
    public suspend fun modifyInstanceFleet(input: ModifyInstanceFleetRequest): ModifyInstanceFleetResponse

    /**
     * ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input parameters include the new target instance count for the group and the instance group ID. The call will either succeed or fail atomically.
     */
    public suspend fun modifyInstanceGroups(input: ModifyInstanceGroupsRequest = ModifyInstanceGroupsRequest {}): ModifyInstanceGroupsResponse

    /**
     * Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric.
     */
    public suspend fun putAutoScalingPolicy(input: PutAutoScalingPolicyRequest): PutAutoScalingPolicyResponse

    /**
     * Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see [Using an auto-termination policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html).
     *
     * Creates or updates an auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see [Control cluster termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html).
     */
    public suspend fun putAutoTerminationPolicy(input: PutAutoTerminationPolicyRequest): PutAutoTerminationPolicyResponse

    /**
     * Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see [Configure Block Public Access for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html) in the *Amazon EMR Management Guide*.
     */
    public suspend fun putBlockPublicAccessConfiguration(input: PutBlockPublicAccessConfigurationRequest): PutBlockPublicAccessConfigurationResponse

    /**
     * Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     */
    public suspend fun putManagedScalingPolicy(input: PutManagedScalingPolicyRequest): PutManagedScalingPolicyResponse

    /**
     * Removes an automatic scaling policy from a specified instance group within an EMR cluster.
     */
    public suspend fun removeAutoScalingPolicy(input: RemoveAutoScalingPolicyRequest): RemoveAutoScalingPolicyResponse

    /**
     * Removes an auto-termination policy from an Amazon EMR cluster.
     */
    public suspend fun removeAutoTerminationPolicy(input: RemoveAutoTerminationPolicyRequest): RemoveAutoTerminationPolicyResponse

    /**
     * Removes a managed scaling policy from a specified EMR cluster.
     */
    public suspend fun removeManagedScalingPolicy(input: RemoveManagedScalingPolicyRequest): RemoveManagedScalingPolicyResponse

    /**
     * Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see [Tag Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
     *
     * The following example removes the stack tag with value Prod from a cluster:
     */
    public suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last step of the job flow to store results in Amazon S3. If the JobFlowInstancesConfig`KeepJobFlowAliveWhenNoSteps` parameter is set to `TRUE`, the cluster transitions to the WAITING state rather than shutting down after the steps have completed.
     *
     * For additional protection, you can set the JobFlowInstancesConfig`TerminationProtected` parameter to `TRUE` to lock the cluster and prevent it from being terminated by API call, user intervention, or in the event of a job flow error.
     *
     * A maximum of 256 steps are allowed in each job flow.
     *
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using the SSH shell to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop.
     *
     * For long-running clusters, we recommend that you periodically store your results.
     *
     * The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. The RunJobFlow request can contain InstanceFleets parameters or InstanceGroups parameters, but not both.
     */
    public suspend fun runJobFlow(input: RunJobFlowRequest): RunJobFlowResponse

    /**
     * SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful completion of the job flow. Calling `SetTerminationProtection` on a cluster is similar to calling the Amazon EC2 `DisableAPITermination` API on all EC2 instances in a cluster.
     *
     * `SetTerminationProtection` is used to prevent accidental termination of a cluster and to ensure that in the event of an error, the instances persist so that you can recover any data stored in their ephemeral instance storage.
     *
     *  To terminate a cluster that has been locked by setting `SetTerminationProtection` to `true`, you must first unlock the job flow by a subsequent call to `SetTerminationProtection` in which you set the value to `false`.
     *
     *  For more information, see[Managing Cluster Termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html) in the *Amazon EMR Management Guide*.
     */
    public suspend fun setTerminationProtection(input: SetTerminationProtectionRequest): SetTerminationProtectionResponse

    /**
     * The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your account. To restrict cluster access using an IAM policy, see [Identity and Access Management for EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html).
     *
     * Sets the Cluster$VisibleToAllUsers value for an EMR cluster. When `true`, IAM principals in the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When `false`, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions on the cluster, regardless of IAM permissions policies attached to other IAM principals.
     *
     * This action works on running clusters. When you create a cluster, use the RunJobFlowInput$VisibleToAllUsers parameter.
     *
     * For more information, see [Understanding the EMR Cluster VisibleToAllUsers Setting](https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users) in the *Amazon EMRManagement Guide*.
     */
    public suspend fun setVisibleToAllUsers(input: SetVisibleToAllUsersRequest): SetVisibleToAllUsersResponse

    /**
     * Starts a notebook execution.
     */
    public suspend fun startNotebookExecution(input: StartNotebookExecutionRequest): StartNotebookExecutionResponse

    /**
     * Stops a notebook execution.
     */
    public suspend fun stopNotebookExecution(input: StopNotebookExecutionRequest): StopNotebookExecutionResponse

    /**
     * TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.
     *
     * The maximum number of clusters allowed is 10. The call to `TerminateJobFlows` is asynchronous. Depending on the configuration of the cluster, it may take up to 1-5 minutes for the cluster to completely terminate and release allocated resources, such as Amazon EC2 instances.
     */
    public suspend fun terminateJobFlows(input: TerminateJobFlowsRequest): TerminateJobFlowsResponse

    /**
     * Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.
     */
    public suspend fun updateStudio(input: UpdateStudioRequest): UpdateStudioResponse

    /**
     * Updates the session policy attached to the user or group for the specified Amazon EMR Studio.
     */
    public suspend fun updateStudioSessionMapping(input: UpdateStudioSessionMappingRequest): UpdateStudioSessionMappingResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun EmrClient.withConfig(block: EmrClient.Config.Builder.() -> Unit): EmrClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultEmrClient(newConfig)
}

/**
 * Adds an instance fleet to a running cluster.
 *
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.
 */
public suspend inline fun EmrClient.addInstanceFleet(crossinline block: AddInstanceFleetRequest.Builder.() -> Unit): AddInstanceFleetResponse = addInstanceFleet(AddInstanceFleetRequest.Builder().apply(block).build())

/**
 * Adds one or more instance groups to a running cluster.
 */
public suspend inline fun EmrClient.addInstanceGroups(crossinline block: AddInstanceGroupsRequest.Builder.() -> Unit): AddInstanceGroupsResponse = addInstanceGroups(AddInstanceGroupsRequest.Builder().apply(block).build())

/**
 * AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.
 *
 * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop.
 *
 * A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each step is performed by the main function of the main class of the JAR file. The main class can be specified either in the manifest of the JAR or by using the MainFunction parameter of the step.
 *
 * Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run successfully.
 *
 * You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or WAITING.
 *
 * The string values passed into `HadoopJarStep` object cannot exceed a total of 10240 characters.
 */
public suspend inline fun EmrClient.addJobFlowSteps(crossinline block: AddJobFlowStepsRequest.Builder.() -> Unit): AddJobFlowStepsResponse = addJobFlowSteps(AddJobFlowStepsRequest.Builder().apply(block).build())

/**
 * Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see [Tag Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
 */
public suspend inline fun EmrClient.addTags(crossinline block: AddTagsRequest.Builder.() -> Unit): AddTagsResponse = addTags(AddTagsRequest.Builder().apply(block).build())

/**
 * Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a `PENDING` or `RUNNING` state. In earlier versions of Amazon EMR, you can only cancel steps that are in a `PENDING` state.
 */
public suspend inline fun EmrClient.cancelSteps(crossinline block: CancelStepsRequest.Builder.() -> Unit): CancelStepsResponse = cancelSteps(CancelStepsRequest.Builder().apply(block).build())

/**
 * Creates a security configuration, which is stored in the service and can be specified when a cluster is created.
 */
public suspend inline fun EmrClient.createSecurityConfiguration(crossinline block: CreateSecurityConfigurationRequest.Builder.() -> Unit): CreateSecurityConfigurationResponse = createSecurityConfiguration(CreateSecurityConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon EMR Studio.
 */
public suspend inline fun EmrClient.createStudio(crossinline block: CreateStudioRequest.Builder.() -> Unit): CreateStudioResponse = createStudio(CreateStudioRequest.Builder().apply(block).build())

/**
 * Maps a user or group to the Amazon EMR Studio specified by `StudioId`, and applies a session policy to refine Studio permissions for that user or group. Use `CreateStudioSessionMapping` to assign users to a Studio when you use IAM Identity Center authentication. For instructions on how to assign users to a Studio when you use IAM authentication, see [Assign a user or group to your EMR Studio](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups).
 */
public suspend inline fun EmrClient.createStudioSessionMapping(crossinline block: CreateStudioSessionMappingRequest.Builder.() -> Unit): CreateStudioSessionMappingResponse = createStudioSessionMapping(CreateStudioSessionMappingRequest.Builder().apply(block).build())

/**
 * Deletes a security configuration.
 */
public suspend inline fun EmrClient.deleteSecurityConfiguration(crossinline block: DeleteSecurityConfigurationRequest.Builder.() -> Unit): DeleteSecurityConfigurationResponse = deleteSecurityConfiguration(DeleteSecurityConfigurationRequest.Builder().apply(block).build())

/**
 * Removes an Amazon EMR Studio from the Studio metadata store.
 */
public suspend inline fun EmrClient.deleteStudio(crossinline block: DeleteStudioRequest.Builder.() -> Unit): DeleteStudioResponse = deleteStudio(DeleteStudioRequest.Builder().apply(block).build())

/**
 * Removes a user or group from an Amazon EMR Studio.
 */
public suspend inline fun EmrClient.deleteStudioSessionMapping(crossinline block: DeleteStudioSessionMappingRequest.Builder.() -> Unit): DeleteStudioSessionMappingResponse = deleteStudioSessionMapping(DeleteStudioSessionMappingRequest.Builder().apply(block).build())

/**
 * Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.
 */
public suspend inline fun EmrClient.describeCluster(crossinline block: DescribeClusterRequest.Builder.() -> Unit): DescribeClusterResponse = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

/**
 * This API is no longer supported and will eventually be removed. We recommend you use ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and ListBootstrapActions instead.
 *
 * DescribeJobFlows returns a list of job flows that match all of the supplied parameters. The parameters can include a list of job flow IDs, job flow states, and restrictions on job flow creation date and time.
 *
 * Regardless of supplied parameters, only job flows created within the last two months are returned.
 *
 * If no parameters are supplied, then job flows matching either of the following criteria are returned:
 * + Job flows created and completed in the last two weeks
 * +  Job flows created within the last two months that are in one of the following states: `RUNNING`, `WAITING`, `SHUTTING_DOWN`, `STARTING`
 *
 * Amazon EMR can return a maximum of 512 job flow descriptions.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun EmrClient.describeJobFlows(crossinline block: DescribeJobFlowsRequest.Builder.() -> Unit): DescribeJobFlowsResponse = describeJobFlows(DescribeJobFlowsRequest.Builder().apply(block).build())

/**
 * Provides details of a notebook execution.
 */
public suspend inline fun EmrClient.describeNotebookExecution(crossinline block: DescribeNotebookExecutionRequest.Builder.() -> Unit): DescribeNotebookExecutionResponse = describeNotebookExecution(DescribeNotebookExecutionRequest.Builder().apply(block).build())

/**
 * Provides EMR release label details, such as releases available the region where the API request is run, and the available applications for a specific EMR release label. Can also list EMR release versions that support a specified version of Spark.
 */
public suspend inline fun EmrClient.describeReleaseLabel(crossinline block: DescribeReleaseLabelRequest.Builder.() -> Unit): DescribeReleaseLabelResponse = describeReleaseLabel(DescribeReleaseLabelRequest.Builder().apply(block).build())

/**
 * Provides the details of a security configuration by returning the configuration JSON.
 */
public suspend inline fun EmrClient.describeSecurityConfiguration(crossinline block: DescribeSecurityConfigurationRequest.Builder.() -> Unit): DescribeSecurityConfigurationResponse = describeSecurityConfiguration(DescribeSecurityConfigurationRequest.Builder().apply(block).build())

/**
 * Provides more detail about the cluster step.
 */
public suspend inline fun EmrClient.describeStep(crossinline block: DescribeStepRequest.Builder.() -> Unit): DescribeStepResponse = describeStep(DescribeStepRequest.Builder().apply(block).build())

/**
 * Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.
 */
public suspend inline fun EmrClient.describeStudio(crossinline block: DescribeStudioRequest.Builder.() -> Unit): DescribeStudioResponse = describeStudio(DescribeStudioRequest.Builder().apply(block).build())

/**
 * Returns the auto-termination policy for an Amazon EMR cluster.
 */
public suspend inline fun EmrClient.getAutoTerminationPolicy(crossinline block: GetAutoTerminationPolicyRequest.Builder.() -> Unit): GetAutoTerminationPolicyResponse = getAutoTerminationPolicy(GetAutoTerminationPolicyRequest.Builder().apply(block).build())

/**
 * Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see [Configure Block Public Access for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html) in the *Amazon EMR Management Guide*.
 */
public suspend inline fun EmrClient.getBlockPublicAccessConfiguration(crossinline block: GetBlockPublicAccessConfigurationRequest.Builder.() -> Unit): GetBlockPublicAccessConfigurationResponse = getBlockPublicAccessConfiguration(GetBlockPublicAccessConfigurationRequest.Builder().apply(block).build())

/**
 * Provides temporary, HTTP basic credentials that are associated with a given runtime IAM role and used by a cluster with fine-grained access control activated. You can use these credentials to connect to cluster endpoints that support username and password authentication.
 */
public suspend inline fun EmrClient.getClusterSessionCredentials(crossinline block: GetClusterSessionCredentialsRequest.Builder.() -> Unit): GetClusterSessionCredentialsResponse = getClusterSessionCredentials(GetClusterSessionCredentialsRequest.Builder().apply(block).build())

/**
 * Fetches the attached managed scaling policy for an Amazon EMR cluster.
 */
public suspend inline fun EmrClient.getManagedScalingPolicy(crossinline block: GetManagedScalingPolicyRequest.Builder.() -> Unit): GetManagedScalingPolicyResponse = getManagedScalingPolicy(GetManagedScalingPolicyRequest.Builder().apply(block).build())

/**
 * Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).
 */
public suspend inline fun EmrClient.getStudioSessionMapping(crossinline block: GetStudioSessionMappingRequest.Builder.() -> Unit): GetStudioSessionMappingResponse = getStudioSessionMapping(GetStudioSessionMappingRequest.Builder().apply(block).build())

/**
 * Provides information about the bootstrap actions associated with a cluster.
 */
public suspend inline fun EmrClient.listBootstrapActions(crossinline block: ListBootstrapActionsRequest.Builder.() -> Unit): ListBootstrapActionsResponse = listBootstrapActions(ListBootstrapActionsRequest.Builder().apply(block).build())

/**
 * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the cluster list across multiple ListClusters calls.
 */
public suspend inline fun EmrClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Lists all available details about the instance fleets in a cluster.
 *
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 */
public suspend inline fun EmrClient.listInstanceFleets(crossinline block: ListInstanceFleetsRequest.Builder.() -> Unit): ListInstanceFleetsResponse = listInstanceFleets(ListInstanceFleetsRequest.Builder().apply(block).build())

/**
 * Provides all available details about the instance groups in a cluster.
 */
public suspend inline fun EmrClient.listInstanceGroups(crossinline block: ListInstanceGroupsRequest.Builder.() -> Unit): ListInstanceGroupsResponse = listInstanceGroups(ListInstanceGroupsRequest.Builder().apply(block).build())

/**
 * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.
 */
public suspend inline fun EmrClient.listInstances(crossinline block: ListInstancesRequest.Builder.() -> Unit): ListInstancesResponse = listInstances(ListInstancesRequest.Builder().apply(block).build())

/**
 * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status, time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a longer notebook execution list across multiple `ListNotebookExecution` calls.
 */
public suspend inline fun EmrClient.listNotebookExecutions(crossinline block: ListNotebookExecutionsRequest.Builder.() -> Unit): ListNotebookExecutionsResponse = listNotebookExecutions(ListNotebookExecutionsRequest.Builder().apply(block).build())

/**
 * Retrieves release labels of EMR services in the region where the API is called.
 */
public suspend inline fun EmrClient.listReleaseLabels(crossinline block: ListReleaseLabelsRequest.Builder.() -> Unit): ListReleaseLabelsResponse = listReleaseLabels(ListReleaseLabelsRequest.Builder().apply(block).build())

/**
 * Lists all the security configurations visible to this account, providing their creation dates and times, and their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple ListSecurityConfigurations calls.
 */
public suspend inline fun EmrClient.listSecurityConfigurations(crossinline block: ListSecurityConfigurationsRequest.Builder.() -> Unit): ListSecurityConfigurationsResponse = listSecurityConfigurations(ListSecurityConfigurationsRequest.Builder().apply(block).build())

/**
 * Provides a list of steps for the cluster in reverse order unless you specify `stepIds` with the request or filter by `StepStates`. You can specify a maximum of 10 `stepIDs`. The CLI automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the CLI, specify a `Marker`, which is a pagination token that indicates the next set of steps to retrieve.
 */
public suspend inline fun EmrClient.listSteps(crossinline block: ListStepsRequest.Builder.() -> Unit): ListStepsResponse = listSteps(ListStepsRequest.Builder().apply(block).build())

/**
 * Returns a list of all user or group session mappings for the Amazon EMR Studio specified by `StudioId`.
 */
public suspend inline fun EmrClient.listStudioSessionMappings(crossinline block: ListStudioSessionMappingsRequest.Builder.() -> Unit): ListStudioSessionMappingsResponse = listStudioSessionMappings(ListStudioSessionMappingsRequest.Builder().apply(block).build())

/**
 * Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes details such as ID, Studio Access URL, and creation time for each Studio.
 */
public suspend inline fun EmrClient.listStudios(crossinline block: ListStudiosRequest.Builder.() -> Unit): ListStudiosResponse = listStudios(ListStudiosRequest.Builder().apply(block).build())

/**
 * Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.
 */
public suspend inline fun EmrClient.modifyCluster(crossinline block: ModifyClusterRequest.Builder.() -> Unit): ModifyClusterResponse = modifyCluster(ModifyClusterRequest.Builder().apply(block).build())

/**
 * Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.
 *
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 */
public suspend inline fun EmrClient.modifyInstanceFleet(crossinline block: ModifyInstanceFleetRequest.Builder.() -> Unit): ModifyInstanceFleetResponse = modifyInstanceFleet(ModifyInstanceFleetRequest.Builder().apply(block).build())

/**
 * ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input parameters include the new target instance count for the group and the instance group ID. The call will either succeed or fail atomically.
 */
public suspend inline fun EmrClient.modifyInstanceGroups(crossinline block: ModifyInstanceGroupsRequest.Builder.() -> Unit): ModifyInstanceGroupsResponse = modifyInstanceGroups(ModifyInstanceGroupsRequest.Builder().apply(block).build())

/**
 * Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric.
 */
public suspend inline fun EmrClient.putAutoScalingPolicy(crossinline block: PutAutoScalingPolicyRequest.Builder.() -> Unit): PutAutoScalingPolicyResponse = putAutoScalingPolicy(PutAutoScalingPolicyRequest.Builder().apply(block).build())

/**
 * Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see [Using an auto-termination policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html).
 *
 * Creates or updates an auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see [Control cluster termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html).
 */
public suspend inline fun EmrClient.putAutoTerminationPolicy(crossinline block: PutAutoTerminationPolicyRequest.Builder.() -> Unit): PutAutoTerminationPolicyResponse = putAutoTerminationPolicy(PutAutoTerminationPolicyRequest.Builder().apply(block).build())

/**
 * Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see [Configure Block Public Access for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html) in the *Amazon EMR Management Guide*.
 */
public suspend inline fun EmrClient.putBlockPublicAccessConfiguration(crossinline block: PutBlockPublicAccessConfigurationRequest.Builder.() -> Unit): PutBlockPublicAccessConfigurationResponse = putBlockPublicAccessConfiguration(PutBlockPublicAccessConfigurationRequest.Builder().apply(block).build())

/**
 * Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
 */
public suspend inline fun EmrClient.putManagedScalingPolicy(crossinline block: PutManagedScalingPolicyRequest.Builder.() -> Unit): PutManagedScalingPolicyResponse = putManagedScalingPolicy(PutManagedScalingPolicyRequest.Builder().apply(block).build())

/**
 * Removes an automatic scaling policy from a specified instance group within an EMR cluster.
 */
public suspend inline fun EmrClient.removeAutoScalingPolicy(crossinline block: RemoveAutoScalingPolicyRequest.Builder.() -> Unit): RemoveAutoScalingPolicyResponse = removeAutoScalingPolicy(RemoveAutoScalingPolicyRequest.Builder().apply(block).build())

/**
 * Removes an auto-termination policy from an Amazon EMR cluster.
 */
public suspend inline fun EmrClient.removeAutoTerminationPolicy(crossinline block: RemoveAutoTerminationPolicyRequest.Builder.() -> Unit): RemoveAutoTerminationPolicyResponse = removeAutoTerminationPolicy(RemoveAutoTerminationPolicyRequest.Builder().apply(block).build())

/**
 * Removes a managed scaling policy from a specified EMR cluster.
 */
public suspend inline fun EmrClient.removeManagedScalingPolicy(crossinline block: RemoveManagedScalingPolicyRequest.Builder.() -> Unit): RemoveManagedScalingPolicyResponse = removeManagedScalingPolicy(RemoveManagedScalingPolicyRequest.Builder().apply(block).build())

/**
 * Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see [Tag Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
 *
 * The following example removes the stack tag with value Prod from a cluster:
 */
public suspend inline fun EmrClient.removeTags(crossinline block: RemoveTagsRequest.Builder.() -> Unit): RemoveTagsResponse = removeTags(RemoveTagsRequest.Builder().apply(block).build())

/**
 * RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last step of the job flow to store results in Amazon S3. If the JobFlowInstancesConfig`KeepJobFlowAliveWhenNoSteps` parameter is set to `TRUE`, the cluster transitions to the WAITING state rather than shutting down after the steps have completed.
 *
 * For additional protection, you can set the JobFlowInstancesConfig`TerminationProtected` parameter to `TRUE` to lock the cluster and prevent it from being terminated by API call, user intervention, or in the event of a job flow error.
 *
 * A maximum of 256 steps are allowed in each job flow.
 *
 * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using the SSH shell to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop.
 *
 * For long-running clusters, we recommend that you periodically store your results.
 *
 * The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. The RunJobFlow request can contain InstanceFleets parameters or InstanceGroups parameters, but not both.
 */
public suspend inline fun EmrClient.runJobFlow(crossinline block: RunJobFlowRequest.Builder.() -> Unit): RunJobFlowResponse = runJobFlow(RunJobFlowRequest.Builder().apply(block).build())

/**
 * SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful completion of the job flow. Calling `SetTerminationProtection` on a cluster is similar to calling the Amazon EC2 `DisableAPITermination` API on all EC2 instances in a cluster.
 *
 * `SetTerminationProtection` is used to prevent accidental termination of a cluster and to ensure that in the event of an error, the instances persist so that you can recover any data stored in their ephemeral instance storage.
 *
 *  To terminate a cluster that has been locked by setting `SetTerminationProtection` to `true`, you must first unlock the job flow by a subsequent call to `SetTerminationProtection` in which you set the value to `false`.
 *
 *  For more information, see[Managing Cluster Termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html) in the *Amazon EMR Management Guide*.
 */
public suspend inline fun EmrClient.setTerminationProtection(crossinline block: SetTerminationProtectionRequest.Builder.() -> Unit): SetTerminationProtectionResponse = setTerminationProtection(SetTerminationProtectionRequest.Builder().apply(block).build())

/**
 * The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your account. To restrict cluster access using an IAM policy, see [Identity and Access Management for EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html).
 *
 * Sets the Cluster$VisibleToAllUsers value for an EMR cluster. When `true`, IAM principals in the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When `false`, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions on the cluster, regardless of IAM permissions policies attached to other IAM principals.
 *
 * This action works on running clusters. When you create a cluster, use the RunJobFlowInput$VisibleToAllUsers parameter.
 *
 * For more information, see [Understanding the EMR Cluster VisibleToAllUsers Setting](https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users) in the *Amazon EMRManagement Guide*.
 */
public suspend inline fun EmrClient.setVisibleToAllUsers(crossinline block: SetVisibleToAllUsersRequest.Builder.() -> Unit): SetVisibleToAllUsersResponse = setVisibleToAllUsers(SetVisibleToAllUsersRequest.Builder().apply(block).build())

/**
 * Starts a notebook execution.
 */
public suspend inline fun EmrClient.startNotebookExecution(crossinline block: StartNotebookExecutionRequest.Builder.() -> Unit): StartNotebookExecutionResponse = startNotebookExecution(StartNotebookExecutionRequest.Builder().apply(block).build())

/**
 * Stops a notebook execution.
 */
public suspend inline fun EmrClient.stopNotebookExecution(crossinline block: StopNotebookExecutionRequest.Builder.() -> Unit): StopNotebookExecutionResponse = stopNotebookExecution(StopNotebookExecutionRequest.Builder().apply(block).build())

/**
 * TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.
 *
 * The maximum number of clusters allowed is 10. The call to `TerminateJobFlows` is asynchronous. Depending on the configuration of the cluster, it may take up to 1-5 minutes for the cluster to completely terminate and release allocated resources, such as Amazon EC2 instances.
 */
public suspend inline fun EmrClient.terminateJobFlows(crossinline block: TerminateJobFlowsRequest.Builder.() -> Unit): TerminateJobFlowsResponse = terminateJobFlows(TerminateJobFlowsRequest.Builder().apply(block).build())

/**
 * Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.
 */
public suspend inline fun EmrClient.updateStudio(crossinline block: UpdateStudioRequest.Builder.() -> Unit): UpdateStudioResponse = updateStudio(UpdateStudioRequest.Builder().apply(block).build())

/**
 * Updates the session policy attached to the user or group for the specified Amazon EMR Studio.
 */
public suspend inline fun EmrClient.updateStudioSessionMapping(crossinline block: UpdateStudioSessionMappingRequest.Builder.() -> Unit): UpdateStudioSessionMappingResponse = updateStudioSessionMapping(UpdateStudioSessionMappingRequest.Builder().apply(block).build())
