// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.serde

import aws.sdk.kotlin.services.elastictranscoder.model.Notifications
import aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdatePipelineOperationSerializer: HttpSerializer.NonStreaming<UpdatePipelineRequest> {
    override fun serialize(context: ExecutionContext, input: UpdatePipelineRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.id) { "id is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2012-09-25"))
                add(PercentEncoding.Path.encode("pipelines"))
                add(PercentEncoding.SmithyLabel.encode("${input.id}"))
            }
        }

        val payload = serializeUpdatePipelineOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdatePipelineOperationBody(context: ExecutionContext, input: UpdatePipelineRequest): ByteArray {
    val serializer = JsonSerializer()
    val AWSKMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AwsKmsKeyArn"))
    val CONTENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ContentConfig"))
    val INPUTBUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InputBucket"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val NOTIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Notifications"))
    val ROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Role"))
    val THUMBNAILCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ThumbnailConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSKMSKEYARN_DESCRIPTOR)
        field(CONTENTCONFIG_DESCRIPTOR)
        field(INPUTBUCKET_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NOTIFICATIONS_DESCRIPTOR)
        field(ROLE_DESCRIPTOR)
        field(THUMBNAILCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.awsKmsKeyArn?.let { field(AWSKMSKEYARN_DESCRIPTOR, it) }
        input.contentConfig?.let { field(CONTENTCONFIG_DESCRIPTOR, it, ::serializePipelineOutputConfigDocument) }
        input.inputBucket?.let { field(INPUTBUCKET_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.notifications?.let { field(NOTIFICATIONS_DESCRIPTOR, it, ::serializeNotificationsDocument) }
        input.role?.let { field(ROLE_DESCRIPTOR, it) }
        input.thumbnailConfig?.let { field(THUMBNAILCONFIG_DESCRIPTOR, it, ::serializePipelineOutputConfigDocument) }
    }
    return serializer.toByteArray()
}
