// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The `CreateJobRequest` structure.
 */
public class CreateJobRequest private constructor(builder: Builder) {
    /**
     * A section of the request body that provides information about the file that is being transcoded.
     */
    public val input: aws.sdk.kotlin.services.elastictranscoder.model.JobInput? = builder.input
    /**
     * A section of the request body that provides information about the files that are being transcoded.
     */
    public val inputs: List<JobInput>? = builder.inputs
    /**
     * A section of the request body that provides information about the transcoded (target) file. We strongly recommend that you use the `Outputs` syntax instead of the `Output` syntax.
     */
    public val output: aws.sdk.kotlin.services.elastictranscoder.model.CreateJobOutput? = builder.output
    /**
     * The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists.
     */
    public val outputKeyPrefix: kotlin.String? = builder.outputKeyPrefix
    /**
     * A section of the request body that provides information about the transcoded (target) files. We recommend that you use the `Outputs` syntax instead of the `Output` syntax.
     */
    public val outputs: List<CreateJobOutput>? = builder.outputs
    /**
     * The `Id` of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files.
     */
    public val pipelineId: kotlin.String? = builder.pipelineId
    /**
     * If you specify a preset in `PresetId` for which the value of `Container` is fmp4 (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want Elastic Transcoder to create.
     *
     * The maximum number of master playlists in a job is 30.
     */
    public val playlists: List<CreateJobPlaylist>? = builder.playlists
    /**
     * User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in `key/value` pairs, and you can add up to 10 `key/value` pairs per job. Elastic Transcoder does not guarantee that `key/value` pairs are returned in the same order in which you specify them.
     */
    public val userMetadata: Map<String, String>? = builder.userMetadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.CreateJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobRequest(")
        append("input=$input,")
        append("inputs=$inputs,")
        append("output=$output,")
        append("outputKeyPrefix=$outputKeyPrefix,")
        append("outputs=$outputs,")
        append("pipelineId=$pipelineId,")
        append("playlists=$playlists,")
        append("userMetadata=$userMetadata")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = input?.hashCode() ?: 0
        result = 31 * result + (inputs?.hashCode() ?: 0)
        result = 31 * result + (output?.hashCode() ?: 0)
        result = 31 * result + (outputKeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (pipelineId?.hashCode() ?: 0)
        result = 31 * result + (playlists?.hashCode() ?: 0)
        result = 31 * result + (userMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobRequest

        if (input != other.input) return false
        if (inputs != other.inputs) return false
        if (output != other.output) return false
        if (outputKeyPrefix != other.outputKeyPrefix) return false
        if (outputs != other.outputs) return false
        if (pipelineId != other.pipelineId) return false
        if (playlists != other.playlists) return false
        if (userMetadata != other.userMetadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.CreateJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A section of the request body that provides information about the file that is being transcoded.
         */
        public var input: aws.sdk.kotlin.services.elastictranscoder.model.JobInput? = null
        /**
         * A section of the request body that provides information about the files that are being transcoded.
         */
        public var inputs: List<JobInput>? = null
        /**
         * A section of the request body that provides information about the transcoded (target) file. We strongly recommend that you use the `Outputs` syntax instead of the `Output` syntax.
         */
        public var output: aws.sdk.kotlin.services.elastictranscoder.model.CreateJobOutput? = null
        /**
         * The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists.
         */
        public var outputKeyPrefix: kotlin.String? = null
        /**
         * A section of the request body that provides information about the transcoded (target) files. We recommend that you use the `Outputs` syntax instead of the `Output` syntax.
         */
        public var outputs: List<CreateJobOutput>? = null
        /**
         * The `Id` of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files.
         */
        public var pipelineId: kotlin.String? = null
        /**
         * If you specify a preset in `PresetId` for which the value of `Container` is fmp4 (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the master playlists that you want Elastic Transcoder to create.
         *
         * The maximum number of master playlists in a job is 30.
         */
        public var playlists: List<CreateJobPlaylist>? = null
        /**
         * User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in `key/value` pairs, and you can add up to 10 `key/value` pairs per job. Elastic Transcoder does not guarantee that `key/value` pairs are returned in the same order in which you specify them.
         */
        public var userMetadata: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.CreateJobRequest) : this() {
            this.input = x.input
            this.inputs = x.inputs
            this.output = x.output
            this.outputKeyPrefix = x.outputKeyPrefix
            this.outputs = x.outputs
            this.pipelineId = x.pipelineId
            this.playlists = x.playlists
            this.userMetadata = x.userMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.CreateJobRequest = CreateJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.JobInput] inside the given [block]
         */
        public fun input(block: aws.sdk.kotlin.services.elastictranscoder.model.JobInput.Builder.() -> kotlin.Unit) {
            this.input = aws.sdk.kotlin.services.elastictranscoder.model.JobInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.CreateJobOutput] inside the given [block]
         */
        public fun output(block: aws.sdk.kotlin.services.elastictranscoder.model.CreateJobOutput.Builder.() -> kotlin.Unit) {
            this.output = aws.sdk.kotlin.services.elastictranscoder.model.CreateJobOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
