// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * Parameters required for transcoding audio.
 */
public class AudioParameters private constructor(builder: Builder) {
    /**
     * The method of organizing audio channels and tracks. Use `Audio:Channels` to specify the number of channels in your output, and `Audio:AudioPackingMode` to specify the number of tracks and their relation to the channels. If you do not specify an `Audio:AudioPackingMode`, Elastic Transcoder uses `SingleTrack`.
     *
     * The following values are valid:
     *
     * `SingleTrack`, `OneChannelPerTrack`, and `OneChannelPerTrackWithMosTo8Tracks`
     *
     * When you specify `SingleTrack`, Elastic Transcoder creates a single track for your output. The track can have up to eight channels. Use `SingleTrack` for all non-`mxf` containers.
     *
     * The outputs of `SingleTrack` for a specific channel value and inputs are as follows:
     * + `0`** channels with any input:** Audio omitted from the output
     * + `1, 2, or auto `**channels with no audio input:** Audio omitted from the output
     * + `1 `**channel with any input with audio:** One track with one channel, downmixed if necessary
     * + `2 `**channels with one track with one channel:** One track with two identical channels
     * + `2 or auto `**channels with two tracks with one channel each:** One track with two channels
     * + `2 or auto `**channels with one track with two channels:** One track with two channels
     * + `2 `**channels with one track with multiple channels:** One track with two channels
     * + `auto `**channels with one track with one channel:** One track with one channel
     * + `auto `**channels with one track with multiple channels:** One track with multiple channels
     *
     * When you specify `OneChannelPerTrack`, Elastic Transcoder creates a new track for every channel in your output. Your output can have up to eight single-channel tracks.
     *
     * The outputs of `OneChannelPerTrack` for a specific channel value and inputs are as follows:
     * + `0 `**channels with any input:** Audio omitted from the output
     * + `1, 2, or auto `**channels with no audio input:** Audio omitted from the output
     * + `1 `**channel with any input with audio:** One track with one channel, downmixed if necessary
     * + `2 `**channels with one track with one channel:** Two tracks with one identical channel each
     * + `2 or auto `**channels with two tracks with one channel each:** Two tracks with one channel each
     * + `2 or auto `**channels with one track with two channels:** Two tracks with one channel each
     * + `2 `**channels with one track with multiple channels:** Two tracks with one channel each
     * + `auto `**channels with one track with one channel:** One track with one channel
     * + `auto `**channels with one track with multiple channels:** Up to eight tracks with one channel each
     *
     * When you specify `OneChannelPerTrackWithMosTo8Tracks`, Elastic Transcoder creates eight single-channel tracks for your output. All tracks that do not contain audio data from an input channel are MOS, or Mit Out Sound, tracks.
     *
     * The outputs of `OneChannelPerTrackWithMosTo8Tracks` for a specific channel value and inputs are as follows:
     * + `0 `**channels with any input:** Audio omitted from the output
     * + `1, 2, or auto `**channels with no audio input:** Audio omitted from the output
     * + `1 `**channel with any input with audio:** One track with one channel, downmixed if necessary, plus six MOS tracks
     * + `2 `**channels with one track with one channel:** Two tracks with one identical channel each, plus six MOS tracks
     * + `2 or auto `**channels with two tracks with one channel each:** Two tracks with one channel each, plus six MOS tracks
     * + `2 or auto `**channels with one track with two channels:** Two tracks with one channel each, plus six MOS tracks
     * + `2 `**channels with one track with multiple channels:** Two tracks with one channel each, plus six MOS tracks
     * + `auto `**channels with one track with one channel:** One track with one channel, plus seven MOS tracks
     * + `auto `**channels with one track with multiple channels:** Up to eight tracks with one channel each, plus MOS tracks until there are eight tracks in all
     */
    public val audioPackingMode: kotlin.String? = builder.audioPackingMode
    /**
     * The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.
     */
    public val bitRate: kotlin.String? = builder.bitRate
    /**
     * The number of audio channels in the output file. The following values are valid:
     *
     * `auto`, `0`, `1`, `2`
     *
     * One channel carries the information played by a single speaker. For example, a stereo track with two channels sends one channel to the left speaker, and the other channel to the right speaker. The output channels are organized into tracks. If you want Elastic Transcoder to automatically detect the number of audio channels in the input file and use that value for the output file, select `auto`.
     *
     * The output of a specific channel value and inputs are as follows:
     * + `auto`** channel specified, with any input:** Pass through up to eight input channels.
     * + `0`** channels specified, with any input:** Audio omitted from the output.
     * + `1`** channel specified, with at least one input channel:** Mono sound.
     * + `2`** channels specified, with any input:** Two identical mono channels or stereo. For more information about tracks, see `Audio:AudioPackingMode.`
     *
     *  For more information about how Elastic Transcoder organizes channels and tracks, see `Audio:AudioPackingMode`.
     */
    public val channels: kotlin.String? = builder.channels
    /**
     * The audio codec for the output file. Valid values include `aac`, `flac`, `mp2`, `mp3`, `pcm`, and `vorbis`.
     */
    public val codec: kotlin.String? = builder.codec
    /**
     * If you specified `AAC` for `Audio:Codec`, this is the `AAC` compression profile to use. Valid values include:
     *
     * `auto`, `AAC-LC`, `HE-AAC`, `HE-AACv2`
     *
     * If you specify `auto`, Elastic Transcoder chooses a profile based on the bit rate of the output file.
     */
    public val codecOptions: aws.sdk.kotlin.services.elastictranscoder.model.AudioCodecOptions? = builder.codecOptions
    /**
     * The sample rate of the audio stream in the output file, in Hertz. Valid values include:
     *
     * `auto`, `22050`, `32000`, `44100`, `48000`, `96000`
     *
     * If you specify `auto`, Elastic Transcoder automatically detects the sample rate.
     */
    public val sampleRate: kotlin.String? = builder.sampleRate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.AudioParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudioParameters(")
        append("audioPackingMode=$audioPackingMode,")
        append("bitRate=$bitRate,")
        append("channels=$channels,")
        append("codec=$codec,")
        append("codecOptions=$codecOptions,")
        append("sampleRate=$sampleRate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioPackingMode?.hashCode() ?: 0
        result = 31 * result + (bitRate?.hashCode() ?: 0)
        result = 31 * result + (channels?.hashCode() ?: 0)
        result = 31 * result + (codec?.hashCode() ?: 0)
        result = 31 * result + (codecOptions?.hashCode() ?: 0)
        result = 31 * result + (sampleRate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudioParameters

        if (audioPackingMode != other.audioPackingMode) return false
        if (bitRate != other.bitRate) return false
        if (channels != other.channels) return false
        if (codec != other.codec) return false
        if (codecOptions != other.codecOptions) return false
        if (sampleRate != other.sampleRate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.AudioParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The method of organizing audio channels and tracks. Use `Audio:Channels` to specify the number of channels in your output, and `Audio:AudioPackingMode` to specify the number of tracks and their relation to the channels. If you do not specify an `Audio:AudioPackingMode`, Elastic Transcoder uses `SingleTrack`.
         *
         * The following values are valid:
         *
         * `SingleTrack`, `OneChannelPerTrack`, and `OneChannelPerTrackWithMosTo8Tracks`
         *
         * When you specify `SingleTrack`, Elastic Transcoder creates a single track for your output. The track can have up to eight channels. Use `SingleTrack` for all non-`mxf` containers.
         *
         * The outputs of `SingleTrack` for a specific channel value and inputs are as follows:
         * + `0`** channels with any input:** Audio omitted from the output
         * + `1, 2, or auto `**channels with no audio input:** Audio omitted from the output
         * + `1 `**channel with any input with audio:** One track with one channel, downmixed if necessary
         * + `2 `**channels with one track with one channel:** One track with two identical channels
         * + `2 or auto `**channels with two tracks with one channel each:** One track with two channels
         * + `2 or auto `**channels with one track with two channels:** One track with two channels
         * + `2 `**channels with one track with multiple channels:** One track with two channels
         * + `auto `**channels with one track with one channel:** One track with one channel
         * + `auto `**channels with one track with multiple channels:** One track with multiple channels
         *
         * When you specify `OneChannelPerTrack`, Elastic Transcoder creates a new track for every channel in your output. Your output can have up to eight single-channel tracks.
         *
         * The outputs of `OneChannelPerTrack` for a specific channel value and inputs are as follows:
         * + `0 `**channels with any input:** Audio omitted from the output
         * + `1, 2, or auto `**channels with no audio input:** Audio omitted from the output
         * + `1 `**channel with any input with audio:** One track with one channel, downmixed if necessary
         * + `2 `**channels with one track with one channel:** Two tracks with one identical channel each
         * + `2 or auto `**channels with two tracks with one channel each:** Two tracks with one channel each
         * + `2 or auto `**channels with one track with two channels:** Two tracks with one channel each
         * + `2 `**channels with one track with multiple channels:** Two tracks with one channel each
         * + `auto `**channels with one track with one channel:** One track with one channel
         * + `auto `**channels with one track with multiple channels:** Up to eight tracks with one channel each
         *
         * When you specify `OneChannelPerTrackWithMosTo8Tracks`, Elastic Transcoder creates eight single-channel tracks for your output. All tracks that do not contain audio data from an input channel are MOS, or Mit Out Sound, tracks.
         *
         * The outputs of `OneChannelPerTrackWithMosTo8Tracks` for a specific channel value and inputs are as follows:
         * + `0 `**channels with any input:** Audio omitted from the output
         * + `1, 2, or auto `**channels with no audio input:** Audio omitted from the output
         * + `1 `**channel with any input with audio:** One track with one channel, downmixed if necessary, plus six MOS tracks
         * + `2 `**channels with one track with one channel:** Two tracks with one identical channel each, plus six MOS tracks
         * + `2 or auto `**channels with two tracks with one channel each:** Two tracks with one channel each, plus six MOS tracks
         * + `2 or auto `**channels with one track with two channels:** Two tracks with one channel each, plus six MOS tracks
         * + `2 `**channels with one track with multiple channels:** Two tracks with one channel each, plus six MOS tracks
         * + `auto `**channels with one track with one channel:** One track with one channel, plus seven MOS tracks
         * + `auto `**channels with one track with multiple channels:** Up to eight tracks with one channel each, plus MOS tracks until there are eight tracks in all
         */
        public var audioPackingMode: kotlin.String? = null
        /**
         * The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.
         */
        public var bitRate: kotlin.String? = null
        /**
         * The number of audio channels in the output file. The following values are valid:
         *
         * `auto`, `0`, `1`, `2`
         *
         * One channel carries the information played by a single speaker. For example, a stereo track with two channels sends one channel to the left speaker, and the other channel to the right speaker. The output channels are organized into tracks. If you want Elastic Transcoder to automatically detect the number of audio channels in the input file and use that value for the output file, select `auto`.
         *
         * The output of a specific channel value and inputs are as follows:
         * + `auto`** channel specified, with any input:** Pass through up to eight input channels.
         * + `0`** channels specified, with any input:** Audio omitted from the output.
         * + `1`** channel specified, with at least one input channel:** Mono sound.
         * + `2`** channels specified, with any input:** Two identical mono channels or stereo. For more information about tracks, see `Audio:AudioPackingMode.`
         *
         *  For more information about how Elastic Transcoder organizes channels and tracks, see `Audio:AudioPackingMode`.
         */
        public var channels: kotlin.String? = null
        /**
         * The audio codec for the output file. Valid values include `aac`, `flac`, `mp2`, `mp3`, `pcm`, and `vorbis`.
         */
        public var codec: kotlin.String? = null
        /**
         * If you specified `AAC` for `Audio:Codec`, this is the `AAC` compression profile to use. Valid values include:
         *
         * `auto`, `AAC-LC`, `HE-AAC`, `HE-AACv2`
         *
         * If you specify `auto`, Elastic Transcoder chooses a profile based on the bit rate of the output file.
         */
        public var codecOptions: aws.sdk.kotlin.services.elastictranscoder.model.AudioCodecOptions? = null
        /**
         * The sample rate of the audio stream in the output file, in Hertz. Valid values include:
         *
         * `auto`, `22050`, `32000`, `44100`, `48000`, `96000`
         *
         * If you specify `auto`, Elastic Transcoder automatically detects the sample rate.
         */
        public var sampleRate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.AudioParameters) : this() {
            this.audioPackingMode = x.audioPackingMode
            this.bitRate = x.bitRate
            this.channels = x.channels
            this.codec = x.codec
            this.codecOptions = x.codecOptions
            this.sampleRate = x.sampleRate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.AudioParameters = AudioParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.AudioCodecOptions] inside the given [block]
         */
        public fun codecOptions(block: aws.sdk.kotlin.services.elastictranscoder.model.AudioCodecOptions.Builder.() -> kotlin.Unit) {
            this.codecOptions = aws.sdk.kotlin.services.elastictranscoder.model.AudioCodecOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
