// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.waiters

import aws.sdk.kotlin.services.elastictranscoder.ElasticTranscoderClient
import aws.sdk.kotlin.services.elastictranscoder.model.ReadJobRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ReadJobResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun ElasticTranscoderClient.waitUntilJobComplete(request: ReadJobRequest): Outcome<ReadJobResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<ReadJobRequest, ReadJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val job = it.job
            val status = job?.status
            status == "Complete"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val job = it.job
            val status = job?.status
            status == "Canceled"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val job = it.job
            val status = job?.status
            status == "Error"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { readJob(request) }
}

public suspend fun ElasticTranscoderClient.waitUntilJobComplete(block: ReadJobRequest.Builder.() -> Unit): Outcome<ReadJobResponse> =
    waitUntilJobComplete(ReadJobRequest.Builder().apply(block).build())
