// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.serde

import aws.sdk.kotlin.services.elastictranscoder.model.DeletePresetResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ElasticTranscoderException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeletePresetOperationDeserializer: HttpDeserialize<DeletePresetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeletePresetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeletePresetError(context, call)
        }
        val builder = DeletePresetResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeletePresetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticTranscoderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "IncompatibleVersionException" -> IncompatibleVersionExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticTranscoderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
