// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.paginators

import aws.sdk.kotlin.services.elastictranscoder.ElasticTranscoderClient
import aws.sdk.kotlin.services.elastictranscoder.model.Job
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByPipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByPipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByStatusRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByStatusResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListPipelinesRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListPipelinesResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListPresetsRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListPresetsResponse
import aws.sdk.kotlin.services.elastictranscoder.model.Pipeline
import aws.sdk.kotlin.services.elastictranscoder.model.Preset
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListJobsByPipelineResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsByPipelineRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsByPipelineResponse]
 */
public fun ElasticTranscoderClient.listJobsByPipelinePaginated(initialRequest: ListJobsByPipelineRequest): Flow<ListJobsByPipelineResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listJobsByPipelinePaginated.listJobsByPipeline(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsByPipelineResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsByPipelineResponse]
 */
public fun ElasticTranscoderClient.listJobsByPipelinePaginated(block: ListJobsByPipelineRequest.Builder.() -> Unit): Flow<ListJobsByPipelineResponse> =
    listJobsByPipelinePaginated(ListJobsByPipelineRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobsByPipelinePaginated]
 * to access the nested member [Job]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Job]
 */
@JvmName("listJobsByPipelineResponseJob")
public fun Flow<ListJobsByPipelineResponse>.jobs(): Flow<Job> =
    transform() { response ->
        response.jobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobsByStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsByStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsByStatusResponse]
 */
public fun ElasticTranscoderClient.listJobsByStatusPaginated(initialRequest: ListJobsByStatusRequest): Flow<ListJobsByStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listJobsByStatusPaginated.listJobsByStatus(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsByStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsByStatusResponse]
 */
public fun ElasticTranscoderClient.listJobsByStatusPaginated(block: ListJobsByStatusRequest.Builder.() -> Unit): Flow<ListJobsByStatusResponse> =
    listJobsByStatusPaginated(ListJobsByStatusRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobsByStatusPaginated]
 * to access the nested member [Job]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Job]
 */
@JvmName("listJobsByStatusResponseJob")
public fun Flow<ListJobsByStatusResponse>.jobs(): Flow<Job> =
    transform() { response ->
        response.jobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPipelinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelinesResponse]
 */
public fun ElasticTranscoderClient.listPipelinesPaginated(initialRequest: ListPipelinesRequest = ListPipelinesRequest { }): Flow<ListPipelinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listPipelinesPaginated.listPipelines(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelinesResponse]
 */
public fun ElasticTranscoderClient.listPipelinesPaginated(block: ListPipelinesRequest.Builder.() -> Unit): Flow<ListPipelinesResponse> =
    listPipelinesPaginated(ListPipelinesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPipelinesPaginated]
 * to access the nested member [Pipeline]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Pipeline]
 */
@JvmName("listPipelinesResponsePipeline")
public fun Flow<ListPipelinesResponse>.pipelines(): Flow<Pipeline> =
    transform() { response ->
        response.pipelines?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPresetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPresetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPresetsResponse]
 */
public fun ElasticTranscoderClient.listPresetsPaginated(initialRequest: ListPresetsRequest = ListPresetsRequest { }): Flow<ListPresetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listPresetsPaginated.listPresets(req)
            cursor = result.nextPageToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPresetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPresetsResponse]
 */
public fun ElasticTranscoderClient.listPresetsPaginated(block: ListPresetsRequest.Builder.() -> Unit): Flow<ListPresetsResponse> =
    listPresetsPaginated(ListPresetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPresetsPaginated]
 * to access the nested member [Preset]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Preset]
 */
@JvmName("listPresetsResponsePreset")
public fun Flow<ListPresetsResponse>.presets(): Flow<Preset> =
    transform() { response ->
        response.presets?.forEach {
            emit(it)
        }
    }
