// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * Thumbnails for videos.
 */
public class Thumbnails private constructor(builder: Builder) {
    /**
     * To better control resolution and aspect ratio of thumbnails, we recommend that you use the values `MaxWidth`, `MaxHeight`, `SizingPolicy`, and `PaddingPolicy` instead of `Resolution` and `AspectRatio`. The two groups of settings are mutually exclusive. Do not use them together.
     *
     * The aspect ratio of thumbnails. Valid values include:
     *
     * `auto`, `1:1`, `4:3`, `3:2`, `16:9`
     *
     * If you specify `auto`, Elastic Transcoder tries to preserve the aspect ratio of the video in the output file.
     */
    public val aspectRatio: kotlin.String? = builder.aspectRatio
    /**
     * The format of thumbnails, if any. Valid values are `jpg` and `png`.
     *
     * You specify whether you want Elastic Transcoder to create thumbnails when you create a job.
     */
    public val format: kotlin.String? = builder.format
    /**
     * The approximate number of seconds between thumbnails. Specify an integer value.
     */
    public val interval: kotlin.String? = builder.interval
    /**
     * The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072.
     */
    public val maxHeight: kotlin.String? = builder.maxHeight
    /**
     * The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096.
     */
    public val maxWidth: kotlin.String? = builder.maxWidth
    /**
     * When you set `PaddingPolicy` to `Pad`, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail `MaxWidth` and `MaxHeight` settings.
     */
    public val paddingPolicy: kotlin.String? = builder.paddingPolicy
    /**
     * To better control resolution and aspect ratio of thumbnails, we recommend that you use the values `MaxWidth`, `MaxHeight`, `SizingPolicy`, and `PaddingPolicy` instead of `Resolution` and `AspectRatio`. The two groups of settings are mutually exclusive. Do not use them together.
     *
     * The width and height of thumbnail files in pixels. Specify a value in the format ` <i>width</i> ` x ` <i>height</i> ` where both values are even integers. The values cannot exceed the width and height that you specified in the `Video:Resolution` object.
     */
    public val resolution: kotlin.String? = builder.resolution
    /**
     * Specify one of the following values to control scaling of thumbnails:
     * + `Fit`: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail MaxWidth or MaxHeight settings without exceeding the other value.
     * + `Fill`: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail `MaxWidth` or `MaxHeight` settings and matches or exceeds the other value. Elastic Transcoder centers the image in thumbnails and then crops in the dimension (if any) that exceeds the maximum value.
     * + `Stretch`: Elastic Transcoder stretches thumbnails to match the values that you specified for thumbnail `MaxWidth` and `MaxHeight` settings. If the relative proportions of the input video and thumbnails are different, the thumbnails will be distorted.
     * + `Keep`: Elastic Transcoder does not scale thumbnails. If either dimension of the input video exceeds the values that you specified for thumbnail `MaxWidth` and `MaxHeight` settings, Elastic Transcoder crops the thumbnails.
     * + `ShrinkToFit`: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of thumbnail `MaxWidth` and `MaxHeight` without exceeding either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.
     * + `ShrinkToFill`: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of `MaxWidth` and `MaxHeight` without dropping below either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.
     */
    public val sizingPolicy: kotlin.String? = builder.sizingPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Thumbnails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Thumbnails(")
        append("aspectRatio=$aspectRatio,")
        append("format=$format,")
        append("interval=$interval,")
        append("maxHeight=$maxHeight,")
        append("maxWidth=$maxWidth,")
        append("paddingPolicy=$paddingPolicy,")
        append("resolution=$resolution,")
        append("sizingPolicy=$sizingPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aspectRatio?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (interval?.hashCode() ?: 0)
        result = 31 * result + (maxHeight?.hashCode() ?: 0)
        result = 31 * result + (maxWidth?.hashCode() ?: 0)
        result = 31 * result + (paddingPolicy?.hashCode() ?: 0)
        result = 31 * result + (resolution?.hashCode() ?: 0)
        result = 31 * result + (sizingPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Thumbnails

        if (aspectRatio != other.aspectRatio) return false
        if (format != other.format) return false
        if (interval != other.interval) return false
        if (maxHeight != other.maxHeight) return false
        if (maxWidth != other.maxWidth) return false
        if (paddingPolicy != other.paddingPolicy) return false
        if (resolution != other.resolution) return false
        if (sizingPolicy != other.sizingPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Thumbnails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * To better control resolution and aspect ratio of thumbnails, we recommend that you use the values `MaxWidth`, `MaxHeight`, `SizingPolicy`, and `PaddingPolicy` instead of `Resolution` and `AspectRatio`. The two groups of settings are mutually exclusive. Do not use them together.
         *
         * The aspect ratio of thumbnails. Valid values include:
         *
         * `auto`, `1:1`, `4:3`, `3:2`, `16:9`
         *
         * If you specify `auto`, Elastic Transcoder tries to preserve the aspect ratio of the video in the output file.
         */
        public var aspectRatio: kotlin.String? = null
        /**
         * The format of thumbnails, if any. Valid values are `jpg` and `png`.
         *
         * You specify whether you want Elastic Transcoder to create thumbnails when you create a job.
         */
        public var format: kotlin.String? = null
        /**
         * The approximate number of seconds between thumbnails. Specify an integer value.
         */
        public var interval: kotlin.String? = null
        /**
         * The maximum height of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072.
         */
        public var maxHeight: kotlin.String? = null
        /**
         * The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096.
         */
        public var maxWidth: kotlin.String? = null
        /**
         * When you set `PaddingPolicy` to `Pad`, Elastic Transcoder may add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail `MaxWidth` and `MaxHeight` settings.
         */
        public var paddingPolicy: kotlin.String? = null
        /**
         * To better control resolution and aspect ratio of thumbnails, we recommend that you use the values `MaxWidth`, `MaxHeight`, `SizingPolicy`, and `PaddingPolicy` instead of `Resolution` and `AspectRatio`. The two groups of settings are mutually exclusive. Do not use them together.
         *
         * The width and height of thumbnail files in pixels. Specify a value in the format ` <i>width</i> ` x ` <i>height</i> ` where both values are even integers. The values cannot exceed the width and height that you specified in the `Video:Resolution` object.
         */
        public var resolution: kotlin.String? = null
        /**
         * Specify one of the following values to control scaling of thumbnails:
         * + `Fit`: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail MaxWidth or MaxHeight settings without exceeding the other value.
         * + `Fill`: Elastic Transcoder scales thumbnails so they match the value that you specified in thumbnail `MaxWidth` or `MaxHeight` settings and matches or exceeds the other value. Elastic Transcoder centers the image in thumbnails and then crops in the dimension (if any) that exceeds the maximum value.
         * + `Stretch`: Elastic Transcoder stretches thumbnails to match the values that you specified for thumbnail `MaxWidth` and `MaxHeight` settings. If the relative proportions of the input video and thumbnails are different, the thumbnails will be distorted.
         * + `Keep`: Elastic Transcoder does not scale thumbnails. If either dimension of the input video exceeds the values that you specified for thumbnail `MaxWidth` and `MaxHeight` settings, Elastic Transcoder crops the thumbnails.
         * + `ShrinkToFit`: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of thumbnail `MaxWidth` and `MaxHeight` without exceeding either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.
         * + `ShrinkToFill`: Elastic Transcoder scales thumbnails down so that their dimensions match the values that you specified for at least one of `MaxWidth` and `MaxHeight` without dropping below either value. If you specify this option, Elastic Transcoder does not scale thumbnails up.
         */
        public var sizingPolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Thumbnails) : this() {
            this.aspectRatio = x.aspectRatio
            this.format = x.format
            this.interval = x.interval
            this.maxHeight = x.maxHeight
            this.maxWidth = x.maxWidth
            this.paddingPolicy = x.paddingPolicy
            this.resolution = x.resolution
            this.sizingPolicy = x.sizingPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Thumbnails = Thumbnails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
