// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The `Permission` structure.
 */
public class Permission private constructor(builder: Builder) {
    /**
     * The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
     * + `READ`: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     * + `READ_ACP`: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     * + `WRITE_ACP`: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     * + `FULL_CONTROL`: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     */
    public val access: List<String>? = builder.access
    /**
     * The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
     */
    public val grantee: kotlin.String? = builder.grantee
    /**
     * The type of value that appears in the Grantee object:
     * + `Canonical`: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.A canonical user ID is not the same as an AWS account number.
     * + `Email`: The registered email address of an AWS account.
     * + `Group`: One of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
     */
    public val granteeType: kotlin.String? = builder.granteeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Permission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Permission(")
        append("access=$access,")
        append("grantee=$grantee,")
        append("granteeType=$granteeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = access?.hashCode() ?: 0
        result = 31 * result + (grantee?.hashCode() ?: 0)
        result = 31 * result + (granteeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Permission

        if (access != other.access) return false
        if (grantee != other.grantee) return false
        if (granteeType != other.granteeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Permission = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
         * + `READ`: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         * + `READ_ACP`: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         * + `WRITE_ACP`: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         * + `FULL_CONTROL`: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         */
        public var access: List<String>? = null
        /**
         * The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
         */
        public var grantee: kotlin.String? = null
        /**
         * The type of value that appears in the Grantee object:
         * + `Canonical`: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.A canonical user ID is not the same as an AWS account number.
         * + `Email`: The registered email address of an AWS account.
         * + `Group`: One of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
         */
        public var granteeType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Permission) : this() {
            this.access = x.access
            this.grantee = x.grantee
            this.granteeType = x.granteeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Permission = Permission(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
