// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.elastictranscoder.auth.DefaultElasticTranscoderAuthSchemeProvider
import aws.sdk.kotlin.services.elastictranscoder.auth.ElasticTranscoderAuthSchemeProvider
import aws.sdk.kotlin.services.elastictranscoder.endpoints.DefaultElasticTranscoderEndpointProvider
import aws.sdk.kotlin.services.elastictranscoder.endpoints.ElasticTranscoderEndpointParameters
import aws.sdk.kotlin.services.elastictranscoder.endpoints.ElasticTranscoderEndpointProvider
import aws.sdk.kotlin.services.elastictranscoder.model.CancelJobRequest
import aws.sdk.kotlin.services.elastictranscoder.model.CancelJobResponse
import aws.sdk.kotlin.services.elastictranscoder.model.CreateJobRequest
import aws.sdk.kotlin.services.elastictranscoder.model.CreateJobResponse
import aws.sdk.kotlin.services.elastictranscoder.model.CreatePipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.CreatePipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.CreatePresetRequest
import aws.sdk.kotlin.services.elastictranscoder.model.CreatePresetResponse
import aws.sdk.kotlin.services.elastictranscoder.model.DeletePipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.DeletePipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.DeletePresetRequest
import aws.sdk.kotlin.services.elastictranscoder.model.DeletePresetResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByPipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByPipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByStatusRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByStatusResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListPipelinesRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListPipelinesResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListPresetsRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListPresetsResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ReadJobRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ReadJobResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ReadPipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ReadPipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ReadPresetRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ReadPresetResponse
import aws.sdk.kotlin.services.elastictranscoder.model.TestRoleRequest
import aws.sdk.kotlin.services.elastictranscoder.model.TestRoleResponse
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineNotificationsRequest
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineNotificationsResponse
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineStatusRequest
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineStatusResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Elastic Transcoder"
public const val SdkVersion: String = "1.0.31"
public const val ServiceApiVersion: String = "2012-09-25"

/**
 * # AWS Elastic Transcoder Service
 * The AWS Elastic Transcoder Service.
 */
public interface ElasticTranscoderClient : SdkClient {
    /**
     * ElasticTranscoderClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ElasticTranscoderClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ElasticTranscoder",
                "ELASTIC_TRANSCODER",
                "elastic_transcoder",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ElasticTranscoderClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ElasticTranscoderClient = DefaultElasticTranscoderClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ElasticTranscoderEndpointProvider = builder.endpointProvider ?: DefaultElasticTranscoderEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ElasticTranscoderAuthSchemeProvider = builder.authSchemeProvider ?: DefaultElasticTranscoderAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Elastic Transcoder"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ElasticTranscoderEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ElasticTranscoderAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * The CancelJob operation cancels an unfinished job.
     *
     * You can only cancel a job that has a status of `Submitted`. To prevent a pipeline from starting to process a job while you're getting the job identifier, use UpdatePipelineStatus to temporarily pause the pipeline.
     */
    public suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus information about the job that is created.
     *
     * If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed to the AWS Console).
     */
    public suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * The CreatePipeline operation creates a pipeline with settings that you specify.
     */
    public suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse

    /**
     * The CreatePreset operation creates a preset with settings that you specify.
     *
     * Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic Transcoder returns an HTTP 400 response (`ValidationException`) and does not create the preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard, Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the video that Elastic Transcoder produces.
     *
     * Elastic Transcoder uses the H.264 video-compression format. For more information, see the International Telecommunication Union publication *Recommendation ITU-T H.264: Advanced video coding for generic audiovisual services*.
     */
    public suspend fun createPreset(input: CreatePresetRequest): CreatePresetResponse

    /**
     * The DeletePipeline operation removes a pipeline.
     *
     *  You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any active jobs). If the pipeline is currently in use, `DeletePipeline` returns an error.
     */
    public suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse

    /**
     * The DeletePreset operation removes a preset that you've added in an AWS region.
     *
     * You can't delete the default presets that are included with Elastic Transcoder.
     */
    public suspend fun deletePreset(input: DeletePresetRequest): DeletePresetResponse

    /**
     * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
     *
     * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one element for each job that satisfies the search criteria.
     */
    public suspend fun listJobsByPipeline(input: ListJobsByPipelineRequest): ListJobsByPipelineResponse

    /**
     * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one element for each job that satisfies the search criteria.
     */
    public suspend fun listJobsByStatus(input: ListJobsByStatusRequest): ListJobsByStatusResponse

    /**
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     */
    public suspend fun listPipelines(input: ListPipelinesRequest = ListPipelinesRequest { }): ListPipelinesResponse

    /**
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets that you've added in an AWS region.
     */
    public suspend fun listPresets(input: ListPresetsRequest = ListPresetsRequest { }): ListPresetsResponse

    /**
     * The ReadJob operation returns detailed information about a job.
     */
    public suspend fun readJob(input: ReadJobRequest): ReadJobResponse

    /**
     * The ReadPipeline operation gets detailed information about a pipeline.
     */
    public suspend fun readPipeline(input: ReadPipelineRequest): ReadPipelineResponse

    /**
     * The ReadPreset operation gets detailed information about a preset.
     */
    public suspend fun readPreset(input: ReadPresetRequest): ReadPresetResponse

    /**
     * The TestRole operation tests the IAM role used to create the pipeline.
     *
     * The `TestRole` action lets you determine whether the IAM role you are using has sufficient permissions to let Elastic Transcoder perform tasks associated with the transcoding process. The action attempts to assume the specified IAM role, checks read access to the input and output buckets, and tries to send a test notification to Amazon SNS topics that you specify.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun testRole(input: TestRoleRequest): TestRoleResponse

    /**
     * Use the `UpdatePipeline` operation to update settings for a pipeline.
     *
     * When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you change settings.
     */
    public suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse

    /**
     * With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS) notifications for a pipeline.
     *
     * When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the request.
     */
    public suspend fun updatePipelineNotifications(input: UpdatePipelineNotificationsRequest): UpdatePipelineNotificationsResponse

    /**
     * The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the processing of jobs.
     *
     * Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you have more time to get the job IDs for the jobs that you want to cancel, and to send a CancelJob request.
     */
    public suspend fun updatePipelineStatus(input: UpdatePipelineStatusRequest): UpdatePipelineStatusResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ElasticTranscoderClient.withConfig(block: ElasticTranscoderClient.Config.Builder.() -> Unit): ElasticTranscoderClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultElasticTranscoderClient(newConfig)
}

/**
 * The CancelJob operation cancels an unfinished job.
 *
 * You can only cancel a job that has a status of `Submitted`. To prevent a pipeline from starting to process a job while you're getting the job identifier, use UpdatePipelineStatus to temporarily pause the pipeline.
 */
public suspend inline fun ElasticTranscoderClient.cancelJob(crossinline block: CancelJobRequest.Builder.() -> Unit): CancelJobResponse = cancelJob(CancelJobRequest.Builder().apply(block).build())

/**
 * When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus information about the job that is created.
 *
 * If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed to the AWS Console).
 */
public suspend inline fun ElasticTranscoderClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit): CreateJobResponse = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * The CreatePipeline operation creates a pipeline with settings that you specify.
 */
public suspend inline fun ElasticTranscoderClient.createPipeline(crossinline block: CreatePipelineRequest.Builder.() -> Unit): CreatePipelineResponse = createPipeline(CreatePipelineRequest.Builder().apply(block).build())

/**
 * The CreatePreset operation creates a preset with settings that you specify.
 *
 * Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic Transcoder returns an HTTP 400 response (`ValidationException`) and does not create the preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard, Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the video that Elastic Transcoder produces.
 *
 * Elastic Transcoder uses the H.264 video-compression format. For more information, see the International Telecommunication Union publication *Recommendation ITU-T H.264: Advanced video coding for generic audiovisual services*.
 */
public suspend inline fun ElasticTranscoderClient.createPreset(crossinline block: CreatePresetRequest.Builder.() -> Unit): CreatePresetResponse = createPreset(CreatePresetRequest.Builder().apply(block).build())

/**
 * The DeletePipeline operation removes a pipeline.
 *
 *  You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any active jobs). If the pipeline is currently in use, `DeletePipeline` returns an error.
 */
public suspend inline fun ElasticTranscoderClient.deletePipeline(crossinline block: DeletePipelineRequest.Builder.() -> Unit): DeletePipelineResponse = deletePipeline(DeletePipelineRequest.Builder().apply(block).build())

/**
 * The DeletePreset operation removes a preset that you've added in an AWS region.
 *
 * You can't delete the default presets that are included with Elastic Transcoder.
 */
public suspend inline fun ElasticTranscoderClient.deletePreset(crossinline block: DeletePresetRequest.Builder.() -> Unit): DeletePresetResponse = deletePreset(DeletePresetRequest.Builder().apply(block).build())

/**
 * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
 *
 * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one element for each job that satisfies the search criteria.
 */
public suspend inline fun ElasticTranscoderClient.listJobsByPipeline(crossinline block: ListJobsByPipelineRequest.Builder.() -> Unit): ListJobsByPipelineResponse = listJobsByPipeline(ListJobsByPipelineRequest.Builder().apply(block).build())

/**
 * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one element for each job that satisfies the search criteria.
 */
public suspend inline fun ElasticTranscoderClient.listJobsByStatus(crossinline block: ListJobsByStatusRequest.Builder.() -> Unit): ListJobsByStatusResponse = listJobsByStatus(ListJobsByStatusRequest.Builder().apply(block).build())

/**
 * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
 */
public suspend inline fun ElasticTranscoderClient.listPipelines(crossinline block: ListPipelinesRequest.Builder.() -> Unit): ListPipelinesResponse = listPipelines(ListPipelinesRequest.Builder().apply(block).build())

/**
 * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets that you've added in an AWS region.
 */
public suspend inline fun ElasticTranscoderClient.listPresets(crossinline block: ListPresetsRequest.Builder.() -> Unit): ListPresetsResponse = listPresets(ListPresetsRequest.Builder().apply(block).build())

/**
 * The ReadJob operation returns detailed information about a job.
 */
public suspend inline fun ElasticTranscoderClient.readJob(crossinline block: ReadJobRequest.Builder.() -> Unit): ReadJobResponse = readJob(ReadJobRequest.Builder().apply(block).build())

/**
 * The ReadPipeline operation gets detailed information about a pipeline.
 */
public suspend inline fun ElasticTranscoderClient.readPipeline(crossinline block: ReadPipelineRequest.Builder.() -> Unit): ReadPipelineResponse = readPipeline(ReadPipelineRequest.Builder().apply(block).build())

/**
 * The ReadPreset operation gets detailed information about a preset.
 */
public suspend inline fun ElasticTranscoderClient.readPreset(crossinline block: ReadPresetRequest.Builder.() -> Unit): ReadPresetResponse = readPreset(ReadPresetRequest.Builder().apply(block).build())

/**
 * The TestRole operation tests the IAM role used to create the pipeline.
 *
 * The `TestRole` action lets you determine whether the IAM role you are using has sufficient permissions to let Elastic Transcoder perform tasks associated with the transcoding process. The action attempts to assume the specified IAM role, checks read access to the input and output buckets, and tries to send a test notification to Amazon SNS topics that you specify.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun ElasticTranscoderClient.testRole(crossinline block: TestRoleRequest.Builder.() -> Unit): TestRoleResponse = testRole(TestRoleRequest.Builder().apply(block).build())

/**
 * Use the `UpdatePipeline` operation to update settings for a pipeline.
 *
 * When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you change settings.
 */
public suspend inline fun ElasticTranscoderClient.updatePipeline(crossinline block: UpdatePipelineRequest.Builder.() -> Unit): UpdatePipelineResponse = updatePipeline(UpdatePipelineRequest.Builder().apply(block).build())

/**
 * With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS) notifications for a pipeline.
 *
 * When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the request.
 */
public suspend inline fun ElasticTranscoderClient.updatePipelineNotifications(crossinline block: UpdatePipelineNotificationsRequest.Builder.() -> Unit): UpdatePipelineNotificationsResponse = updatePipelineNotifications(UpdatePipelineNotificationsRequest.Builder().apply(block).build())

/**
 * The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the processing of jobs.
 *
 * Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you have more time to get the job IDs for the jobs that you want to cancel, and to send a CancelJob request.
 */
public suspend inline fun ElasticTranscoderClient.updatePipelineStatus(crossinline block: UpdatePipelineStatusRequest.Builder.() -> Unit): UpdatePipelineStatusResponse = updatePipelineStatus(UpdatePipelineStatusRequest.Builder().apply(block).build())
