// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.transform

import aws.sdk.kotlin.services.elastictranscoder.model.ElasticTranscoderException
import aws.sdk.kotlin.services.elastictranscoder.model.Job
import aws.sdk.kotlin.services.elastictranscoder.model.ReadJobResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ReadJobOperationDeserializer: HttpDeserialize<ReadJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ReadJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwReadJobError(context, call)
        }
        val builder = ReadJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeReadJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwReadJobError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticTranscoderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "IncompatibleVersionException" -> IncompatibleVersionExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticTranscoderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeReadJobOperationBody(builder: ReadJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val JOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Job"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(JOB_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                JOB_DESCRIPTOR.index -> builder.job = deserializeJobDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
