// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.transform

import aws.sdk.kotlin.services.elastictranscoder.model.CreatePresetResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ElasticTranscoderException
import aws.sdk.kotlin.services.elastictranscoder.model.Preset
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePresetOperationDeserializer: HttpDeserialize<CreatePresetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreatePresetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreatePresetError(context, call)
        }
        val builder = CreatePresetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePresetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreatePresetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticTranscoderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "IncompatibleVersionException" -> IncompatibleVersionExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticTranscoderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePresetOperationBody(builder: CreatePresetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PRESET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Preset"))
    val WARNING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Warning"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PRESET_DESCRIPTOR)
        field(WARNING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PRESET_DESCRIPTOR.index -> builder.preset = deserializePresetDocument(deserializer)
                WARNING_DESCRIPTOR.index -> builder.warning = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
