// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The PlayReady DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.
 *
 * PlayReady DRM encrypts your media files using `aes-ctr` encryption.
 *
 * If you use DRM for an `HLSv3` playlist, your outputs must have a master playlist.
 */
public class PlayReadyDrm private constructor(builder: Builder) {
    /**
     * The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.
     */
    public val format: kotlin.String? = builder.format
    /**
     * The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your files. The initialization vector must be base64-encoded, and it must be exactly 8 bytes long before being base64-encoded. If no initialization vector is provided, Elastic Transcoder generates one for you.
     */
    public val initializationVector: kotlin.String? = builder.initializationVector
    /**
     * The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:
     *
     * `128`, `192`, or `256`.
     *
     * The key must also be encrypted by using AWS KMS.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The ID for your DRM key, so that your DRM license provider knows which key to provide.
     *
     * The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before inserting it into the PlayReady DRM headers. If you are unsure whether your license server provides your key ID in big or little endian, check with your DRM provider.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.
     */
    public val keyMd5: kotlin.String? = builder.keyMd5
    /**
     * The location of the license key required to play DRM content. The URL must be an absolute path, and is referenced by the PlayReady header. The PlayReady header is referenced in the protection header of the client manifest for Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags for HLS playlist outputs. An example URL looks like this: `https://www.example.com/exampleKey/`
     */
    public val licenseAcquisitionUrl: kotlin.String? = builder.licenseAcquisitionUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.PlayReadyDrm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlayReadyDrm(")
        append("format=$format,")
        append("initializationVector=$initializationVector,")
        append("key=$key,")
        append("keyId=$keyId,")
        append("keyMd5=$keyMd5,")
        append("licenseAcquisitionUrl=$licenseAcquisitionUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = format?.hashCode() ?: 0
        result = 31 * result + (initializationVector?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (keyMd5?.hashCode() ?: 0)
        result = 31 * result + (licenseAcquisitionUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlayReadyDrm

        if (format != other.format) return false
        if (initializationVector != other.initializationVector) return false
        if (key != other.key) return false
        if (keyId != other.keyId) return false
        if (keyMd5 != other.keyMd5) return false
        if (licenseAcquisitionUrl != other.licenseAcquisitionUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.PlayReadyDrm = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.
         */
        public var format: kotlin.String? = null
        /**
         * The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your files. The initialization vector must be base64-encoded, and it must be exactly 8 bytes long before being base64-encoded. If no initialization vector is provided, Elastic Transcoder generates one for you.
         */
        public var initializationVector: kotlin.String? = null
        /**
         * The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:
         *
         * `128`, `192`, or `256`.
         *
         * The key must also be encrypted by using AWS KMS.
         */
        public var key: kotlin.String? = null
        /**
         * The ID for your DRM key, so that your DRM license provider knows which key to provide.
         *
         * The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before inserting it into the PlayReady DRM headers. If you are unsure whether your license server provides your key ID in big or little endian, check with your DRM provider.
         */
        public var keyId: kotlin.String? = null
        /**
         * The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.
         */
        public var keyMd5: kotlin.String? = null
        /**
         * The location of the license key required to play DRM content. The URL must be an absolute path, and is referenced by the PlayReady header. The PlayReady header is referenced in the protection header of the client manifest for Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags for HLS playlist outputs. An example URL looks like this: `https://www.example.com/exampleKey/`
         */
        public var licenseAcquisitionUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.PlayReadyDrm) : this() {
            this.format = x.format
            this.initializationVector = x.initializationVector
            this.key = x.key
            this.keyId = x.keyId
            this.keyMd5 = x.keyMd5
            this.licenseAcquisitionUrl = x.licenseAcquisitionUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.PlayReadyDrm = PlayReadyDrm(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
