// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The `PipelineOutputConfig` structure.
 */
public class PipelineOutputConfig private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this value when all of the following are true:
     * + You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
     * + You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and playlists.
     * + You do not want to specify the permissions that Elastic Transcoder grants to the files.
     * + You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
     *
     * If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class, omit OutputBucket and specify values for `ContentConfig` and `ThumbnailConfig` instead.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * Optional. The `Permissions` object specifies which users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
     *
     * If you include `Permissions`, Elastic Transcoder grants only the permissions that you specify. It does not grant full permissions to the owner of the role specified by `Role`. If you want that user to have full control, you must explicitly grant full control to the user.
     *
     *  If you omit `Permissions`, Elastic Transcoder grants full control over the transcoded files and playlists to the owner of the role specified by `Role`, and grants no other permissions to any other user or group.
     */
    public val permissions: List<Permission>? = builder.permissions
    /**
     * The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
     */
    public val storageClass: kotlin.String? = builder.storageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipelineOutputConfig(")
        append("bucket=$bucket,")
        append("permissions=$permissions,")
        append("storageClass=$storageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipelineOutputConfig

        if (bucket != other.bucket) return false
        if (permissions != other.permissions) return false
        if (storageClass != other.storageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this value when all of the following are true:
         * + You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
         * + You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and playlists.
         * + You do not want to specify the permissions that Elastic Transcoder grants to the files.
         * + You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
         *
         * If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class, omit OutputBucket and specify values for `ContentConfig` and `ThumbnailConfig` instead.
         */
        public var bucket: kotlin.String? = null
        /**
         * Optional. The `Permissions` object specifies which users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
         *
         * If you include `Permissions`, Elastic Transcoder grants only the permissions that you specify. It does not grant full permissions to the owner of the role specified by `Role`. If you want that user to have full control, you must explicitly grant full control to the user.
         *
         *  If you omit `Permissions`, Elastic Transcoder grants full control over the transcoded files and playlists to the owner of the role specified by `Role`, and grants no other permissions to any other user or group.
         */
        public var permissions: List<Permission>? = null
        /**
         * The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
         */
        public var storageClass: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig) : this() {
            this.bucket = x.bucket
            this.permissions = x.permissions
            this.storageClass = x.storageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig = PipelineOutputConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
