// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * Outputs recommended instead.
 *
 * If you specified one output for a job, information about that output. If you specified multiple outputs for a job, the `Output` object lists information about the first output. This duplicates the information that is listed for the first output in the `Outputs` object.
 */
public class JobOutput private constructor(builder: Builder) {
    /**
     * The album art to be associated with the output file, if any.
     */
    public val albumArt: aws.sdk.kotlin.services.elastictranscoder.model.JobAlbumArt? = builder.albumArt
    /**
     * If Elastic Transcoder used a preset with a `ColorSpaceConversionMode` to transcode the output file, the `AppliedColorSpaceConversion` parameter shows the conversion used. If no `ColorSpaceConversionMode` was defined in the preset, this parameter is not be included in the job response.
     */
    public val appliedColorSpaceConversion: kotlin.String? = builder.appliedColorSpaceConversion
    /**
     * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:
     * + **Embedded:** Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.Valid input values include: `CEA-608 (EIA-608`, first non-empty channel only), `CEA-708 (EIA-708`, first non-empty channel only), and `mov-text`Valid outputs include: `mov-text`Elastic Transcoder supports a maximum of one embedded format per output.
     * + **Sidecar:** Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.Valid input values include: `dfxp` (first div element only), `ebu-tt`, `scc`, `smpt`, `srt`, `ttml` (first div element only), and `webvtt`Valid outputs include: `dfxp` (first div element only), `scc`, `srt`, and `webvtt`.
     *
     * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     *
     * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.
     *
     * To remove captions or leave the captions empty, set `Captions` to null. To pass through existing captions unchanged, set the `MergePolicy` to `MergeRetain`, and pass in a null `CaptionSources` array.
     *
     * For more information on embedded files, see the Subtitles Wikipedia page.
     *
     * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
     */
    public val captions: aws.sdk.kotlin.services.elastictranscoder.model.Captions? = builder.captions
    /**
     * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val composition: List<Clip>? = builder.composition
    /**
     * Duration of the output file, in seconds.
     */
    public val duration: kotlin.Long? = builder.duration
    /**
     * Duration of the output file, in milliseconds.
     */
    public val durationMillis: kotlin.Long? = builder.durationMillis
    /**
     * The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you choose to use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic Transcoder writes an unencrypted file to your Amazon S3 bucket.
     */
    public val encryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = builder.encryption
    /**
     * File size of the output file, in bytes.
     */
    public val fileSize: kotlin.Long? = builder.fileSize
    /**
     * Frame rate of the output file, in frames per second.
     */
    public val frameRate: kotlin.String? = builder.frameRate
    /**
     * Height of the output file, in pixels.
     */
    public val height: kotlin.Int? = builder.height
    /**
     * A sequential counter, starting with 1, that identifies an output among the outputs from the current job. In the Output syntax, this value is always 1.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the `OutputBucket` object in the pipeline that is specified by the pipeline ID.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The value of the `Id` object for the preset that you want to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To use a preset that you created, specify the preset ID that Elastic Transcoder returned in the response when you created the preset. You can also use the Elastic Transcoder system presets, which you can get with `ListPresets`.
     */
    public val presetId: kotlin.String? = builder.presetId
    /**
     * The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values:
     *
     * `auto`, `0`, `90`, `180`, `270`
     *
     *  The value `auto` generally works only if the file that you're transcoding contains rotation metadata.
     */
    public val rotate: kotlin.String? = builder.rotate
    /**
     * (Outputs in Fragmented MP4 or MPEG-TS format only.
     *
     * If you specify a preset in `PresetId` for which the value of `Container` is `fmp4` (Fragmented MP4) or `ts` (MPEG-TS), `SegmentDuration` is the target maximum duration of each segment in seconds. For `HLSv3` format playlists, each media segment is stored in a separate `.ts` file. For `HLSv4`, `MPEG-DASH`, and `Smooth` playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the `SegmentDuration`, though individual segments might be shorter or longer.
     *
     * The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by `SegmentDuration`, the duration of the last segment is the remainder of total length/SegmentDuration.
     *
     * Elastic Transcoder creates an output-specific playlist for each output `HLS` output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the `OutputKeys` of the associated playlist.
     */
    public val segmentDuration: kotlin.String? = builder.segmentDuration
    /**
     * The status of one output in a job. If you specified only one output for the job, `Outputs:Status` is always the same as `Job:Status`. If you specified more than one output:
     * + `Job:Status` and `Outputs:Status` for all of the outputs is Submitted until Elastic Transcoder starts to process the first output.
     * + When Elastic Transcoder starts to process the first output, `Outputs:Status` for that output and `Job:Status` both change to Progressing. For each output, the value of `Outputs:Status` remains Submitted until Elastic Transcoder starts to process the output.
     * + Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or Error.
     * + When all of the outputs reach a terminal status, `Job:Status` changes to Complete only if `Outputs:Status` for all of the outputs is `Complete`. If `Outputs:Status` for one or more outputs is `Error`, the terminal status for `Job:Status` is also `Error`.
     *
     * The value of `Status` is one of the following: `Submitted`, `Progressing`, `Complete`, `Canceled`, or `Error`.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Information that further explains `Status`.
     */
    public val statusDetail: kotlin.String? = builder.statusDetail
    /**
     * The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
     */
    public val thumbnailEncryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = builder.thumbnailEncryption
    /**
     * Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.
     *
     * If you don't want Elastic Transcoder to create thumbnails, specify "".
     *
     * If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:
     * + **`{count}` (Required)**: If you want to create thumbnails, you must include `{count}` in the `ThumbnailPattern` object. Wherever you specify `{count}`, Elastic Transcoder adds a five-digit sequence number (beginning with **00001**) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. If you specify a literal value and/or `{resolution}` but you omit `{count}`, Elastic Transcoder returns a validation error and does not create the job.
     * + **Literal values (Optional)**: You can specify literal values anywhere in the `ThumbnailPattern` object. For example, you can include them as a file name prefix or as a delimiter between `{resolution}` and `{count}`.
     * + **`{resolution}` (Optional)**: If you want Elastic Transcoder to include the resolution in the file name, include `{resolution}` in the `ThumbnailPattern` object.
     *
     * When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the `PresetID` value of `CreateJobOutput`. Elastic Transcoder also appends the applicable file name extension.
     */
    public val thumbnailPattern: kotlin.String? = builder.thumbnailPattern
    /**
     * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset that you specify in `Preset` for the current output.
     *
     * Watermarks are added to the output video in the sequence in which you list them in the job output—the first watermark in the list is added to the output video first, the second watermark in the list is added next, and so on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same location, the second watermark that you add covers the first one, the third one covers the second, and the fourth one covers the third.
     */
    public val watermarks: List<JobWatermark>? = builder.watermarks
    /**
     * Specifies the width of the output file in pixels.
     */
    public val width: kotlin.Int? = builder.width

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.JobOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobOutput(")
        append("albumArt=$albumArt,")
        append("appliedColorSpaceConversion=$appliedColorSpaceConversion,")
        append("captions=$captions,")
        append("composition=$composition,")
        append("duration=$duration,")
        append("durationMillis=$durationMillis,")
        append("encryption=$encryption,")
        append("fileSize=$fileSize,")
        append("frameRate=$frameRate,")
        append("height=$height,")
        append("id=$id,")
        append("key=$key,")
        append("presetId=$presetId,")
        append("rotate=$rotate,")
        append("segmentDuration=$segmentDuration,")
        append("status=$status,")
        append("statusDetail=$statusDetail,")
        append("thumbnailEncryption=$thumbnailEncryption,")
        append("thumbnailPattern=$thumbnailPattern,")
        append("watermarks=$watermarks,")
        append("width=$width")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = albumArt?.hashCode() ?: 0
        result = 31 * result + (appliedColorSpaceConversion?.hashCode() ?: 0)
        result = 31 * result + (captions?.hashCode() ?: 0)
        result = 31 * result + (composition?.hashCode() ?: 0)
        result = 31 * result + (duration?.hashCode() ?: 0)
        result = 31 * result + (durationMillis?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (fileSize?.hashCode() ?: 0)
        result = 31 * result + (frameRate?.hashCode() ?: 0)
        result = 31 * result + (height ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (presetId?.hashCode() ?: 0)
        result = 31 * result + (rotate?.hashCode() ?: 0)
        result = 31 * result + (segmentDuration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetail?.hashCode() ?: 0)
        result = 31 * result + (thumbnailEncryption?.hashCode() ?: 0)
        result = 31 * result + (thumbnailPattern?.hashCode() ?: 0)
        result = 31 * result + (watermarks?.hashCode() ?: 0)
        result = 31 * result + (width ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobOutput

        if (albumArt != other.albumArt) return false
        if (appliedColorSpaceConversion != other.appliedColorSpaceConversion) return false
        if (captions != other.captions) return false
        if (composition != other.composition) return false
        if (duration != other.duration) return false
        if (durationMillis != other.durationMillis) return false
        if (encryption != other.encryption) return false
        if (fileSize != other.fileSize) return false
        if (frameRate != other.frameRate) return false
        if (height != other.height) return false
        if (id != other.id) return false
        if (key != other.key) return false
        if (presetId != other.presetId) return false
        if (rotate != other.rotate) return false
        if (segmentDuration != other.segmentDuration) return false
        if (status != other.status) return false
        if (statusDetail != other.statusDetail) return false
        if (thumbnailEncryption != other.thumbnailEncryption) return false
        if (thumbnailPattern != other.thumbnailPattern) return false
        if (watermarks != other.watermarks) return false
        if (width != other.width) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.JobOutput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The album art to be associated with the output file, if any.
         */
        public var albumArt: aws.sdk.kotlin.services.elastictranscoder.model.JobAlbumArt? = null
        /**
         * If Elastic Transcoder used a preset with a `ColorSpaceConversionMode` to transcode the output file, the `AppliedColorSpaceConversion` parameter shows the conversion used. If no `ColorSpaceConversionMode` was defined in the preset, this parameter is not be included in the job response.
         */
        public var appliedColorSpaceConversion: kotlin.String? = null
        /**
         * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:
         * + **Embedded:** Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.Valid input values include: `CEA-608 (EIA-608`, first non-empty channel only), `CEA-708 (EIA-708`, first non-empty channel only), and `mov-text`Valid outputs include: `mov-text`Elastic Transcoder supports a maximum of one embedded format per output.
         * + **Sidecar:** Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.Valid input values include: `dfxp` (first div element only), `ebu-tt`, `scc`, `smpt`, `srt`, `ttml` (first div element only), and `webvtt`Valid outputs include: `dfxp` (first div element only), `scc`, `srt`, and `webvtt`.
         *
         * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         *
         * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.
         *
         * To remove captions or leave the captions empty, set `Captions` to null. To pass through existing captions unchanged, set the `MergePolicy` to `MergeRetain`, and pass in a null `CaptionSources` array.
         *
         * For more information on embedded files, see the Subtitles Wikipedia page.
         *
         * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
         */
        public var captions: aws.sdk.kotlin.services.elastictranscoder.model.Captions? = null
        /**
         * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make up an output file. For the current release, you can only specify settings for a single clip per output file. The Composition object cannot be null.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var composition: List<Clip>? = null
        /**
         * Duration of the output file, in seconds.
         */
        public var duration: kotlin.Long? = null
        /**
         * Duration of the output file, in milliseconds.
         */
        public var durationMillis: kotlin.Long? = null
        /**
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your output files. If you choose to use encryption, you must specify a mode to use. If you choose not to use encryption, Elastic Transcoder writes an unencrypted file to your Amazon S3 bucket.
         */
        public var encryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = null
        /**
         * File size of the output file, in bytes.
         */
        public var fileSize: kotlin.Long? = null
        /**
         * Frame rate of the output file, in frames per second.
         */
        public var frameRate: kotlin.String? = null
        /**
         * Height of the output file, in pixels.
         */
        public var height: kotlin.Int? = null
        /**
         * A sequential counter, starting with 1, that identifies an output among the outputs from the current job. In the Output syntax, this value is always 1.
         */
        public var id: kotlin.String? = null
        /**
         * The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by the `OutputBucket` object in the pipeline that is specified by the pipeline ID.
         */
        public var key: kotlin.String? = null
        /**
         * The value of the `Id` object for the preset that you want to use for this job. The preset determines the audio, video, and thumbnail settings that Elastic Transcoder uses for transcoding. To use a preset that you created, specify the preset ID that Elastic Transcoder returned in the response when you created the preset. You can also use the Elastic Transcoder system presets, which you can get with `ListPresets`.
         */
        public var presetId: kotlin.String? = null
        /**
         * The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input. Enter one of the following values:
         *
         * `auto`, `0`, `90`, `180`, `270`
         *
         *  The value `auto` generally works only if the file that you're transcoding contains rotation metadata.
         */
        public var rotate: kotlin.String? = null
        /**
         * (Outputs in Fragmented MP4 or MPEG-TS format only.
         *
         * If you specify a preset in `PresetId` for which the value of `Container` is `fmp4` (Fragmented MP4) or `ts` (MPEG-TS), `SegmentDuration` is the target maximum duration of each segment in seconds. For `HLSv3` format playlists, each media segment is stored in a separate `.ts` file. For `HLSv4`, `MPEG-DASH`, and `Smooth` playlists, all media segments for an output are stored in a single file. Each segment is approximately the length of the `SegmentDuration`, though individual segments might be shorter or longer.
         *
         * The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by `SegmentDuration`, the duration of the last segment is the remainder of total length/SegmentDuration.
         *
         * Elastic Transcoder creates an output-specific playlist for each output `HLS` output that you specify in OutputKeys. To add an output to the master playlist for this job, include it in the `OutputKeys` of the associated playlist.
         */
        public var segmentDuration: kotlin.String? = null
        /**
         * The status of one output in a job. If you specified only one output for the job, `Outputs:Status` is always the same as `Job:Status`. If you specified more than one output:
         * + `Job:Status` and `Outputs:Status` for all of the outputs is Submitted until Elastic Transcoder starts to process the first output.
         * + When Elastic Transcoder starts to process the first output, `Outputs:Status` for that output and `Job:Status` both change to Progressing. For each output, the value of `Outputs:Status` remains Submitted until Elastic Transcoder starts to process the output.
         * + Job:Status remains Progressing until all of the outputs reach a terminal status, either Complete or Error.
         * + When all of the outputs reach a terminal status, `Job:Status` changes to Complete only if `Outputs:Status` for all of the outputs is `Complete`. If `Outputs:Status` for one or more outputs is `Error`, the terminal status for `Job:Status` is also `Error`.
         *
         * The value of `Status` is one of the following: `Submitted`, `Progressing`, `Complete`, `Canceled`, or `Error`.
         */
        public var status: kotlin.String? = null
        /**
         * Information that further explains `Status`.
         */
        public var statusDetail: kotlin.String? = null
        /**
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
         */
        public var thumbnailEncryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = null
        /**
         * Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic Transcoder to name the files.
         *
         * If you don't want Elastic Transcoder to create thumbnails, specify "".
         *
         * If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the file name for each thumbnail. You can specify the following values in any sequence:
         * + **`{count}` (Required)**: If you want to create thumbnails, you must include `{count}` in the `ThumbnailPattern` object. Wherever you specify `{count}`, Elastic Transcoder adds a five-digit sequence number (beginning with **00001**) to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file. If you specify a literal value and/or `{resolution}` but you omit `{count}`, Elastic Transcoder returns a validation error and does not create the job.
         * + **Literal values (Optional)**: You can specify literal values anywhere in the `ThumbnailPattern` object. For example, you can include them as a file name prefix or as a delimiter between `{resolution}` and `{count}`.
         * + **`{resolution}` (Optional)**: If you want Elastic Transcoder to include the resolution in the file name, include `{resolution}` in the `ThumbnailPattern` object.
         *
         * When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that appears in the preset that you specified in the `PresetID` value of `CreateJobOutput`. Elastic Transcoder also appends the applicable file name extension.
         */
        public var thumbnailPattern: kotlin.String? = null
        /**
         * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset that you specify in `Preset` for the current output.
         *
         * Watermarks are added to the output video in the sequence in which you list them in the job output—the first watermark in the list is added to the output video first, the second watermark in the list is added next, and so on. As a result, if the settings in a preset cause Elastic Transcoder to place all watermarks in the same location, the second watermark that you add covers the first one, the third one covers the second, and the fourth one covers the third.
         */
        public var watermarks: List<JobWatermark>? = null
        /**
         * Specifies the width of the output file in pixels.
         */
        public var width: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.JobOutput) : this() {
            this.albumArt = x.albumArt
            this.appliedColorSpaceConversion = x.appliedColorSpaceConversion
            this.captions = x.captions
            this.composition = x.composition
            this.duration = x.duration
            this.durationMillis = x.durationMillis
            this.encryption = x.encryption
            this.fileSize = x.fileSize
            this.frameRate = x.frameRate
            this.height = x.height
            this.id = x.id
            this.key = x.key
            this.presetId = x.presetId
            this.rotate = x.rotate
            this.segmentDuration = x.segmentDuration
            this.status = x.status
            this.statusDetail = x.statusDetail
            this.thumbnailEncryption = x.thumbnailEncryption
            this.thumbnailPattern = x.thumbnailPattern
            this.watermarks = x.watermarks
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.JobOutput = JobOutput(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.JobAlbumArt] inside the given [block]
         */
        public fun albumArt(block: aws.sdk.kotlin.services.elastictranscoder.model.JobAlbumArt.Builder.() -> kotlin.Unit) {
            this.albumArt = aws.sdk.kotlin.services.elastictranscoder.model.JobAlbumArt.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Captions] inside the given [block]
         */
        public fun captions(block: aws.sdk.kotlin.services.elastictranscoder.model.Captions.Builder.() -> kotlin.Unit) {
            this.captions = aws.sdk.kotlin.services.elastictranscoder.model.Captions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Encryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.elastictranscoder.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.elastictranscoder.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Encryption] inside the given [block]
         */
        public fun thumbnailEncryption(block: aws.sdk.kotlin.services.elastictranscoder.model.Encryption.Builder.() -> kotlin.Unit) {
            this.thumbnailEncryption = aws.sdk.kotlin.services.elastictranscoder.model.Encryption.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
