// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * A source file for the input sidecar captions used during the transcoding process.
 */
public class CaptionSource private constructor(builder: Builder) {
    /**
     * The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that you want Elastic Transcoder to apply to your caption sources.
     */
    public val encryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = builder.encryption
    /**
     * The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The label of the caption shown in the player when choosing a language. We recommend that you put the caption language name here, in the language of the captions.
     */
    public val label: kotlin.String? = builder.label
    /**
     * A string that specifies the language of the caption. If you specified multiple inputs with captions, the caption language must match in order to be included in the output. Specify this as one of:
     * + 2-character ISO 639-1 code
     * + 3-character ISO 639-2 code
     *
     * For more information on ISO language codes and language names, see the List of ISO 639-1 codes.
     */
    public val language: kotlin.String? = builder.language
    /**
     * For clip generation or captions that do not start at the same time as the associated video file, the `TimeOffset` tells Elastic Transcoder how much of the video to encode before including captions.
     *
     * Specify the TimeOffset in the form &#91;+-&#93;SS.sss or &#91;+-&#93;HH:mm:SS.ss.
     */
    public val timeOffset: kotlin.String? = builder.timeOffset

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.CaptionSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CaptionSource(")
        append("encryption=$encryption,")
        append("key=$key,")
        append("label=$label,")
        append("language=$language,")
        append("timeOffset=$timeOffset")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryption?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (timeOffset?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CaptionSource

        if (encryption != other.encryption) return false
        if (key != other.key) return false
        if (label != other.label) return false
        if (language != other.language) return false
        if (timeOffset != other.timeOffset) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.CaptionSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that you want Elastic Transcoder to apply to your caption sources.
         */
        public var encryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = null
        /**
         * The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.
         */
        public var key: kotlin.String? = null
        /**
         * The label of the caption shown in the player when choosing a language. We recommend that you put the caption language name here, in the language of the captions.
         */
        public var label: kotlin.String? = null
        /**
         * A string that specifies the language of the caption. If you specified multiple inputs with captions, the caption language must match in order to be included in the output. Specify this as one of:
         * + 2-character ISO 639-1 code
         * + 3-character ISO 639-2 code
         *
         * For more information on ISO language codes and language names, see the List of ISO 639-1 codes.
         */
        public var language: kotlin.String? = null
        /**
         * For clip generation or captions that do not start at the same time as the associated video file, the `TimeOffset` tells Elastic Transcoder how much of the video to encode before including captions.
         *
         * Specify the TimeOffset in the form &#91;+-&#93;SS.sss or &#91;+-&#93;HH:mm:SS.ss.
         */
        public var timeOffset: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.CaptionSource) : this() {
            this.encryption = x.encryption
            this.key = x.key
            this.label = x.label
            this.language = x.language
            this.timeOffset = x.timeOffset
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.CaptionSource = CaptionSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Encryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.elastictranscoder.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.elastictranscoder.model.Encryption.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
