// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.transform

import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.ListVpcEndpointsForDomainResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.VpcEndpointSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListVpcEndpointsForDomainOperationDeserializer: HttpDeserialize<ListVpcEndpointsForDomainResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListVpcEndpointsForDomainResponse {
        if (!response.status.isSuccess()) {
            throwListVpcEndpointsForDomainError(context, response)
        }
        val builder = ListVpcEndpointsForDomainResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListVpcEndpointsForDomainOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListVpcEndpointsForDomainError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedResponse)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListVpcEndpointsForDomainOperationBody(builder: ListVpcEndpointsForDomainResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val VPCENDPOINTSUMMARYLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("VpcEndpointSummaryList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(VPCENDPOINTSUMMARYLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                VPCENDPOINTSUMMARYLIST_DESCRIPTOR.index -> builder.vpcEndpointSummaryList =
                    deserializer.deserializeList(VPCENDPOINTSUMMARYLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<VpcEndpointSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVpcEndpointSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
