// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.transform

import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeOutboundCrossClusterSearchConnectionsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.OutboundCrossClusterSearchConnection
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeOutboundCrossClusterSearchConnectionsOperationDeserializer: HttpDeserialize<DescribeOutboundCrossClusterSearchConnectionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeOutboundCrossClusterSearchConnectionsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeOutboundCrossClusterSearchConnectionsError(context, response)
        }
        val builder = DescribeOutboundCrossClusterSearchConnectionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOutboundCrossClusterSearchConnectionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeOutboundCrossClusterSearchConnectionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPaginationTokenException" -> InvalidPaginationTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOutboundCrossClusterSearchConnectionsOperationBody(builder: DescribeOutboundCrossClusterSearchConnectionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CROSSCLUSTERSEARCHCONNECTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CrossClusterSearchConnections"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CROSSCLUSTERSEARCHCONNECTIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CROSSCLUSTERSEARCHCONNECTIONS_DESCRIPTOR.index -> builder.crossClusterSearchConnections =
                    deserializer.deserializeList(CROSSCLUSTERSEARCHCONNECTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<OutboundCrossClusterSearchConnection>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOutboundCrossClusterSearchConnectionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
