// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.transform

import aws.sdk.kotlin.services.elasticsearchservice.model.CreateOutboundCrossClusterSearchConnectionResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DomainInformation
import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.OutboundCrossClusterSearchConnectionStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateOutboundCrossClusterSearchConnectionOperationDeserializer: HttpDeserialize<CreateOutboundCrossClusterSearchConnectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateOutboundCrossClusterSearchConnectionResponse {
        if (!response.status.isSuccess()) {
            throwCreateOutboundCrossClusterSearchConnectionError(context, response)
        }
        val builder = CreateOutboundCrossClusterSearchConnectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateOutboundCrossClusterSearchConnectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateOutboundCrossClusterSearchConnectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOutboundCrossClusterSearchConnectionOperationBody(builder: CreateOutboundCrossClusterSearchConnectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionAlias"))
    val CONNECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionStatus"))
    val CROSSCLUSTERSEARCHCONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CrossClusterSearchConnectionId"))
    val DESTINATIONDOMAININFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DestinationDomainInfo"))
    val SOURCEDOMAININFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceDomainInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONALIAS_DESCRIPTOR)
        field(CONNECTIONSTATUS_DESCRIPTOR)
        field(CROSSCLUSTERSEARCHCONNECTIONID_DESCRIPTOR)
        field(DESTINATIONDOMAININFO_DESCRIPTOR)
        field(SOURCEDOMAININFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONALIAS_DESCRIPTOR.index -> builder.connectionAlias = deserializeString()
                CONNECTIONSTATUS_DESCRIPTOR.index -> builder.connectionStatus = deserializeOutboundCrossClusterSearchConnectionStatusDocument(deserializer)
                CROSSCLUSTERSEARCHCONNECTIONID_DESCRIPTOR.index -> builder.crossClusterSearchConnectionId = deserializeString()
                DESTINATIONDOMAININFO_DESCRIPTOR.index -> builder.destinationDomainInfo = deserializeDomainInformationDocument(deserializer)
                SOURCEDOMAININFO_DESCRIPTOR.index -> builder.sourceDomainInfo = deserializeDomainInformationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
