// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.paginators

import aws.sdk.kotlin.services.elasticsearchservice.ElasticsearchClient
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeDomainAutoTunesRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeDomainAutoTunesResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeInboundCrossClusterSearchConnectionsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeInboundCrossClusterSearchConnectionsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeOutboundCrossClusterSearchConnectionsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeOutboundCrossClusterSearchConnectionsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribePackagesRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribePackagesResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeReservedElasticsearchInstanceOfferingsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeReservedElasticsearchInstanceOfferingsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeReservedElasticsearchInstancesRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeReservedElasticsearchInstancesResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.GetPackageVersionHistoryRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.GetPackageVersionHistoryResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.GetUpgradeHistoryRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.GetUpgradeHistoryResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListDomainsForPackageRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListDomainsForPackageResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchInstanceTypesRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchInstanceTypesResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchVersionsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchVersionsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListPackagesForDomainRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListPackagesForDomainResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeDomainAutoTunesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDomainAutoTunesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDomainAutoTunesResponse]
 */
public fun ElasticsearchClient.describeDomainAutoTunesPaginated(initialRequest: DescribeDomainAutoTunesRequest): Flow<DescribeDomainAutoTunesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDomainAutoTunesPaginated.describeDomainAutoTunes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDomainAutoTunesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDomainAutoTunesResponse]
 */
public fun ElasticsearchClient.describeDomainAutoTunesPaginated(block: DescribeDomainAutoTunesRequest.Builder.() -> Unit): Flow<DescribeDomainAutoTunesResponse> =
    describeDomainAutoTunesPaginated(DescribeDomainAutoTunesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeInboundCrossClusterSearchConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeInboundCrossClusterSearchConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInboundCrossClusterSearchConnectionsResponse]
 */
public fun ElasticsearchClient.describeInboundCrossClusterSearchConnectionsPaginated(initialRequest: DescribeInboundCrossClusterSearchConnectionsRequest): Flow<DescribeInboundCrossClusterSearchConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeInboundCrossClusterSearchConnectionsPaginated.describeInboundCrossClusterSearchConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeInboundCrossClusterSearchConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInboundCrossClusterSearchConnectionsResponse]
 */
public fun ElasticsearchClient.describeInboundCrossClusterSearchConnectionsPaginated(block: DescribeInboundCrossClusterSearchConnectionsRequest.Builder.() -> Unit): Flow<DescribeInboundCrossClusterSearchConnectionsResponse> =
    describeInboundCrossClusterSearchConnectionsPaginated(DescribeInboundCrossClusterSearchConnectionsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeOutboundCrossClusterSearchConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeOutboundCrossClusterSearchConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOutboundCrossClusterSearchConnectionsResponse]
 */
public fun ElasticsearchClient.describeOutboundCrossClusterSearchConnectionsPaginated(initialRequest: DescribeOutboundCrossClusterSearchConnectionsRequest): Flow<DescribeOutboundCrossClusterSearchConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeOutboundCrossClusterSearchConnectionsPaginated.describeOutboundCrossClusterSearchConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeOutboundCrossClusterSearchConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOutboundCrossClusterSearchConnectionsResponse]
 */
public fun ElasticsearchClient.describeOutboundCrossClusterSearchConnectionsPaginated(block: DescribeOutboundCrossClusterSearchConnectionsRequest.Builder.() -> Unit): Flow<DescribeOutboundCrossClusterSearchConnectionsResponse> =
    describeOutboundCrossClusterSearchConnectionsPaginated(DescribeOutboundCrossClusterSearchConnectionsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePackagesResponse]
 */
public fun ElasticsearchClient.describePackagesPaginated(initialRequest: DescribePackagesRequest): Flow<DescribePackagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePackagesPaginated.describePackages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePackagesResponse]
 */
public fun ElasticsearchClient.describePackagesPaginated(block: DescribePackagesRequest.Builder.() -> Unit): Flow<DescribePackagesResponse> =
    describePackagesPaginated(DescribePackagesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeReservedElasticsearchInstanceOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedElasticsearchInstanceOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedElasticsearchInstanceOfferingsResponse]
 */
public fun ElasticsearchClient.describeReservedElasticsearchInstanceOfferingsPaginated(initialRequest: DescribeReservedElasticsearchInstanceOfferingsRequest): Flow<DescribeReservedElasticsearchInstanceOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeReservedElasticsearchInstanceOfferingsPaginated.describeReservedElasticsearchInstanceOfferings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedElasticsearchInstanceOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedElasticsearchInstanceOfferingsResponse]
 */
public fun ElasticsearchClient.describeReservedElasticsearchInstanceOfferingsPaginated(block: DescribeReservedElasticsearchInstanceOfferingsRequest.Builder.() -> Unit): Flow<DescribeReservedElasticsearchInstanceOfferingsResponse> =
    describeReservedElasticsearchInstanceOfferingsPaginated(DescribeReservedElasticsearchInstanceOfferingsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeReservedElasticsearchInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedElasticsearchInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedElasticsearchInstancesResponse]
 */
public fun ElasticsearchClient.describeReservedElasticsearchInstancesPaginated(initialRequest: DescribeReservedElasticsearchInstancesRequest): Flow<DescribeReservedElasticsearchInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeReservedElasticsearchInstancesPaginated.describeReservedElasticsearchInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedElasticsearchInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedElasticsearchInstancesResponse]
 */
public fun ElasticsearchClient.describeReservedElasticsearchInstancesPaginated(block: DescribeReservedElasticsearchInstancesRequest.Builder.() -> Unit): Flow<DescribeReservedElasticsearchInstancesResponse> =
    describeReservedElasticsearchInstancesPaginated(DescribeReservedElasticsearchInstancesRequest.Builder().apply(block).build())

/**
 * Paginate over [GetPackageVersionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetPackageVersionHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPackageVersionHistoryResponse]
 */
public fun ElasticsearchClient.getPackageVersionHistoryPaginated(initialRequest: GetPackageVersionHistoryRequest): Flow<GetPackageVersionHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getPackageVersionHistoryPaginated.getPackageVersionHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetPackageVersionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPackageVersionHistoryResponse]
 */
public fun ElasticsearchClient.getPackageVersionHistoryPaginated(block: GetPackageVersionHistoryRequest.Builder.() -> Unit): Flow<GetPackageVersionHistoryResponse> =
    getPackageVersionHistoryPaginated(GetPackageVersionHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [GetUpgradeHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetUpgradeHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUpgradeHistoryResponse]
 */
public fun ElasticsearchClient.getUpgradeHistoryPaginated(initialRequest: GetUpgradeHistoryRequest): Flow<GetUpgradeHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getUpgradeHistoryPaginated.getUpgradeHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetUpgradeHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUpgradeHistoryResponse]
 */
public fun ElasticsearchClient.getUpgradeHistoryPaginated(block: GetUpgradeHistoryRequest.Builder.() -> Unit): Flow<GetUpgradeHistoryResponse> =
    getUpgradeHistoryPaginated(GetUpgradeHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDomainsForPackageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainsForPackageRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsForPackageResponse]
 */
public fun ElasticsearchClient.listDomainsForPackagePaginated(initialRequest: ListDomainsForPackageRequest): Flow<ListDomainsForPackageResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainsForPackagePaginated.listDomainsForPackage(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainsForPackageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsForPackageResponse]
 */
public fun ElasticsearchClient.listDomainsForPackagePaginated(block: ListDomainsForPackageRequest.Builder.() -> Unit): Flow<ListDomainsForPackageResponse> =
    listDomainsForPackagePaginated(ListDomainsForPackageRequest.Builder().apply(block).build())

/**
 * Paginate over [ListElasticsearchInstanceTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListElasticsearchInstanceTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListElasticsearchInstanceTypesResponse]
 */
public fun ElasticsearchClient.listElasticsearchInstanceTypesPaginated(initialRequest: ListElasticsearchInstanceTypesRequest): Flow<ListElasticsearchInstanceTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listElasticsearchInstanceTypesPaginated.listElasticsearchInstanceTypes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListElasticsearchInstanceTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListElasticsearchInstanceTypesResponse]
 */
public fun ElasticsearchClient.listElasticsearchInstanceTypesPaginated(block: ListElasticsearchInstanceTypesRequest.Builder.() -> Unit): Flow<ListElasticsearchInstanceTypesResponse> =
    listElasticsearchInstanceTypesPaginated(ListElasticsearchInstanceTypesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListElasticsearchVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListElasticsearchVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListElasticsearchVersionsResponse]
 */
public fun ElasticsearchClient.listElasticsearchVersionsPaginated(initialRequest: ListElasticsearchVersionsRequest): Flow<ListElasticsearchVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listElasticsearchVersionsPaginated.listElasticsearchVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListElasticsearchVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListElasticsearchVersionsResponse]
 */
public fun ElasticsearchClient.listElasticsearchVersionsPaginated(block: ListElasticsearchVersionsRequest.Builder.() -> Unit): Flow<ListElasticsearchVersionsResponse> =
    listElasticsearchVersionsPaginated(ListElasticsearchVersionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPackagesForDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackagesForDomainRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesForDomainResponse]
 */
public fun ElasticsearchClient.listPackagesForDomainPaginated(initialRequest: ListPackagesForDomainRequest): Flow<ListPackagesForDomainResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackagesForDomainPaginated.listPackagesForDomain(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPackagesForDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesForDomainResponse]
 */
public fun ElasticsearchClient.listPackagesForDomainPaginated(block: ListPackagesForDomainRequest.Builder.() -> Unit): Flow<ListPackagesForDomainResponse> =
    listPackagesForDomainPaginated(ListPackagesForDomainRequest.Builder().apply(block).build())
