// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.transform

import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.EsPartitionInstanceType
import aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchInstanceTypesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListElasticsearchInstanceTypesOperationDeserializer: HttpDeserialize<ListElasticsearchInstanceTypesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListElasticsearchInstanceTypesResponse {
        if (!response.status.isSuccess()) {
            throwListElasticsearchInstanceTypesError(context, response)
        }
        val builder = ListElasticsearchInstanceTypesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListElasticsearchInstanceTypesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListElasticsearchInstanceTypesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListElasticsearchInstanceTypesOperationBody(builder: ListElasticsearchInstanceTypesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ELASTICSEARCHINSTANCETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ElasticsearchInstanceTypes"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ELASTICSEARCHINSTANCETYPES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ELASTICSEARCHINSTANCETYPES_DESCRIPTOR.index -> builder.elasticsearchInstanceTypes =
                    deserializer.deserializeList(ELASTICSEARCHINSTANCETYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<EsPartitionInstanceType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { EsPartitionInstanceType.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
