// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



/**
 * StorageTypes represents the list of storage related types and their attributes that are available for given InstanceType.
 */
public class StorageType private constructor(builder: Builder) {
    /**
     * SubType of the given storage type. List of available sub-storage options: For "instance" storageType we wont have any storageSubType, in case of "ebs" storageType we will have following valid storageSubTypes
     * + standard
     * + gp2
     * + gp3
     * + io1
     *
     *  Refer `<a>VolumeType</a>` for more information regarding above EBS storage options.
     */
    public val storageSubTypeName: kotlin.String? = builder.storageSubTypeName
    /**
     * List of limits that are applicable for given storage type.
     */
    public val storageTypeLimits: List<StorageTypeLimit>? = builder.storageTypeLimits
    /**
     * Type of the storage. List of available storage options:
     * + instance
     *  Inbuilt storage available for the given Instance + ebs
     *  Elastic block storage that would be attached to the given Instance
     */
    public val storageTypeName: kotlin.String? = builder.storageTypeName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.StorageType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageType(")
        append("storageSubTypeName=$storageSubTypeName,")
        append("storageTypeLimits=$storageTypeLimits,")
        append("storageTypeName=$storageTypeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = storageSubTypeName?.hashCode() ?: 0
        result = 31 * result + (storageTypeLimits?.hashCode() ?: 0)
        result = 31 * result + (storageTypeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageType

        if (storageSubTypeName != other.storageSubTypeName) return false
        if (storageTypeLimits != other.storageTypeLimits) return false
        if (storageTypeName != other.storageTypeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.StorageType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * SubType of the given storage type. List of available sub-storage options: For "instance" storageType we wont have any storageSubType, in case of "ebs" storageType we will have following valid storageSubTypes
         * + standard
         * + gp2
         * + gp3
         * + io1
         *
         *  Refer `<a>VolumeType</a>` for more information regarding above EBS storage options.
         */
        public var storageSubTypeName: kotlin.String? = null
        /**
         * List of limits that are applicable for given storage type.
         */
        public var storageTypeLimits: List<StorageTypeLimit>? = null
        /**
         * Type of the storage. List of available storage options:
         * + instance
         *  Inbuilt storage available for the given Instance + ebs
         *  Elastic block storage that would be attached to the given Instance
         */
        public var storageTypeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.StorageType) : this() {
            this.storageSubTypeName = x.storageSubTypeName
            this.storageTypeLimits = x.storageTypeLimits
            this.storageTypeName = x.storageTypeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.StorageType = StorageType(this)
    }
}
