// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



/**
 * Specifies the configuration for the domain cluster, such as the type and number of instances.
 */
public class ElasticsearchClusterConfig private constructor(builder: Builder) {
    /**
     * Specifies the `ColdStorageOptions` config for Elasticsearch Domain
     */
    public val coldStorageOptions: aws.sdk.kotlin.services.elasticsearchservice.model.ColdStorageOptions? = builder.coldStorageOptions
    /**
     * Total number of dedicated master nodes, active and on standby, for the cluster.
     */
    public val dedicatedMasterCount: kotlin.Int? = builder.dedicatedMasterCount
    /**
     * A boolean value to indicate whether a dedicated master node is enabled. See [About Dedicated Master Nodes](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes) for more information.
     */
    public val dedicatedMasterEnabled: kotlin.Boolean? = builder.dedicatedMasterEnabled
    /**
     * The instance type for a dedicated master node.
     */
    public val dedicatedMasterType: aws.sdk.kotlin.services.elasticsearchservice.model.EsPartitionInstanceType? = builder.dedicatedMasterType
    /**
     * The number of instances in the specified domain cluster.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data instances.
     */
    public val instanceType: aws.sdk.kotlin.services.elasticsearchservice.model.EsPartitionInstanceType? = builder.instanceType
    /**
     * The number of warm nodes in the cluster.
     */
    public val warmCount: kotlin.Int? = builder.warmCount
    /**
     * True to enable warm storage.
     */
    public val warmEnabled: kotlin.Boolean? = builder.warmEnabled
    /**
     * The instance type for the Elasticsearch cluster's warm nodes.
     */
    public val warmType: aws.sdk.kotlin.services.elasticsearchservice.model.EsWarmPartitionInstanceType? = builder.warmType
    /**
     * Specifies the zone awareness configuration for a domain when zone awareness is enabled.
     */
    public val zoneAwarenessConfig: aws.sdk.kotlin.services.elasticsearchservice.model.ZoneAwarenessConfig? = builder.zoneAwarenessConfig
    /**
     * A boolean value to indicate whether zone awareness is enabled. See [About Zone Awareness](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness) for more information.
     */
    public val zoneAwarenessEnabled: kotlin.Boolean? = builder.zoneAwarenessEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchClusterConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ElasticsearchClusterConfig(")
        append("coldStorageOptions=$coldStorageOptions,")
        append("dedicatedMasterCount=$dedicatedMasterCount,")
        append("dedicatedMasterEnabled=$dedicatedMasterEnabled,")
        append("dedicatedMasterType=$dedicatedMasterType,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("warmCount=$warmCount,")
        append("warmEnabled=$warmEnabled,")
        append("warmType=$warmType,")
        append("zoneAwarenessConfig=$zoneAwarenessConfig,")
        append("zoneAwarenessEnabled=$zoneAwarenessEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = coldStorageOptions?.hashCode() ?: 0
        result = 31 * result + (dedicatedMasterCount ?: 0)
        result = 31 * result + (dedicatedMasterEnabled?.hashCode() ?: 0)
        result = 31 * result + (dedicatedMasterType?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (warmCount ?: 0)
        result = 31 * result + (warmEnabled?.hashCode() ?: 0)
        result = 31 * result + (warmType?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessConfig?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ElasticsearchClusterConfig

        if (coldStorageOptions != other.coldStorageOptions) return false
        if (dedicatedMasterCount != other.dedicatedMasterCount) return false
        if (dedicatedMasterEnabled != other.dedicatedMasterEnabled) return false
        if (dedicatedMasterType != other.dedicatedMasterType) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (warmCount != other.warmCount) return false
        if (warmEnabled != other.warmEnabled) return false
        if (warmType != other.warmType) return false
        if (zoneAwarenessConfig != other.zoneAwarenessConfig) return false
        if (zoneAwarenessEnabled != other.zoneAwarenessEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchClusterConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the `ColdStorageOptions` config for Elasticsearch Domain
         */
        public var coldStorageOptions: aws.sdk.kotlin.services.elasticsearchservice.model.ColdStorageOptions? = null
        /**
         * Total number of dedicated master nodes, active and on standby, for the cluster.
         */
        public var dedicatedMasterCount: kotlin.Int? = null
        /**
         * A boolean value to indicate whether a dedicated master node is enabled. See [About Dedicated Master Nodes](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes) for more information.
         */
        public var dedicatedMasterEnabled: kotlin.Boolean? = null
        /**
         * The instance type for a dedicated master node.
         */
        public var dedicatedMasterType: aws.sdk.kotlin.services.elasticsearchservice.model.EsPartitionInstanceType? = null
        /**
         * The number of instances in the specified domain cluster.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data instances.
         */
        public var instanceType: aws.sdk.kotlin.services.elasticsearchservice.model.EsPartitionInstanceType? = null
        /**
         * The number of warm nodes in the cluster.
         */
        public var warmCount: kotlin.Int? = null
        /**
         * True to enable warm storage.
         */
        public var warmEnabled: kotlin.Boolean? = null
        /**
         * The instance type for the Elasticsearch cluster's warm nodes.
         */
        public var warmType: aws.sdk.kotlin.services.elasticsearchservice.model.EsWarmPartitionInstanceType? = null
        /**
         * Specifies the zone awareness configuration for a domain when zone awareness is enabled.
         */
        public var zoneAwarenessConfig: aws.sdk.kotlin.services.elasticsearchservice.model.ZoneAwarenessConfig? = null
        /**
         * A boolean value to indicate whether zone awareness is enabled. See [About Zone Awareness](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness) for more information.
         */
        public var zoneAwarenessEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchClusterConfig) : this() {
            this.coldStorageOptions = x.coldStorageOptions
            this.dedicatedMasterCount = x.dedicatedMasterCount
            this.dedicatedMasterEnabled = x.dedicatedMasterEnabled
            this.dedicatedMasterType = x.dedicatedMasterType
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.warmCount = x.warmCount
            this.warmEnabled = x.warmEnabled
            this.warmType = x.warmType
            this.zoneAwarenessConfig = x.zoneAwarenessConfig
            this.zoneAwarenessEnabled = x.zoneAwarenessEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchClusterConfig = ElasticsearchClusterConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.ColdStorageOptions] inside the given [block]
         */
        public fun coldStorageOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.ColdStorageOptions.Builder.() -> kotlin.Unit) {
            this.coldStorageOptions = aws.sdk.kotlin.services.elasticsearchservice.model.ColdStorageOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.ZoneAwarenessConfig] inside the given [block]
         */
        public fun zoneAwarenessConfig(block: aws.sdk.kotlin.services.elasticsearchservice.model.ZoneAwarenessConfig.Builder.() -> kotlin.Unit) {
            this.zoneAwarenessConfig = aws.sdk.kotlin.services.elasticsearchservice.model.ZoneAwarenessConfig.invoke(block)
        }
    }
}
