// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



/**
 * Options to enable, disable, and specify the properties of EBS storage volumes. For more information, see [ Configuring EBS-based Storage](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs).
 */
public class EbsOptions private constructor(builder: Builder) {
    /**
     * Specifies whether EBS-based storage is enabled.
     */
    public val ebsEnabled: kotlin.Boolean? = builder.ebsEnabled
    /**
     * Specifies the IOPS for Provisioned IOPS And GP3 EBS volume (SSD).
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * Specifies the Throughput for GP3 EBS volume (SSD).
     */
    public val throughput: kotlin.Int? = builder.throughput
    /**
     * Integer to specify the size of an EBS volume.
     */
    public val volumeSize: kotlin.Int? = builder.volumeSize
    /**
     * Specifies the volume type for EBS-based storage.
     */
    public val volumeType: aws.sdk.kotlin.services.elasticsearchservice.model.VolumeType? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.EbsOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsOptions(")
        append("ebsEnabled=$ebsEnabled,")
        append("iops=$iops,")
        append("throughput=$throughput,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ebsEnabled?.hashCode() ?: 0
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsOptions

        if (ebsEnabled != other.ebsEnabled) return false
        if (iops != other.iops) return false
        if (throughput != other.throughput) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.EbsOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether EBS-based storage is enabled.
         */
        public var ebsEnabled: kotlin.Boolean? = null
        /**
         * Specifies the IOPS for Provisioned IOPS And GP3 EBS volume (SSD).
         */
        public var iops: kotlin.Int? = null
        /**
         * Specifies the Throughput for GP3 EBS volume (SSD).
         */
        public var throughput: kotlin.Int? = null
        /**
         * Integer to specify the size of an EBS volume.
         */
        public var volumeSize: kotlin.Int? = null
        /**
         * Specifies the volume type for EBS-based storage.
         */
        public var volumeType: aws.sdk.kotlin.services.elasticsearchservice.model.VolumeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.EbsOptions) : this() {
            this.ebsEnabled = x.ebsEnabled
            this.iops = x.iops
            this.throughput = x.throughput
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.EbsOptions = EbsOptions(this)
    }
}
