// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.transform

import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.GetUpgradeStatusResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStatus
import aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStep
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetUpgradeStatusOperationDeserializer: HttpDeserialize<GetUpgradeStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetUpgradeStatusResponse {
        if (!response.status.isSuccess()) {
            throwGetUpgradeStatusError(context, response)
        }
        val builder = GetUpgradeStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetUpgradeStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetUpgradeStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedResponse)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUpgradeStatusOperationBody(builder: GetUpgradeStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val STEPSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("StepStatus"))
    val UPGRADENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UpgradeName"))
    val UPGRADESTEP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UpgradeStep"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STEPSTATUS_DESCRIPTOR)
        field(UPGRADENAME_DESCRIPTOR)
        field(UPGRADESTEP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                STEPSTATUS_DESCRIPTOR.index -> builder.stepStatus = deserializeString().let { UpgradeStatus.fromValue(it) }
                UPGRADENAME_DESCRIPTOR.index -> builder.upgradeName = deserializeString()
                UPGRADESTEP_DESCRIPTOR.index -> builder.upgradeStep = deserializeString().let { UpgradeStep.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
