// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.transform

import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeReservedElasticsearchInstanceOfferingsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstanceOffering
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeReservedElasticsearchInstanceOfferingsOperationDeserializer: HttpDeserialize<DescribeReservedElasticsearchInstanceOfferingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeReservedElasticsearchInstanceOfferingsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeReservedElasticsearchInstanceOfferingsError(context, response)
        }
        val builder = DescribeReservedElasticsearchInstanceOfferingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeReservedElasticsearchInstanceOfferingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeReservedElasticsearchInstanceOfferingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeReservedElasticsearchInstanceOfferingsOperationBody(builder: DescribeReservedElasticsearchInstanceOfferingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESERVEDELASTICSEARCHINSTANCEOFFERINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ReservedElasticsearchInstanceOfferings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESERVEDELASTICSEARCHINSTANCEOFFERINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESERVEDELASTICSEARCHINSTANCEOFFERINGS_DESCRIPTOR.index -> builder.reservedElasticsearchInstanceOfferings =
                    deserializer.deserializeList(RESERVEDELASTICSEARCHINSTANCEOFFERINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<ReservedElasticsearchInstanceOffering>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReservedElasticsearchInstanceOfferingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
