// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.UpdateVpcEndpointResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.VpcEndpoint
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateVpcEndpointOperationDeserializer: HttpDeserialize<UpdateVpcEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateVpcEndpointResponse {
        if (!response.status.isSuccess()) {
            throwUpdateVpcEndpointError(context, response)
        }
        val builder = UpdateVpcEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateVpcEndpointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateVpcEndpointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateVpcEndpointOperationBody(builder: UpdateVpcEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VPCENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcEndpoint"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VPCENDPOINT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VPCENDPOINT_DESCRIPTOR.index -> builder.vpcEndpoint = deserializeVpcEndpointDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
