// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details of a reserved Elasticsearch instance.
 */
public class ReservedElasticsearchInstance private constructor(builder: Builder) {
    /**
     * The currency code for the reserved Elasticsearch instance offering.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The duration, in seconds, for which the Elasticsearch instance is reserved.
     */
    public val duration: kotlin.Int = builder.duration
    /**
     * The number of Elasticsearch instances that have been reserved.
     */
    public val elasticsearchInstanceCount: kotlin.Int = builder.elasticsearchInstanceCount
    /**
     * The Elasticsearch instance type offered by the reserved instance offering.
     */
    public val elasticsearchInstanceType: aws.sdk.kotlin.services.elasticsearchservice.model.EsPartitionInstanceType? = builder.elasticsearchInstanceType
    /**
     * The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering.
     */
    public val fixedPrice: kotlin.Double? = builder.fixedPrice
    /**
     * The payment option as defined in the reserved Elasticsearch instance offering.
     */
    public val paymentOption: aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstancePaymentOption? = builder.paymentOption
    /**
     * The charge to your account regardless of whether you are creating any domains using the instance offering.
     */
    public val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The customer-specified identifier to track this reservation.
     */
    public val reservationName: kotlin.String? = builder.reservationName
    /**
     * The unique identifier for the reservation.
     */
    public val reservedElasticsearchInstanceId: kotlin.String? = builder.reservedElasticsearchInstanceId
    /**
     * The offering identifier.
     */
    public val reservedElasticsearchInstanceOfferingId: kotlin.String? = builder.reservedElasticsearchInstanceOfferingId
    /**
     * The time the reservation started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the reserved Elasticsearch instance.
     */
    public val state: kotlin.String? = builder.state
    /**
     * The rate you are charged for each hour for the domain that is using this reserved instance.
     */
    public val usagePrice: kotlin.Double? = builder.usagePrice

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedElasticsearchInstance(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("elasticsearchInstanceCount=$elasticsearchInstanceCount,")
        append("elasticsearchInstanceType=$elasticsearchInstanceType,")
        append("fixedPrice=$fixedPrice,")
        append("paymentOption=$paymentOption,")
        append("recurringCharges=$recurringCharges,")
        append("reservationName=$reservationName,")
        append("reservedElasticsearchInstanceId=$reservedElasticsearchInstanceId,")
        append("reservedElasticsearchInstanceOfferingId=$reservedElasticsearchInstanceOfferingId,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("usagePrice=$usagePrice")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration)
        result = 31 * result + (elasticsearchInstanceCount)
        result = 31 * result + (elasticsearchInstanceType?.hashCode() ?: 0)
        result = 31 * result + (fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservationName?.hashCode() ?: 0)
        result = 31 * result + (reservedElasticsearchInstanceId?.hashCode() ?: 0)
        result = 31 * result + (reservedElasticsearchInstanceOfferingId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedElasticsearchInstance

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (elasticsearchInstanceCount != other.elasticsearchInstanceCount) return false
        if (elasticsearchInstanceType != other.elasticsearchInstanceType) return false
        if (fixedPrice != other.fixedPrice) return false
        if (paymentOption != other.paymentOption) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservationName != other.reservationName) return false
        if (reservedElasticsearchInstanceId != other.reservedElasticsearchInstanceId) return false
        if (reservedElasticsearchInstanceOfferingId != other.reservedElasticsearchInstanceOfferingId) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The currency code for the reserved Elasticsearch instance offering.
         */
        public var currencyCode: kotlin.String? = null
        /**
         * The duration, in seconds, for which the Elasticsearch instance is reserved.
         */
        public var duration: kotlin.Int = 0
        /**
         * The number of Elasticsearch instances that have been reserved.
         */
        public var elasticsearchInstanceCount: kotlin.Int = 0
        /**
         * The Elasticsearch instance type offered by the reserved instance offering.
         */
        public var elasticsearchInstanceType: aws.sdk.kotlin.services.elasticsearchservice.model.EsPartitionInstanceType? = null
        /**
         * The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering.
         */
        public var fixedPrice: kotlin.Double? = null
        /**
         * The payment option as defined in the reserved Elasticsearch instance offering.
         */
        public var paymentOption: aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstancePaymentOption? = null
        /**
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         */
        public var recurringCharges: List<RecurringCharge>? = null
        /**
         * The customer-specified identifier to track this reservation.
         */
        public var reservationName: kotlin.String? = null
        /**
         * The unique identifier for the reservation.
         */
        public var reservedElasticsearchInstanceId: kotlin.String? = null
        /**
         * The offering identifier.
         */
        public var reservedElasticsearchInstanceOfferingId: kotlin.String? = null
        /**
         * The time the reservation started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the reserved Elasticsearch instance.
         */
        public var state: kotlin.String? = null
        /**
         * The rate you are charged for each hour for the domain that is using this reserved instance.
         */
        public var usagePrice: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstance) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.elasticsearchInstanceCount = x.elasticsearchInstanceCount
            this.elasticsearchInstanceType = x.elasticsearchInstanceType
            this.fixedPrice = x.fixedPrice
            this.paymentOption = x.paymentOption
            this.recurringCharges = x.recurringCharges
            this.reservationName = x.reservationName
            this.reservedElasticsearchInstanceId = x.reservedElasticsearchInstanceId
            this.reservedElasticsearchInstanceOfferingId = x.reservedElasticsearchInstanceOfferingId
            this.startTime = x.startTime
            this.state = x.state
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstance = ReservedElasticsearchInstance(this)
    }
}
