// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.elasticsearchservice.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.elasticsearchservice.endpoints.EndpointProvider
import aws.sdk.kotlin.services.elasticsearchservice.model.*
import aws.sdk.kotlin.services.elasticsearchservice.model.AcceptInboundCrossClusterSearchConnectionRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.AcceptInboundCrossClusterSearchConnectionResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.AddTagsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.AddTagsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.AssociatePackageRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.AssociatePackageResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.AuthorizeVpcEndpointAccessRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.AuthorizeVpcEndpointAccessResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.CancelElasticsearchServiceSoftwareUpdateRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.CancelElasticsearchServiceSoftwareUpdateResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.CreateElasticsearchDomainRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.CreateElasticsearchDomainResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.CreateOutboundCrossClusterSearchConnectionRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.CreateOutboundCrossClusterSearchConnectionResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.CreatePackageRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.CreatePackageResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.CreateVpcEndpointRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.CreateVpcEndpointResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteElasticsearchDomainRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteElasticsearchDomainResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteElasticsearchServiceRoleRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteElasticsearchServiceRoleResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteInboundCrossClusterSearchConnectionRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteInboundCrossClusterSearchConnectionResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteOutboundCrossClusterSearchConnectionRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteOutboundCrossClusterSearchConnectionResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DeletePackageRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DeletePackageResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteVpcEndpointRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DeleteVpcEndpointResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeDomainAutoTunesRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeDomainAutoTunesResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeDomainChangeProgressRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeDomainChangeProgressResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeElasticsearchDomainConfigRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeElasticsearchDomainConfigResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeElasticsearchDomainRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeElasticsearchDomainResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeElasticsearchDomainsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeElasticsearchDomainsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeElasticsearchInstanceTypeLimitsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeElasticsearchInstanceTypeLimitsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeInboundCrossClusterSearchConnectionsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeInboundCrossClusterSearchConnectionsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeOutboundCrossClusterSearchConnectionsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeOutboundCrossClusterSearchConnectionsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribePackagesRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribePackagesResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeReservedElasticsearchInstanceOfferingsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeReservedElasticsearchInstanceOfferingsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeReservedElasticsearchInstancesRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeReservedElasticsearchInstancesResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeVpcEndpointsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeVpcEndpointsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DissociatePackageRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.DissociatePackageResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.GetCompatibleElasticsearchVersionsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.GetCompatibleElasticsearchVersionsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.GetPackageVersionHistoryRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.GetPackageVersionHistoryResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.GetUpgradeHistoryRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.GetUpgradeHistoryResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.GetUpgradeStatusRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.GetUpgradeStatusResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListDomainNamesRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListDomainNamesResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListDomainsForPackageRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListDomainsForPackageResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchInstanceTypesRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchInstanceTypesResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchVersionsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchVersionsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListPackagesForDomainRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListPackagesForDomainResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListTagsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListTagsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListVpcEndpointAccessRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListVpcEndpointAccessResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListVpcEndpointsForDomainRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListVpcEndpointsForDomainResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ListVpcEndpointsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.ListVpcEndpointsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.PurchaseReservedElasticsearchInstanceOfferingRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.PurchaseReservedElasticsearchInstanceOfferingResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.RejectInboundCrossClusterSearchConnectionRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.RejectInboundCrossClusterSearchConnectionResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.RemoveTagsRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.RemoveTagsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.RevokeVpcEndpointAccessRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.RevokeVpcEndpointAccessResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.StartElasticsearchServiceSoftwareUpdateRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.StartElasticsearchServiceSoftwareUpdateResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.UpdateElasticsearchDomainConfigRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.UpdateElasticsearchDomainConfigResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.UpdatePackageRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.UpdatePackageResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.UpdateVpcEndpointRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.UpdateVpcEndpointResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeElasticsearchDomainRequest
import aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeElasticsearchDomainResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.MutableList

/**
 * # Amazon Elasticsearch Configuration Service
 * Use the Amazon Elasticsearch Configuration API to create, configure, and manage Elasticsearch domains.
 *
 * For sample code that uses the Configuration API, see the [Amazon Elasticsearch Service Developer Guide](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-samples.html). The guide also contains [sample code for sending signed HTTP requests to the Elasticsearch APIs](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-request-signing.html).
 *
 * The endpoint for configuration service requests is region-specific: es.*region*.amazonaws.com. For example, es.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see [Regions and Endpoints](http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticsearch-service-regions).
 */
public interface ElasticsearchClient : SdkClient {

    override val serviceName: String
        get() = "Elasticsearch Service"
    /**
     * ElasticsearchClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ElasticsearchClient {
            val config = Config.Builder().apply(block).build()
            return DefaultElasticsearchClient(config)
        }

        public operator fun invoke(config: Config): ElasticsearchClient = DefaultElasticsearchClient(config)

        /**
         * Construct a [ElasticsearchClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ElasticsearchClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultElasticsearchClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Elasticsearch Service")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null

            /**
             * AWS region to make requests to
             */
            public var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            public var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
     */
    public suspend fun acceptInboundCrossClusterSearchConnection(input: AcceptInboundCrossClusterSearchConnectionRequest): AcceptInboundCrossClusterSearchConnectionResponse

    /**
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See [ Tagging Amazon Elasticsearch Service Domains for more information.](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging)
     */
    public suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Associates a package with an Amazon ES domain.
     */
    public suspend fun associatePackage(input: AssociatePackageRequest): AssociatePackageResponse

    /**
     * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     */
    public suspend fun authorizeVpcEndpointAccess(input: AuthorizeVpcEndpointAccessRequest): AuthorizeVpcEndpointAccessResponse

    /**
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the `AutomatedUpdateDate` and when the `UpdateStatus` is in the `PENDING_UPDATE` state.
     */
    public suspend fun cancelElasticsearchServiceSoftwareUpdate(input: CancelElasticsearchServiceSoftwareUpdateRequest): CancelElasticsearchServiceSoftwareUpdateResponse

    /**
     * Creates a new Elasticsearch domain. For more information, see [Creating Elasticsearch Domains](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains) in the *Amazon Elasticsearch Service Developer Guide*.
     */
    public suspend fun createElasticsearchDomain(input: CreateElasticsearchDomainRequest): CreateElasticsearchDomainResponse

    /**
     * Creates a new cross-cluster search connection from a source domain to a destination domain.
     */
    public suspend fun createOutboundCrossClusterSearchConnection(input: CreateOutboundCrossClusterSearchConnectionRequest): CreateOutboundCrossClusterSearchConnectionResponse

    /**
     * Create a package for use with Amazon ES domains.
     */
    public suspend fun createPackage(input: CreatePackageRequest): CreatePackageResponse

    /**
     * Creates an Amazon OpenSearch Service-managed VPC endpoint.
     */
    public suspend fun createVpcEndpoint(input: CreateVpcEndpointRequest): CreateVpcEndpointResponse

    /**
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.
     */
    public suspend fun deleteElasticsearchDomain(input: DeleteElasticsearchDomainRequest): DeleteElasticsearchDomainResponse

    /**
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See [Deleting Elasticsearch Service Role](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr) in *VPC Endpoints for Amazon Elasticsearch Service Domains*.
     */
    public suspend fun deleteElasticsearchServiceRole(input: DeleteElasticsearchServiceRoleRequest = DeleteElasticsearchServiceRoleRequest {}): DeleteElasticsearchServiceRoleResponse

    /**
     * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
     */
    public suspend fun deleteInboundCrossClusterSearchConnection(input: DeleteInboundCrossClusterSearchConnectionRequest): DeleteInboundCrossClusterSearchConnectionResponse

    /**
     * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
     */
    public suspend fun deleteOutboundCrossClusterSearchConnection(input: DeleteOutboundCrossClusterSearchConnectionRequest): DeleteOutboundCrossClusterSearchConnectionResponse

    /**
     * Delete the package.
     */
    public suspend fun deletePackage(input: DeletePackageRequest): DeletePackageResponse

    /**
     * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     */
    public suspend fun deleteVpcEndpoint(input: DeleteVpcEndpointRequest): DeleteVpcEndpointResponse

    /**
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.
     */
    public suspend fun describeDomainAutoTunes(input: DescribeDomainAutoTunesRequest): DescribeDomainAutoTunesResponse

    /**
     * Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.
     */
    public suspend fun describeDomainChangeProgress(input: DescribeDomainChangeProgressRequest): DescribeDomainChangeProgressResponse

    /**
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.
     */
    public suspend fun describeElasticsearchDomain(input: DescribeElasticsearchDomainRequest): DescribeElasticsearchDomainResponse

    /**
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.
     */
    public suspend fun describeElasticsearchDomainConfig(input: DescribeElasticsearchDomainConfigRequest): DescribeElasticsearchDomainConfigResponse

    /**
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.
     */
    public suspend fun describeElasticsearchDomains(input: DescribeElasticsearchDomainsRequest): DescribeElasticsearchDomainsResponse

    /**
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the ` <a>DomainName</a> ` to know what Limits are supported for modifying.
     */
    public suspend fun describeElasticsearchInstanceTypeLimits(input: DescribeElasticsearchInstanceTypeLimitsRequest): DescribeElasticsearchInstanceTypeLimitsResponse

    /**
     * Lists all the inbound cross-cluster search connections for a destination domain.
     */
    public suspend fun describeInboundCrossClusterSearchConnections(input: DescribeInboundCrossClusterSearchConnectionsRequest = DescribeInboundCrossClusterSearchConnectionsRequest {}): DescribeInboundCrossClusterSearchConnectionsResponse

    /**
     * Lists all the outbound cross-cluster search connections for a source domain.
     */
    public suspend fun describeOutboundCrossClusterSearchConnections(input: DescribeOutboundCrossClusterSearchConnectionsRequest = DescribeOutboundCrossClusterSearchConnectionsRequest {}): DescribeOutboundCrossClusterSearchConnectionsResponse

    /**
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.
     */
    public suspend fun describePackages(input: DescribePackagesRequest = DescribePackagesRequest {}): DescribePackagesResponse

    /**
     * Lists available reserved Elasticsearch instance offerings.
     */
    public suspend fun describeReservedElasticsearchInstanceOfferings(input: DescribeReservedElasticsearchInstanceOfferingsRequest = DescribeReservedElasticsearchInstanceOfferingsRequest {}): DescribeReservedElasticsearchInstanceOfferingsResponse

    /**
     * Returns information about reserved Elasticsearch instances for this account.
     */
    public suspend fun describeReservedElasticsearchInstances(input: DescribeReservedElasticsearchInstancesRequest = DescribeReservedElasticsearchInstancesRequest {}): DescribeReservedElasticsearchInstancesResponse

    /**
     * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
     */
    public suspend fun describeVpcEndpoints(input: DescribeVpcEndpointsRequest): DescribeVpcEndpointsResponse

    /**
     * Dissociates a package from the Amazon ES domain.
     */
    public suspend fun dissociatePackage(input: DissociatePackageRequest): DissociatePackageResponse

    /**
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a ` <a>DomainName</a> ` to get all upgrade compatible Elasticsearch versions for that specific domain.
     */
    public suspend fun getCompatibleElasticsearchVersions(input: GetCompatibleElasticsearchVersionsRequest = GetCompatibleElasticsearchVersionsRequest {}): GetCompatibleElasticsearchVersionsResponse

    /**
     * Returns a list of versions of the package, along with their creation time and commit message.
     */
    public suspend fun getPackageVersionHistory(input: GetPackageVersionHistoryRequest): GetPackageVersionHistoryResponse

    /**
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     */
    public suspend fun getUpgradeHistory(input: GetUpgradeHistoryRequest): GetUpgradeHistoryResponse

    /**
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     */
    public suspend fun getUpgradeStatus(input: GetUpgradeStatusRequest): GetUpgradeStatusResponse

    /**
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     */
    public suspend fun listDomainNames(input: ListDomainNamesRequest = ListDomainNamesRequest {}): ListDomainNamesResponse

    /**
     * Lists all Amazon ES domains associated with the package.
     */
    public suspend fun listDomainsForPackage(input: ListDomainsForPackageRequest): ListDomainsForPackageResponse

    /**
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     */
    public suspend fun listElasticsearchInstanceTypes(input: ListElasticsearchInstanceTypesRequest): ListElasticsearchInstanceTypesResponse

    /**
     * List all supported Elasticsearch versions
     */
    public suspend fun listElasticsearchVersions(input: ListElasticsearchVersionsRequest = ListElasticsearchVersionsRequest {}): ListElasticsearchVersionsResponse

    /**
     * Lists all packages associated with the Amazon ES domain.
     */
    public suspend fun listPackagesForDomain(input: ListPackagesForDomainRequest): ListPackagesForDomainResponse

    /**
     * Returns all tags for the given Elasticsearch domain.
     */
    public suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Retrieves information about each principal that is allowed to access a given Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     */
    public suspend fun listVpcEndpointAccess(input: ListVpcEndpointAccessRequest): ListVpcEndpointAccessResponse

    /**
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current account and Region.
     */
    public suspend fun listVpcEndpoints(input: ListVpcEndpointsRequest = ListVpcEndpointsRequest {}): ListVpcEndpointsResponse

    /**
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
     */
    public suspend fun listVpcEndpointsForDomain(input: ListVpcEndpointsForDomainRequest): ListVpcEndpointsForDomainResponse

    /**
     * Allows you to purchase reserved Elasticsearch instances.
     */
    public suspend fun purchaseReservedElasticsearchInstanceOffering(input: PurchaseReservedElasticsearchInstanceOfferingRequest): PurchaseReservedElasticsearchInstanceOfferingResponse

    /**
     * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
     */
    public suspend fun rejectInboundCrossClusterSearchConnection(input: RejectInboundCrossClusterSearchConnectionRequest): RejectInboundCrossClusterSearchConnectionResponse

    /**
     * Removes the specified set of tags from the specified Elasticsearch domain.
     */
    public suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     */
    public suspend fun revokeVpcEndpointAccess(input: RevokeVpcEndpointAccessRequest): RevokeVpcEndpointAccessResponse

    /**
     * Schedules a service software update for an Amazon ES domain.
     */
    public suspend fun startElasticsearchServiceSoftwareUpdate(input: StartElasticsearchServiceSoftwareUpdateRequest): StartElasticsearchServiceSoftwareUpdateResponse

    /**
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances.
     */
    public suspend fun updateElasticsearchDomainConfig(input: UpdateElasticsearchDomainConfigRequest): UpdateElasticsearchDomainConfigResponse

    /**
     * Updates a package for use with Amazon ES domains.
     */
    public suspend fun updatePackage(input: UpdatePackageRequest): UpdatePackageResponse

    /**
     * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     */
    public suspend fun updateVpcEndpoint(input: UpdateVpcEndpointRequest): UpdateVpcEndpointResponse

    /**
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.
     */
    public suspend fun upgradeElasticsearchDomain(input: UpgradeElasticsearchDomainRequest): UpgradeElasticsearchDomainResponse
}

/**
 * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
 */
public suspend inline fun ElasticsearchClient.acceptInboundCrossClusterSearchConnection(crossinline block: AcceptInboundCrossClusterSearchConnectionRequest.Builder.() -> Unit): AcceptInboundCrossClusterSearchConnectionResponse = acceptInboundCrossClusterSearchConnection(AcceptInboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

/**
 * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See [ Tagging Amazon Elasticsearch Service Domains for more information.](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging)
 */
public suspend inline fun ElasticsearchClient.addTags(crossinline block: AddTagsRequest.Builder.() -> Unit): AddTagsResponse = addTags(AddTagsRequest.Builder().apply(block).build())

/**
 * Associates a package with an Amazon ES domain.
 */
public suspend inline fun ElasticsearchClient.associatePackage(crossinline block: AssociatePackageRequest.Builder.() -> Unit): AssociatePackageResponse = associatePackage(AssociatePackageRequest.Builder().apply(block).build())

/**
 * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
 */
public suspend inline fun ElasticsearchClient.authorizeVpcEndpointAccess(crossinline block: AuthorizeVpcEndpointAccessRequest.Builder.() -> Unit): AuthorizeVpcEndpointAccessResponse = authorizeVpcEndpointAccess(AuthorizeVpcEndpointAccessRequest.Builder().apply(block).build())

/**
 * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the `AutomatedUpdateDate` and when the `UpdateStatus` is in the `PENDING_UPDATE` state.
 */
public suspend inline fun ElasticsearchClient.cancelElasticsearchServiceSoftwareUpdate(crossinline block: CancelElasticsearchServiceSoftwareUpdateRequest.Builder.() -> Unit): CancelElasticsearchServiceSoftwareUpdateResponse = cancelElasticsearchServiceSoftwareUpdate(CancelElasticsearchServiceSoftwareUpdateRequest.Builder().apply(block).build())

/**
 * Creates a new Elasticsearch domain. For more information, see [Creating Elasticsearch Domains](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains) in the *Amazon Elasticsearch Service Developer Guide*.
 */
public suspend inline fun ElasticsearchClient.createElasticsearchDomain(crossinline block: CreateElasticsearchDomainRequest.Builder.() -> Unit): CreateElasticsearchDomainResponse = createElasticsearchDomain(CreateElasticsearchDomainRequest.Builder().apply(block).build())

/**
 * Creates a new cross-cluster search connection from a source domain to a destination domain.
 */
public suspend inline fun ElasticsearchClient.createOutboundCrossClusterSearchConnection(crossinline block: CreateOutboundCrossClusterSearchConnectionRequest.Builder.() -> Unit): CreateOutboundCrossClusterSearchConnectionResponse = createOutboundCrossClusterSearchConnection(CreateOutboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

/**
 * Create a package for use with Amazon ES domains.
 */
public suspend inline fun ElasticsearchClient.createPackage(crossinline block: CreatePackageRequest.Builder.() -> Unit): CreatePackageResponse = createPackage(CreatePackageRequest.Builder().apply(block).build())

/**
 * Creates an Amazon OpenSearch Service-managed VPC endpoint.
 */
public suspend inline fun ElasticsearchClient.createVpcEndpoint(crossinline block: CreateVpcEndpointRequest.Builder.() -> Unit): CreateVpcEndpointResponse = createVpcEndpoint(CreateVpcEndpointRequest.Builder().apply(block).build())

/**
 * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.
 */
public suspend inline fun ElasticsearchClient.deleteElasticsearchDomain(crossinline block: DeleteElasticsearchDomainRequest.Builder.() -> Unit): DeleteElasticsearchDomainResponse = deleteElasticsearchDomain(DeleteElasticsearchDomainRequest.Builder().apply(block).build())

/**
 * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See [Deleting Elasticsearch Service Role](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr) in *VPC Endpoints for Amazon Elasticsearch Service Domains*.
 */
public suspend inline fun ElasticsearchClient.deleteElasticsearchServiceRole(crossinline block: DeleteElasticsearchServiceRoleRequest.Builder.() -> Unit): DeleteElasticsearchServiceRoleResponse = deleteElasticsearchServiceRole(DeleteElasticsearchServiceRoleRequest.Builder().apply(block).build())

/**
 * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
 */
public suspend inline fun ElasticsearchClient.deleteInboundCrossClusterSearchConnection(crossinline block: DeleteInboundCrossClusterSearchConnectionRequest.Builder.() -> Unit): DeleteInboundCrossClusterSearchConnectionResponse = deleteInboundCrossClusterSearchConnection(DeleteInboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

/**
 * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
 */
public suspend inline fun ElasticsearchClient.deleteOutboundCrossClusterSearchConnection(crossinline block: DeleteOutboundCrossClusterSearchConnectionRequest.Builder.() -> Unit): DeleteOutboundCrossClusterSearchConnectionResponse = deleteOutboundCrossClusterSearchConnection(DeleteOutboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

/**
 * Delete the package.
 */
public suspend inline fun ElasticsearchClient.deletePackage(crossinline block: DeletePackageRequest.Builder.() -> Unit): DeletePackageResponse = deletePackage(DeletePackageRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
 */
public suspend inline fun ElasticsearchClient.deleteVpcEndpoint(crossinline block: DeleteVpcEndpointRequest.Builder.() -> Unit): DeleteVpcEndpointResponse = deleteVpcEndpoint(DeleteVpcEndpointRequest.Builder().apply(block).build())

/**
 * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.
 */
public suspend inline fun ElasticsearchClient.describeDomainAutoTunes(crossinline block: DescribeDomainAutoTunesRequest.Builder.() -> Unit): DescribeDomainAutoTunesResponse = describeDomainAutoTunes(DescribeDomainAutoTunesRequest.Builder().apply(block).build())

/**
 * Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.
 */
public suspend inline fun ElasticsearchClient.describeDomainChangeProgress(crossinline block: DescribeDomainChangeProgressRequest.Builder.() -> Unit): DescribeDomainChangeProgressResponse = describeDomainChangeProgress(DescribeDomainChangeProgressRequest.Builder().apply(block).build())

/**
 * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.
 */
public suspend inline fun ElasticsearchClient.describeElasticsearchDomain(crossinline block: DescribeElasticsearchDomainRequest.Builder.() -> Unit): DescribeElasticsearchDomainResponse = describeElasticsearchDomain(DescribeElasticsearchDomainRequest.Builder().apply(block).build())

/**
 * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.
 */
public suspend inline fun ElasticsearchClient.describeElasticsearchDomainConfig(crossinline block: DescribeElasticsearchDomainConfigRequest.Builder.() -> Unit): DescribeElasticsearchDomainConfigResponse = describeElasticsearchDomainConfig(DescribeElasticsearchDomainConfigRequest.Builder().apply(block).build())

/**
 * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.
 */
public suspend inline fun ElasticsearchClient.describeElasticsearchDomains(crossinline block: DescribeElasticsearchDomainsRequest.Builder.() -> Unit): DescribeElasticsearchDomainsResponse = describeElasticsearchDomains(DescribeElasticsearchDomainsRequest.Builder().apply(block).build())

/**
 * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the ` <a>DomainName</a> ` to know what Limits are supported for modifying.
 */
public suspend inline fun ElasticsearchClient.describeElasticsearchInstanceTypeLimits(crossinline block: DescribeElasticsearchInstanceTypeLimitsRequest.Builder.() -> Unit): DescribeElasticsearchInstanceTypeLimitsResponse = describeElasticsearchInstanceTypeLimits(DescribeElasticsearchInstanceTypeLimitsRequest.Builder().apply(block).build())

/**
 * Lists all the inbound cross-cluster search connections for a destination domain.
 */
public suspend inline fun ElasticsearchClient.describeInboundCrossClusterSearchConnections(crossinline block: DescribeInboundCrossClusterSearchConnectionsRequest.Builder.() -> Unit): DescribeInboundCrossClusterSearchConnectionsResponse = describeInboundCrossClusterSearchConnections(DescribeInboundCrossClusterSearchConnectionsRequest.Builder().apply(block).build())

/**
 * Lists all the outbound cross-cluster search connections for a source domain.
 */
public suspend inline fun ElasticsearchClient.describeOutboundCrossClusterSearchConnections(crossinline block: DescribeOutboundCrossClusterSearchConnectionsRequest.Builder.() -> Unit): DescribeOutboundCrossClusterSearchConnectionsResponse = describeOutboundCrossClusterSearchConnections(DescribeOutboundCrossClusterSearchConnectionsRequest.Builder().apply(block).build())

/**
 * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.
 */
public suspend inline fun ElasticsearchClient.describePackages(crossinline block: DescribePackagesRequest.Builder.() -> Unit): DescribePackagesResponse = describePackages(DescribePackagesRequest.Builder().apply(block).build())

/**
 * Lists available reserved Elasticsearch instance offerings.
 */
public suspend inline fun ElasticsearchClient.describeReservedElasticsearchInstanceOfferings(crossinline block: DescribeReservedElasticsearchInstanceOfferingsRequest.Builder.() -> Unit): DescribeReservedElasticsearchInstanceOfferingsResponse = describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsRequest.Builder().apply(block).build())

/**
 * Returns information about reserved Elasticsearch instances for this account.
 */
public suspend inline fun ElasticsearchClient.describeReservedElasticsearchInstances(crossinline block: DescribeReservedElasticsearchInstancesRequest.Builder.() -> Unit): DescribeReservedElasticsearchInstancesResponse = describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesRequest.Builder().apply(block).build())

/**
 * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
 */
public suspend inline fun ElasticsearchClient.describeVpcEndpoints(crossinline block: DescribeVpcEndpointsRequest.Builder.() -> Unit): DescribeVpcEndpointsResponse = describeVpcEndpoints(DescribeVpcEndpointsRequest.Builder().apply(block).build())

/**
 * Dissociates a package from the Amazon ES domain.
 */
public suspend inline fun ElasticsearchClient.dissociatePackage(crossinline block: DissociatePackageRequest.Builder.() -> Unit): DissociatePackageResponse = dissociatePackage(DissociatePackageRequest.Builder().apply(block).build())

/**
 * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a ` <a>DomainName</a> ` to get all upgrade compatible Elasticsearch versions for that specific domain.
 */
public suspend inline fun ElasticsearchClient.getCompatibleElasticsearchVersions(crossinline block: GetCompatibleElasticsearchVersionsRequest.Builder.() -> Unit): GetCompatibleElasticsearchVersionsResponse = getCompatibleElasticsearchVersions(GetCompatibleElasticsearchVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of versions of the package, along with their creation time and commit message.
 */
public suspend inline fun ElasticsearchClient.getPackageVersionHistory(crossinline block: GetPackageVersionHistoryRequest.Builder.() -> Unit): GetPackageVersionHistoryResponse = getPackageVersionHistory(GetPackageVersionHistoryRequest.Builder().apply(block).build())

/**
 * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
 */
public suspend inline fun ElasticsearchClient.getUpgradeHistory(crossinline block: GetUpgradeHistoryRequest.Builder.() -> Unit): GetUpgradeHistoryResponse = getUpgradeHistory(GetUpgradeHistoryRequest.Builder().apply(block).build())

/**
 * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
 */
public suspend inline fun ElasticsearchClient.getUpgradeStatus(crossinline block: GetUpgradeStatusRequest.Builder.() -> Unit): GetUpgradeStatusResponse = getUpgradeStatus(GetUpgradeStatusRequest.Builder().apply(block).build())

/**
 * Returns the name of all Elasticsearch domains owned by the current user's account.
 */
public suspend inline fun ElasticsearchClient.listDomainNames(crossinline block: ListDomainNamesRequest.Builder.() -> Unit): ListDomainNamesResponse = listDomainNames(ListDomainNamesRequest.Builder().apply(block).build())

/**
 * Lists all Amazon ES domains associated with the package.
 */
public suspend inline fun ElasticsearchClient.listDomainsForPackage(crossinline block: ListDomainsForPackageRequest.Builder.() -> Unit): ListDomainsForPackageResponse = listDomainsForPackage(ListDomainsForPackageRequest.Builder().apply(block).build())

/**
 * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
 */
public suspend inline fun ElasticsearchClient.listElasticsearchInstanceTypes(crossinline block: ListElasticsearchInstanceTypesRequest.Builder.() -> Unit): ListElasticsearchInstanceTypesResponse = listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesRequest.Builder().apply(block).build())

/**
 * List all supported Elasticsearch versions
 */
public suspend inline fun ElasticsearchClient.listElasticsearchVersions(crossinline block: ListElasticsearchVersionsRequest.Builder.() -> Unit): ListElasticsearchVersionsResponse = listElasticsearchVersions(ListElasticsearchVersionsRequest.Builder().apply(block).build())

/**
 * Lists all packages associated with the Amazon ES domain.
 */
public suspend inline fun ElasticsearchClient.listPackagesForDomain(crossinline block: ListPackagesForDomainRequest.Builder.() -> Unit): ListPackagesForDomainResponse = listPackagesForDomain(ListPackagesForDomainRequest.Builder().apply(block).build())

/**
 * Returns all tags for the given Elasticsearch domain.
 */
public suspend inline fun ElasticsearchClient.listTags(crossinline block: ListTagsRequest.Builder.() -> Unit): ListTagsResponse = listTags(ListTagsRequest.Builder().apply(block).build())

/**
 * Retrieves information about each principal that is allowed to access a given Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
 */
public suspend inline fun ElasticsearchClient.listVpcEndpointAccess(crossinline block: ListVpcEndpointAccessRequest.Builder.() -> Unit): ListVpcEndpointAccessResponse = listVpcEndpointAccess(ListVpcEndpointAccessRequest.Builder().apply(block).build())

/**
 * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current account and Region.
 */
public suspend inline fun ElasticsearchClient.listVpcEndpoints(crossinline block: ListVpcEndpointsRequest.Builder.() -> Unit): ListVpcEndpointsResponse = listVpcEndpoints(ListVpcEndpointsRequest.Builder().apply(block).build())

/**
 * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
 */
public suspend inline fun ElasticsearchClient.listVpcEndpointsForDomain(crossinline block: ListVpcEndpointsForDomainRequest.Builder.() -> Unit): ListVpcEndpointsForDomainResponse = listVpcEndpointsForDomain(ListVpcEndpointsForDomainRequest.Builder().apply(block).build())

/**
 * Allows you to purchase reserved Elasticsearch instances.
 */
public suspend inline fun ElasticsearchClient.purchaseReservedElasticsearchInstanceOffering(crossinline block: PurchaseReservedElasticsearchInstanceOfferingRequest.Builder.() -> Unit): PurchaseReservedElasticsearchInstanceOfferingResponse = purchaseReservedElasticsearchInstanceOffering(PurchaseReservedElasticsearchInstanceOfferingRequest.Builder().apply(block).build())

/**
 * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
 */
public suspend inline fun ElasticsearchClient.rejectInboundCrossClusterSearchConnection(crossinline block: RejectInboundCrossClusterSearchConnectionRequest.Builder.() -> Unit): RejectInboundCrossClusterSearchConnectionResponse = rejectInboundCrossClusterSearchConnection(RejectInboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

/**
 * Removes the specified set of tags from the specified Elasticsearch domain.
 */
public suspend inline fun ElasticsearchClient.removeTags(crossinline block: RemoveTagsRequest.Builder.() -> Unit): RemoveTagsResponse = removeTags(RemoveTagsRequest.Builder().apply(block).build())

/**
 * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
 */
public suspend inline fun ElasticsearchClient.revokeVpcEndpointAccess(crossinline block: RevokeVpcEndpointAccessRequest.Builder.() -> Unit): RevokeVpcEndpointAccessResponse = revokeVpcEndpointAccess(RevokeVpcEndpointAccessRequest.Builder().apply(block).build())

/**
 * Schedules a service software update for an Amazon ES domain.
 */
public suspend inline fun ElasticsearchClient.startElasticsearchServiceSoftwareUpdate(crossinline block: StartElasticsearchServiceSoftwareUpdateRequest.Builder.() -> Unit): StartElasticsearchServiceSoftwareUpdateResponse = startElasticsearchServiceSoftwareUpdate(StartElasticsearchServiceSoftwareUpdateRequest.Builder().apply(block).build())

/**
 * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances.
 */
public suspend inline fun ElasticsearchClient.updateElasticsearchDomainConfig(crossinline block: UpdateElasticsearchDomainConfigRequest.Builder.() -> Unit): UpdateElasticsearchDomainConfigResponse = updateElasticsearchDomainConfig(UpdateElasticsearchDomainConfigRequest.Builder().apply(block).build())

/**
 * Updates a package for use with Amazon ES domains.
 */
public suspend inline fun ElasticsearchClient.updatePackage(crossinline block: UpdatePackageRequest.Builder.() -> Unit): UpdatePackageResponse = updatePackage(UpdatePackageRequest.Builder().apply(block).build())

/**
 * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
 */
public suspend inline fun ElasticsearchClient.updateVpcEndpoint(crossinline block: UpdateVpcEndpointRequest.Builder.() -> Unit): UpdateVpcEndpointResponse = updateVpcEndpoint(UpdateVpcEndpointRequest.Builder().apply(block).build())

/**
 * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.
 */
public suspend inline fun ElasticsearchClient.upgradeElasticsearchDomain(crossinline block: UpgradeElasticsearchDomainRequest.Builder.() -> Unit): UpgradeElasticsearchDomainResponse = upgradeElasticsearchDomain(UpgradeElasticsearchDomainRequest.Builder().apply(block).build())
