// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



/**
 * Represents a single step of the Upgrade or Upgrade Eligibility Check workflow.
 */
public class UpgradeStepItem private constructor(builder: Builder) {
    /**
     * A list of strings containing detailed information about the errors encountered in a particular step.
     */
    public val issues: List<String>? = builder.issues
    /**
     * The Floating point value representing progress percentage of a particular step.
     */
    public val progressPercent: kotlin.Double? = builder.progressPercent
    /**
     * Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through:
     * + PreUpgradeCheck
     * + Snapshot
     * + Upgrade
     */
    public val upgradeStep: aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStep? = builder.upgradeStep
    /**
     * The status of a particular step during an upgrade. The status can take one of the following values:
     * + In Progress
     * + Succeeded
     * + Succeeded with Issues
     * + Failed
     */
    public val upgradeStepStatus: aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStatus? = builder.upgradeStepStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStepItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeStepItem(")
        append("issues=$issues,")
        append("progressPercent=$progressPercent,")
        append("upgradeStep=$upgradeStep,")
        append("upgradeStepStatus=$upgradeStepStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = issues?.hashCode() ?: 0
        result = 31 * result + (progressPercent?.hashCode() ?: 0)
        result = 31 * result + (upgradeStep?.hashCode() ?: 0)
        result = 31 * result + (upgradeStepStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeStepItem

        if (issues != other.issues) return false
        if (progressPercent != other.progressPercent) return false
        if (upgradeStep != other.upgradeStep) return false
        if (upgradeStepStatus != other.upgradeStepStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStepItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of strings containing detailed information about the errors encountered in a particular step.
         */
        public var issues: List<String>? = null
        /**
         * The Floating point value representing progress percentage of a particular step.
         */
        public var progressPercent: kotlin.Double? = null
        /**
         * Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through:
         * + PreUpgradeCheck
         * + Snapshot
         * + Upgrade
         */
        public var upgradeStep: aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStep? = null
        /**
         * The status of a particular step during an upgrade. The status can take one of the following values:
         * + In Progress
         * + Succeeded
         * + Succeeded with Issues
         * + Failed
         */
        public var upgradeStepStatus: aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStepItem) : this() {
            this.issues = x.issues
            this.progressPercent = x.progressPercent
            this.upgradeStep = x.upgradeStep
            this.upgradeStepStatus = x.upgradeStepStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStepItem = UpgradeStepItem(this)
    }
}
