// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.elasticsearchservice.model.*
import aws.sdk.kotlin.services.elasticsearchservice.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Elasticsearch Service"
public const val ServiceApiVersion: String = "2015-01-01"
public const val SdkVersion: String = "0.17.5-beta"

internal class DefaultElasticsearchClient(override val config: ElasticsearchClient.Config) : ElasticsearchClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
     */
    override suspend fun acceptInboundCrossClusterSearchConnection(input: AcceptInboundCrossClusterSearchConnectionRequest): AcceptInboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<AcceptInboundCrossClusterSearchConnectionRequest, AcceptInboundCrossClusterSearchConnectionResponse> {
            serializer = AcceptInboundCrossClusterSearchConnectionOperationSerializer()
            deserializer = AcceptInboundCrossClusterSearchConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptInboundCrossClusterSearchConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See [ Tagging Amazon Elasticsearch Service Domains for more information.](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging)
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializer = AddTagsOperationSerializer()
            deserializer = AddTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a package with an Amazon ES domain.
     */
    override suspend fun associatePackage(input: AssociatePackageRequest): AssociatePackageResponse {
        val op = SdkHttpOperation.build<AssociatePackageRequest, AssociatePackageResponse> {
            serializer = AssociatePackageOperationSerializer()
            deserializer = AssociatePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociatePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the `AutomatedUpdateDate` and when the `UpdateStatus` is in the `PENDING_UPDATE` state.
     */
    override suspend fun cancelElasticsearchServiceSoftwareUpdate(input: CancelElasticsearchServiceSoftwareUpdateRequest): CancelElasticsearchServiceSoftwareUpdateResponse {
        val op = SdkHttpOperation.build<CancelElasticsearchServiceSoftwareUpdateRequest, CancelElasticsearchServiceSoftwareUpdateResponse> {
            serializer = CancelElasticsearchServiceSoftwareUpdateOperationSerializer()
            deserializer = CancelElasticsearchServiceSoftwareUpdateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelElasticsearchServiceSoftwareUpdate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Elasticsearch domain. For more information, see [Creating Elasticsearch Domains](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains) in the *Amazon Elasticsearch Service Developer Guide*.
     */
    override suspend fun createElasticsearchDomain(input: CreateElasticsearchDomainRequest): CreateElasticsearchDomainResponse {
        val op = SdkHttpOperation.build<CreateElasticsearchDomainRequest, CreateElasticsearchDomainResponse> {
            serializer = CreateElasticsearchDomainOperationSerializer()
            deserializer = CreateElasticsearchDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateElasticsearchDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new cross-cluster search connection from a source domain to a destination domain.
     */
    override suspend fun createOutboundCrossClusterSearchConnection(input: CreateOutboundCrossClusterSearchConnectionRequest): CreateOutboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<CreateOutboundCrossClusterSearchConnectionRequest, CreateOutboundCrossClusterSearchConnectionResponse> {
            serializer = CreateOutboundCrossClusterSearchConnectionOperationSerializer()
            deserializer = CreateOutboundCrossClusterSearchConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateOutboundCrossClusterSearchConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a package for use with Amazon ES domains.
     */
    override suspend fun createPackage(input: CreatePackageRequest): CreatePackageResponse {
        val op = SdkHttpOperation.build<CreatePackageRequest, CreatePackageResponse> {
            serializer = CreatePackageOperationSerializer()
            deserializer = CreatePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.
     */
    override suspend fun deleteElasticsearchDomain(input: DeleteElasticsearchDomainRequest): DeleteElasticsearchDomainResponse {
        val op = SdkHttpOperation.build<DeleteElasticsearchDomainRequest, DeleteElasticsearchDomainResponse> {
            serializer = DeleteElasticsearchDomainOperationSerializer()
            deserializer = DeleteElasticsearchDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteElasticsearchDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See [Deleting Elasticsearch Service Role](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr) in *VPC Endpoints for Amazon Elasticsearch Service Domains*.
     */
    override suspend fun deleteElasticsearchServiceRole(input: DeleteElasticsearchServiceRoleRequest): DeleteElasticsearchServiceRoleResponse {
        val op = SdkHttpOperation.build<DeleteElasticsearchServiceRoleRequest, DeleteElasticsearchServiceRoleResponse> {
            serializer = DeleteElasticsearchServiceRoleOperationSerializer()
            deserializer = DeleteElasticsearchServiceRoleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteElasticsearchServiceRole"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
     */
    override suspend fun deleteInboundCrossClusterSearchConnection(input: DeleteInboundCrossClusterSearchConnectionRequest): DeleteInboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<DeleteInboundCrossClusterSearchConnectionRequest, DeleteInboundCrossClusterSearchConnectionResponse> {
            serializer = DeleteInboundCrossClusterSearchConnectionOperationSerializer()
            deserializer = DeleteInboundCrossClusterSearchConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInboundCrossClusterSearchConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
     */
    override suspend fun deleteOutboundCrossClusterSearchConnection(input: DeleteOutboundCrossClusterSearchConnectionRequest): DeleteOutboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<DeleteOutboundCrossClusterSearchConnectionRequest, DeleteOutboundCrossClusterSearchConnectionResponse> {
            serializer = DeleteOutboundCrossClusterSearchConnectionOperationSerializer()
            deserializer = DeleteOutboundCrossClusterSearchConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteOutboundCrossClusterSearchConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete the package.
     */
    override suspend fun deletePackage(input: DeletePackageRequest): DeletePackageResponse {
        val op = SdkHttpOperation.build<DeletePackageRequest, DeletePackageResponse> {
            serializer = DeletePackageOperationSerializer()
            deserializer = DeletePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.
     */
    override suspend fun describeDomainAutoTunes(input: DescribeDomainAutoTunesRequest): DescribeDomainAutoTunesResponse {
        val op = SdkHttpOperation.build<DescribeDomainAutoTunesRequest, DescribeDomainAutoTunesResponse> {
            serializer = DescribeDomainAutoTunesOperationSerializer()
            deserializer = DescribeDomainAutoTunesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomainAutoTunes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.
     */
    override suspend fun describeDomainChangeProgress(input: DescribeDomainChangeProgressRequest): DescribeDomainChangeProgressResponse {
        val op = SdkHttpOperation.build<DescribeDomainChangeProgressRequest, DescribeDomainChangeProgressResponse> {
            serializer = DescribeDomainChangeProgressOperationSerializer()
            deserializer = DescribeDomainChangeProgressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomainChangeProgress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.
     */
    override suspend fun describeElasticsearchDomain(input: DescribeElasticsearchDomainRequest): DescribeElasticsearchDomainResponse {
        val op = SdkHttpOperation.build<DescribeElasticsearchDomainRequest, DescribeElasticsearchDomainResponse> {
            serializer = DescribeElasticsearchDomainOperationSerializer()
            deserializer = DescribeElasticsearchDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeElasticsearchDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.
     */
    override suspend fun describeElasticsearchDomainConfig(input: DescribeElasticsearchDomainConfigRequest): DescribeElasticsearchDomainConfigResponse {
        val op = SdkHttpOperation.build<DescribeElasticsearchDomainConfigRequest, DescribeElasticsearchDomainConfigResponse> {
            serializer = DescribeElasticsearchDomainConfigOperationSerializer()
            deserializer = DescribeElasticsearchDomainConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeElasticsearchDomainConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.
     */
    override suspend fun describeElasticsearchDomains(input: DescribeElasticsearchDomainsRequest): DescribeElasticsearchDomainsResponse {
        val op = SdkHttpOperation.build<DescribeElasticsearchDomainsRequest, DescribeElasticsearchDomainsResponse> {
            serializer = DescribeElasticsearchDomainsOperationSerializer()
            deserializer = DescribeElasticsearchDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeElasticsearchDomains"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the ` <a>DomainName</a> ` to know what Limits are supported for modifying.
     */
    override suspend fun describeElasticsearchInstanceTypeLimits(input: DescribeElasticsearchInstanceTypeLimitsRequest): DescribeElasticsearchInstanceTypeLimitsResponse {
        val op = SdkHttpOperation.build<DescribeElasticsearchInstanceTypeLimitsRequest, DescribeElasticsearchInstanceTypeLimitsResponse> {
            serializer = DescribeElasticsearchInstanceTypeLimitsOperationSerializer()
            deserializer = DescribeElasticsearchInstanceTypeLimitsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeElasticsearchInstanceTypeLimits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the inbound cross-cluster search connections for a destination domain.
     */
    override suspend fun describeInboundCrossClusterSearchConnections(input: DescribeInboundCrossClusterSearchConnectionsRequest): DescribeInboundCrossClusterSearchConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeInboundCrossClusterSearchConnectionsRequest, DescribeInboundCrossClusterSearchConnectionsResponse> {
            serializer = DescribeInboundCrossClusterSearchConnectionsOperationSerializer()
            deserializer = DescribeInboundCrossClusterSearchConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInboundCrossClusterSearchConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the outbound cross-cluster search connections for a source domain.
     */
    override suspend fun describeOutboundCrossClusterSearchConnections(input: DescribeOutboundCrossClusterSearchConnectionsRequest): DescribeOutboundCrossClusterSearchConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeOutboundCrossClusterSearchConnectionsRequest, DescribeOutboundCrossClusterSearchConnectionsResponse> {
            serializer = DescribeOutboundCrossClusterSearchConnectionsOperationSerializer()
            deserializer = DescribeOutboundCrossClusterSearchConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOutboundCrossClusterSearchConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.
     */
    override suspend fun describePackages(input: DescribePackagesRequest): DescribePackagesResponse {
        val op = SdkHttpOperation.build<DescribePackagesRequest, DescribePackagesResponse> {
            serializer = DescribePackagesOperationSerializer()
            deserializer = DescribePackagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePackages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists available reserved Elasticsearch instance offerings.
     */
    override suspend fun describeReservedElasticsearchInstanceOfferings(input: DescribeReservedElasticsearchInstanceOfferingsRequest): DescribeReservedElasticsearchInstanceOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeReservedElasticsearchInstanceOfferingsRequest, DescribeReservedElasticsearchInstanceOfferingsResponse> {
            serializer = DescribeReservedElasticsearchInstanceOfferingsOperationSerializer()
            deserializer = DescribeReservedElasticsearchInstanceOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedElasticsearchInstanceOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about reserved Elasticsearch instances for this account.
     */
    override suspend fun describeReservedElasticsearchInstances(input: DescribeReservedElasticsearchInstancesRequest): DescribeReservedElasticsearchInstancesResponse {
        val op = SdkHttpOperation.build<DescribeReservedElasticsearchInstancesRequest, DescribeReservedElasticsearchInstancesResponse> {
            serializer = DescribeReservedElasticsearchInstancesOperationSerializer()
            deserializer = DescribeReservedElasticsearchInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedElasticsearchInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Dissociates a package from the Amazon ES domain.
     */
    override suspend fun dissociatePackage(input: DissociatePackageRequest): DissociatePackageResponse {
        val op = SdkHttpOperation.build<DissociatePackageRequest, DissociatePackageResponse> {
            serializer = DissociatePackageOperationSerializer()
            deserializer = DissociatePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DissociatePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a ` <a>DomainName</a> ` to get all upgrade compatible Elasticsearch versions for that specific domain.
     */
    override suspend fun getCompatibleElasticsearchVersions(input: GetCompatibleElasticsearchVersionsRequest): GetCompatibleElasticsearchVersionsResponse {
        val op = SdkHttpOperation.build<GetCompatibleElasticsearchVersionsRequest, GetCompatibleElasticsearchVersionsResponse> {
            serializer = GetCompatibleElasticsearchVersionsOperationSerializer()
            deserializer = GetCompatibleElasticsearchVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCompatibleElasticsearchVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of versions of the package, along with their creation time and commit message.
     */
    override suspend fun getPackageVersionHistory(input: GetPackageVersionHistoryRequest): GetPackageVersionHistoryResponse {
        val op = SdkHttpOperation.build<GetPackageVersionHistoryRequest, GetPackageVersionHistoryResponse> {
            serializer = GetPackageVersionHistoryOperationSerializer()
            deserializer = GetPackageVersionHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPackageVersionHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     */
    override suspend fun getUpgradeHistory(input: GetUpgradeHistoryRequest): GetUpgradeHistoryResponse {
        val op = SdkHttpOperation.build<GetUpgradeHistoryRequest, GetUpgradeHistoryResponse> {
            serializer = GetUpgradeHistoryOperationSerializer()
            deserializer = GetUpgradeHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUpgradeHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     */
    override suspend fun getUpgradeStatus(input: GetUpgradeStatusRequest): GetUpgradeStatusResponse {
        val op = SdkHttpOperation.build<GetUpgradeStatusRequest, GetUpgradeStatusResponse> {
            serializer = GetUpgradeStatusOperationSerializer()
            deserializer = GetUpgradeStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUpgradeStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     */
    override suspend fun listDomainNames(input: ListDomainNamesRequest): ListDomainNamesResponse {
        val op = SdkHttpOperation.build<ListDomainNamesRequest, ListDomainNamesResponse> {
            serializer = ListDomainNamesOperationSerializer()
            deserializer = ListDomainNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainNames"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Amazon ES domains associated with the package.
     */
    override suspend fun listDomainsForPackage(input: ListDomainsForPackageRequest): ListDomainsForPackageResponse {
        val op = SdkHttpOperation.build<ListDomainsForPackageRequest, ListDomainsForPackageResponse> {
            serializer = ListDomainsForPackageOperationSerializer()
            deserializer = ListDomainsForPackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainsForPackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     */
    override suspend fun listElasticsearchInstanceTypes(input: ListElasticsearchInstanceTypesRequest): ListElasticsearchInstanceTypesResponse {
        val op = SdkHttpOperation.build<ListElasticsearchInstanceTypesRequest, ListElasticsearchInstanceTypesResponse> {
            serializer = ListElasticsearchInstanceTypesOperationSerializer()
            deserializer = ListElasticsearchInstanceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListElasticsearchInstanceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all supported Elasticsearch versions
     */
    override suspend fun listElasticsearchVersions(input: ListElasticsearchVersionsRequest): ListElasticsearchVersionsResponse {
        val op = SdkHttpOperation.build<ListElasticsearchVersionsRequest, ListElasticsearchVersionsResponse> {
            serializer = ListElasticsearchVersionsOperationSerializer()
            deserializer = ListElasticsearchVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListElasticsearchVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all packages associated with the Amazon ES domain.
     */
    override suspend fun listPackagesForDomain(input: ListPackagesForDomainRequest): ListPackagesForDomainResponse {
        val op = SdkHttpOperation.build<ListPackagesForDomainRequest, ListPackagesForDomainResponse> {
            serializer = ListPackagesForDomainOperationSerializer()
            deserializer = ListPackagesForDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPackagesForDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns all tags for the given Elasticsearch domain.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to purchase reserved Elasticsearch instances.
     */
    override suspend fun purchaseReservedElasticsearchInstanceOffering(input: PurchaseReservedElasticsearchInstanceOfferingRequest): PurchaseReservedElasticsearchInstanceOfferingResponse {
        val op = SdkHttpOperation.build<PurchaseReservedElasticsearchInstanceOfferingRequest, PurchaseReservedElasticsearchInstanceOfferingResponse> {
            serializer = PurchaseReservedElasticsearchInstanceOfferingOperationSerializer()
            deserializer = PurchaseReservedElasticsearchInstanceOfferingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PurchaseReservedElasticsearchInstanceOffering"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
     */
    override suspend fun rejectInboundCrossClusterSearchConnection(input: RejectInboundCrossClusterSearchConnectionRequest): RejectInboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<RejectInboundCrossClusterSearchConnectionRequest, RejectInboundCrossClusterSearchConnectionResponse> {
            serializer = RejectInboundCrossClusterSearchConnectionOperationSerializer()
            deserializer = RejectInboundCrossClusterSearchConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectInboundCrossClusterSearchConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified set of tags from the specified Elasticsearch domain.
     */
    override suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse {
        val op = SdkHttpOperation.build<RemoveTagsRequest, RemoveTagsResponse> {
            serializer = RemoveTagsOperationSerializer()
            deserializer = RemoveTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Schedules a service software update for an Amazon ES domain.
     */
    override suspend fun startElasticsearchServiceSoftwareUpdate(input: StartElasticsearchServiceSoftwareUpdateRequest): StartElasticsearchServiceSoftwareUpdateResponse {
        val op = SdkHttpOperation.build<StartElasticsearchServiceSoftwareUpdateRequest, StartElasticsearchServiceSoftwareUpdateResponse> {
            serializer = StartElasticsearchServiceSoftwareUpdateOperationSerializer()
            deserializer = StartElasticsearchServiceSoftwareUpdateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartElasticsearchServiceSoftwareUpdate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances.
     */
    override suspend fun updateElasticsearchDomainConfig(input: UpdateElasticsearchDomainConfigRequest): UpdateElasticsearchDomainConfigResponse {
        val op = SdkHttpOperation.build<UpdateElasticsearchDomainConfigRequest, UpdateElasticsearchDomainConfigResponse> {
            serializer = UpdateElasticsearchDomainConfigOperationSerializer()
            deserializer = UpdateElasticsearchDomainConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateElasticsearchDomainConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a package for use with Amazon ES domains.
     */
    override suspend fun updatePackage(input: UpdatePackageRequest): UpdatePackageResponse {
        val op = SdkHttpOperation.build<UpdatePackageRequest, UpdatePackageResponse> {
            serializer = UpdatePackageOperationSerializer()
            deserializer = UpdatePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.
     */
    override suspend fun upgradeElasticsearchDomain(input: UpgradeElasticsearchDomainRequest): UpgradeElasticsearchDomainResponse {
        val op = SdkHttpOperation.build<UpgradeElasticsearchDomainRequest, UpgradeElasticsearchDomainResponse> {
            serializer = UpgradeElasticsearchDomainOperationSerializer()
            deserializer = UpgradeElasticsearchDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpgradeElasticsearchDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "es")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
