// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.elasticsearchservice.model.DescribeElasticsearchInstanceTypeLimitsResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.Limits
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeElasticsearchInstanceTypeLimitsOperationDeserializer: HttpDeserialize<DescribeElasticsearchInstanceTypeLimitsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeElasticsearchInstanceTypeLimitsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeElasticsearchInstanceTypeLimitsError(context, response)
        }
        val builder = DescribeElasticsearchInstanceTypeLimitsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeElasticsearchInstanceTypeLimitsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeElasticsearchInstanceTypeLimitsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTypeException" -> InvalidTypeExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeElasticsearchInstanceTypeLimitsOperationBody(builder: DescribeElasticsearchInstanceTypeLimitsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LIMITSBYROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("LimitsByRole"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LIMITSBYROLE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LIMITSBYROLE_DESCRIPTOR.index -> builder.limitsByRole =
                    deserializer.deserializeMap(LIMITSBYROLE_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Limits>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeLimitsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
