// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies details of the scheduled Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide for more information.
 */
class ScheduledAutoTuneDetails private constructor(builder: Builder) {
    /**
     * Specifies Auto-Tune action description.
     */
    val action: kotlin.String? = builder.action
    /**
     * Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
     */
    val actionType: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneActionType? = builder.actionType
    /**
     * Specifies timestamp for the Auto-Tune action scheduled for the domain.
     */
    val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
     */
    val severity: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneSeverityType? = builder.severity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledAutoTuneDetails(")
        append("action=$action,")
        append("actionType=$actionType,")
        append("date=$date,")
        append("severity=$severity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (actionType?.hashCode() ?: 0)
        result = 31 * result + (date?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledAutoTuneDetails

        if (action != other.action) return false
        if (actionType != other.actionType) return false
        if (date != other.date) return false
        if (severity != other.severity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies Auto-Tune action description.
         */
        var action: kotlin.String? = null
        /**
         * Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
         */
        var actionType: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneActionType? = null
        /**
         * Specifies timestamp for the Auto-Tune action scheduled for the domain.
         */
        var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
         */
        var severity: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneSeverityType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneDetails) : this() {
            this.action = x.action
            this.actionType = x.actionType
            this.date = x.date
            this.severity = x.severity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneDetails = ScheduledAutoTuneDetails(this)
    }
}
