// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



/**
 * Details of a reserved Elasticsearch instance offering.
 */
class ReservedElasticsearchInstanceOffering private constructor(builder: Builder) {
    /**
     * The currency code for the reserved Elasticsearch instance offering.
     */
    val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The duration, in seconds, for which the offering will reserve the Elasticsearch instance.
     */
    val duration: kotlin.Int = builder.duration
    /**
     * The Elasticsearch instance type offered by the reserved instance offering.
     */
    val elasticsearchInstanceType: aws.sdk.kotlin.services.elasticsearchservice.model.EsPartitionInstanceType? = builder.elasticsearchInstanceType
    /**
     * The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering.
     */
    val fixedPrice: kotlin.Double? = builder.fixedPrice
    /**
     * Payment option for the reserved Elasticsearch instance offering
     */
    val paymentOption: aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstancePaymentOption? = builder.paymentOption
    /**
     * The charge to your account regardless of whether you are creating any domains using the instance offering.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The Elasticsearch reserved instance offering identifier.
     */
    val reservedElasticsearchInstanceOfferingId: kotlin.String? = builder.reservedElasticsearchInstanceOfferingId
    /**
     * The rate you are charged for each hour the domain that is using the offering is running.
     */
    val usagePrice: kotlin.Double? = builder.usagePrice

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstanceOffering = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedElasticsearchInstanceOffering(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("elasticsearchInstanceType=$elasticsearchInstanceType,")
        append("fixedPrice=$fixedPrice,")
        append("paymentOption=$paymentOption,")
        append("recurringCharges=$recurringCharges,")
        append("reservedElasticsearchInstanceOfferingId=$reservedElasticsearchInstanceOfferingId,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration)
        result = 31 * result + (elasticsearchInstanceType?.hashCode() ?: 0)
        result = 31 * result + (fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedElasticsearchInstanceOfferingId?.hashCode() ?: 0)
        result = 31 * result + (usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedElasticsearchInstanceOffering

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (elasticsearchInstanceType != other.elasticsearchInstanceType) return false
        if (fixedPrice != other.fixedPrice) return false
        if (paymentOption != other.paymentOption) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedElasticsearchInstanceOfferingId != other.reservedElasticsearchInstanceOfferingId) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstanceOffering = Builder(this).apply(block).build()

    class Builder {
        /**
         * The currency code for the reserved Elasticsearch instance offering.
         */
        var currencyCode: kotlin.String? = null
        /**
         * The duration, in seconds, for which the offering will reserve the Elasticsearch instance.
         */
        var duration: kotlin.Int = 0
        /**
         * The Elasticsearch instance type offered by the reserved instance offering.
         */
        var elasticsearchInstanceType: aws.sdk.kotlin.services.elasticsearchservice.model.EsPartitionInstanceType? = null
        /**
         * The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering.
         */
        var fixedPrice: kotlin.Double? = null
        /**
         * Payment option for the reserved Elasticsearch instance offering
         */
        var paymentOption: aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstancePaymentOption? = null
        /**
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         */
        var recurringCharges: List<RecurringCharge>? = null
        /**
         * The Elasticsearch reserved instance offering identifier.
         */
        var reservedElasticsearchInstanceOfferingId: kotlin.String? = null
        /**
         * The rate you are charged for each hour the domain that is using the offering is running.
         */
        var usagePrice: kotlin.Double? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstanceOffering) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.elasticsearchInstanceType = x.elasticsearchInstanceType
            this.fixedPrice = x.fixedPrice
            this.paymentOption = x.paymentOption
            this.recurringCharges = x.recurringCharges
            this.reservedElasticsearchInstanceOfferingId = x.reservedElasticsearchInstanceOfferingId
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.ReservedElasticsearchInstanceOffering = ReservedElasticsearchInstanceOffering(this)
    }
}
