// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



/**
 * Container for the parameters to the
 *
 * ListElasticsearchInstanceTypes
 *
 * operation.
 */
class ListElasticsearchInstanceTypesRequest private constructor(builder: Builder) {
    /**
     * DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are
     * querying for list of available Elasticsearch instance types when modifying existing domain.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * Version of Elasticsearch for which list of supported elasticsearch
     * instance types are needed.
     */
    val elasticsearchVersion: kotlin.String? = builder.elasticsearchVersion
    /**
     * Set this value to limit the number of results returned.
     * Value provided must be greater than 30 else it wont be honored.
     */
    val maxResults: kotlin.Int = builder.maxResults
    /**
     * NextToken should be sent in case if earlier API call produced result
     * containing NextToken. It is used for pagination.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchInstanceTypesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListElasticsearchInstanceTypesRequest(")
        append("domainName=$domainName,")
        append("elasticsearchVersion=$elasticsearchVersion,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (elasticsearchVersion?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListElasticsearchInstanceTypesRequest

        if (domainName != other.domainName) return false
        if (elasticsearchVersion != other.elasticsearchVersion) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchInstanceTypesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are
         * querying for list of available Elasticsearch instance types when modifying existing domain.
         */
        var domainName: kotlin.String? = null
        /**
         * Version of Elasticsearch for which list of supported elasticsearch
         * instance types are needed.
         */
        var elasticsearchVersion: kotlin.String? = null
        /**
         * Set this value to limit the number of results returned.
         * Value provided must be greater than 30 else it wont be honored.
         */
        var maxResults: kotlin.Int = 0
        /**
         * NextToken should be sent in case if earlier API call produced result
         * containing NextToken. It is used for pagination.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchInstanceTypesRequest) : this() {
            this.domainName = x.domainName
            this.elasticsearchVersion = x.elasticsearchVersion
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchInstanceTypesRequest = ListElasticsearchInstanceTypesRequest(this)
    }
}
