// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



class CreateElasticsearchDomainRequest private constructor(builder: Builder) {
    /**
     * IAM access policy as a JSON-formatted string.
     */
    val accessPolicies: kotlin.String? = builder.accessPolicies
    /**
     * Option to allow references to indices in an HTTP request body.  Must be false when configuring access to individual sub-resources.  By default, the value is true.
     * See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options for more information.
     */
    val advancedOptions: Map<String, String>? = builder.advancedOptions
    /**
     * Specifies advanced security options.
     */
    val advancedSecurityOptions: aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedSecurityOptionsInput? = builder.advancedSecurityOptions
    /**
     * Specifies Auto-Tune options.
     */
    val autoTuneOptions: aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneOptionsInput? = builder.autoTuneOptions
    /**
     * Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana.
     */
    val cognitoOptions: aws.sdk.kotlin.services.elasticsearchservice.model.CognitoOptions? = builder.cognitoOptions
    /**
     * Options to specify configuration that will be applied to the domain endpoint.
     */
    val domainEndpointOptions: aws.sdk.kotlin.services.elasticsearchservice.model.DomainEndpointOptions? = builder.domainEndpointOptions
    /**
     * The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * Options to enable, disable and specify the type and size of EBS storage volumes.
     */
    val ebsOptions: aws.sdk.kotlin.services.elasticsearchservice.model.EbsOptions? = builder.ebsOptions
    /**
     * Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster.
     */
    val elasticsearchClusterConfig: aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchClusterConfig? = builder.elasticsearchClusterConfig
    /**
     * String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information,
     * see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains in the Amazon Elasticsearch Service Developer Guide.
     */
    val elasticsearchVersion: kotlin.String? = builder.elasticsearchVersion
    /**
     * Specifies the Encryption At Rest Options.
     */
    val encryptionAtRestOptions: aws.sdk.kotlin.services.elasticsearchservice.model.EncryptionAtRestOptions? = builder.encryptionAtRestOptions
    /**
     * Map of LogType and LogPublishingOption, each containing options to publish a given type of Elasticsearch log.
     */
    val logPublishingOptions: Map<String, LogPublishingOption>? = builder.logPublishingOptions
    /**
     * Specifies the NodeToNodeEncryptionOptions.
     */
    val nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.elasticsearchservice.model.NodeToNodeEncryptionOptions? = builder.nodeToNodeEncryptionOptions
    /**
     * Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.
     */
    val snapshotOptions: aws.sdk.kotlin.services.elasticsearchservice.model.SnapshotOptions? = builder.snapshotOptions
    /**
     * A list of Tag added during domain creation.
     */
    val tagList: List<Tag>? = builder.tagList
    /**
     * Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC in VPC Endpoints for Amazon Elasticsearch Service Domains
     */
    val vpcOptions: aws.sdk.kotlin.services.elasticsearchservice.model.VpcOptions? = builder.vpcOptions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.CreateElasticsearchDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateElasticsearchDomainRequest(")
        append("accessPolicies=$accessPolicies,")
        append("advancedOptions=$advancedOptions,")
        append("advancedSecurityOptions=$advancedSecurityOptions,")
        append("autoTuneOptions=$autoTuneOptions,")
        append("cognitoOptions=$cognitoOptions,")
        append("domainEndpointOptions=$domainEndpointOptions,")
        append("domainName=$domainName,")
        append("ebsOptions=$ebsOptions,")
        append("elasticsearchClusterConfig=$elasticsearchClusterConfig,")
        append("elasticsearchVersion=$elasticsearchVersion,")
        append("encryptionAtRestOptions=$encryptionAtRestOptions,")
        append("logPublishingOptions=$logPublishingOptions,")
        append("nodeToNodeEncryptionOptions=$nodeToNodeEncryptionOptions,")
        append("snapshotOptions=$snapshotOptions,")
        append("tagList=$tagList,")
        append("vpcOptions=$vpcOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicies?.hashCode() ?: 0
        result = 31 * result + (advancedOptions?.hashCode() ?: 0)
        result = 31 * result + (advancedSecurityOptions?.hashCode() ?: 0)
        result = 31 * result + (autoTuneOptions?.hashCode() ?: 0)
        result = 31 * result + (cognitoOptions?.hashCode() ?: 0)
        result = 31 * result + (domainEndpointOptions?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (ebsOptions?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchClusterConfig?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchVersion?.hashCode() ?: 0)
        result = 31 * result + (encryptionAtRestOptions?.hashCode() ?: 0)
        result = 31 * result + (logPublishingOptions?.hashCode() ?: 0)
        result = 31 * result + (nodeToNodeEncryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (snapshotOptions?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (vpcOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateElasticsearchDomainRequest

        if (accessPolicies != other.accessPolicies) return false
        if (advancedOptions != other.advancedOptions) return false
        if (advancedSecurityOptions != other.advancedSecurityOptions) return false
        if (autoTuneOptions != other.autoTuneOptions) return false
        if (cognitoOptions != other.cognitoOptions) return false
        if (domainEndpointOptions != other.domainEndpointOptions) return false
        if (domainName != other.domainName) return false
        if (ebsOptions != other.ebsOptions) return false
        if (elasticsearchClusterConfig != other.elasticsearchClusterConfig) return false
        if (elasticsearchVersion != other.elasticsearchVersion) return false
        if (encryptionAtRestOptions != other.encryptionAtRestOptions) return false
        if (logPublishingOptions != other.logPublishingOptions) return false
        if (nodeToNodeEncryptionOptions != other.nodeToNodeEncryptionOptions) return false
        if (snapshotOptions != other.snapshotOptions) return false
        if (tagList != other.tagList) return false
        if (vpcOptions != other.vpcOptions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.CreateElasticsearchDomainRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * IAM access policy as a JSON-formatted string.
         */
        var accessPolicies: kotlin.String? = null
        /**
         * Option to allow references to indices in an HTTP request body.  Must be false when configuring access to individual sub-resources.  By default, the value is true.
         * See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options for more information.
         */
        var advancedOptions: Map<String, String>? = null
        /**
         * Specifies advanced security options.
         */
        var advancedSecurityOptions: aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedSecurityOptionsInput? = null
        /**
         * Specifies Auto-Tune options.
         */
        var autoTuneOptions: aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneOptionsInput? = null
        /**
         * Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana.
         */
        var cognitoOptions: aws.sdk.kotlin.services.elasticsearchservice.model.CognitoOptions? = null
        /**
         * Options to specify configuration that will be applied to the domain endpoint.
         */
        var domainEndpointOptions: aws.sdk.kotlin.services.elasticsearchservice.model.DomainEndpointOptions? = null
        /**
         * The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: kotlin.String? = null
        /**
         * Options to enable, disable and specify the type and size of EBS storage volumes.
         */
        var ebsOptions: aws.sdk.kotlin.services.elasticsearchservice.model.EbsOptions? = null
        /**
         * Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster.
         */
        var elasticsearchClusterConfig: aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchClusterConfig? = null
        /**
         * String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information,
         * see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains in the Amazon Elasticsearch Service Developer Guide.
         */
        var elasticsearchVersion: kotlin.String? = null
        /**
         * Specifies the Encryption At Rest Options.
         */
        var encryptionAtRestOptions: aws.sdk.kotlin.services.elasticsearchservice.model.EncryptionAtRestOptions? = null
        /**
         * Map of LogType and LogPublishingOption, each containing options to publish a given type of Elasticsearch log.
         */
        var logPublishingOptions: Map<String, LogPublishingOption>? = null
        /**
         * Specifies the NodeToNodeEncryptionOptions.
         */
        var nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.elasticsearchservice.model.NodeToNodeEncryptionOptions? = null
        /**
         * Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.
         */
        var snapshotOptions: aws.sdk.kotlin.services.elasticsearchservice.model.SnapshotOptions? = null
        /**
         * A list of Tag added during domain creation.
         */
        var tagList: List<Tag>? = null
        /**
         * Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC in VPC Endpoints for Amazon Elasticsearch Service Domains
         */
        var vpcOptions: aws.sdk.kotlin.services.elasticsearchservice.model.VpcOptions? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.CreateElasticsearchDomainRequest) : this() {
            this.accessPolicies = x.accessPolicies
            this.advancedOptions = x.advancedOptions
            this.advancedSecurityOptions = x.advancedSecurityOptions
            this.autoTuneOptions = x.autoTuneOptions
            this.cognitoOptions = x.cognitoOptions
            this.domainEndpointOptions = x.domainEndpointOptions
            this.domainName = x.domainName
            this.ebsOptions = x.ebsOptions
            this.elasticsearchClusterConfig = x.elasticsearchClusterConfig
            this.elasticsearchVersion = x.elasticsearchVersion
            this.encryptionAtRestOptions = x.encryptionAtRestOptions
            this.logPublishingOptions = x.logPublishingOptions
            this.nodeToNodeEncryptionOptions = x.nodeToNodeEncryptionOptions
            this.snapshotOptions = x.snapshotOptions
            this.tagList = x.tagList
            this.vpcOptions = x.vpcOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.CreateElasticsearchDomainRequest = CreateElasticsearchDomainRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedSecurityOptionsInput] inside the given [block]
         */
        fun advancedSecurityOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedSecurityOptionsInput.Builder.() -> kotlin.Unit) {
            this.advancedSecurityOptions = aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedSecurityOptionsInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneOptionsInput] inside the given [block]
         */
        fun autoTuneOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneOptionsInput.Builder.() -> kotlin.Unit) {
            this.autoTuneOptions = aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneOptionsInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.CognitoOptions] inside the given [block]
         */
        fun cognitoOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.CognitoOptions.Builder.() -> kotlin.Unit) {
            this.cognitoOptions = aws.sdk.kotlin.services.elasticsearchservice.model.CognitoOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.DomainEndpointOptions] inside the given [block]
         */
        fun domainEndpointOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.DomainEndpointOptions.Builder.() -> kotlin.Unit) {
            this.domainEndpointOptions = aws.sdk.kotlin.services.elasticsearchservice.model.DomainEndpointOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.EbsOptions] inside the given [block]
         */
        fun ebsOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.EbsOptions.Builder.() -> kotlin.Unit) {
            this.ebsOptions = aws.sdk.kotlin.services.elasticsearchservice.model.EbsOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchClusterConfig] inside the given [block]
         */
        fun elasticsearchClusterConfig(block: aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchClusterConfig.Builder.() -> kotlin.Unit) {
            this.elasticsearchClusterConfig = aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchClusterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.EncryptionAtRestOptions] inside the given [block]
         */
        fun encryptionAtRestOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.EncryptionAtRestOptions.Builder.() -> kotlin.Unit) {
            this.encryptionAtRestOptions = aws.sdk.kotlin.services.elasticsearchservice.model.EncryptionAtRestOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.NodeToNodeEncryptionOptions] inside the given [block]
         */
        fun nodeToNodeEncryptionOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.NodeToNodeEncryptionOptions.Builder.() -> kotlin.Unit) {
            this.nodeToNodeEncryptionOptions = aws.sdk.kotlin.services.elasticsearchservice.model.NodeToNodeEncryptionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.SnapshotOptions] inside the given [block]
         */
        fun snapshotOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.SnapshotOptions.Builder.() -> kotlin.Unit) {
            this.snapshotOptions = aws.sdk.kotlin.services.elasticsearchservice.model.SnapshotOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.VpcOptions] inside the given [block]
         */
        fun vpcOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.VpcOptions.Builder.() -> kotlin.Unit) {
            this.vpcOptions = aws.sdk.kotlin.services.elasticsearchservice.model.VpcOptions.invoke(block)
        }
    }
}
