// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



/**
 * Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana.
 */
class CognitoOptions private constructor(builder: Builder) {
    /**
     * Specifies the option to enable Cognito for Kibana authentication.
     */
    val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Specifies the Cognito identity pool ID for Kibana authentication.
     */
    val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Specifies the Cognito user pool ID for Kibana authentication.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.CognitoOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoOptions(")
        append("enabled=$enabled,")
        append("identityPoolId=$identityPoolId,")
        append("roleArn=$roleArn,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CognitoOptions

        if (enabled != other.enabled) return false
        if (identityPoolId != other.identityPoolId) return false
        if (roleArn != other.roleArn) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.CognitoOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the option to enable Cognito for Kibana authentication.
         */
        var enabled: kotlin.Boolean? = null
        /**
         * Specifies the Cognito identity pool ID for Kibana authentication.
         */
        var identityPoolId: kotlin.String? = null
        /**
         * Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.
         */
        var roleArn: kotlin.String? = null
        /**
         * Specifies the Cognito user pool ID for Kibana authentication.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.CognitoOptions) : this() {
            this.enabled = x.enabled
            this.identityPoolId = x.identityPoolId
            this.roleArn = x.roleArn
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.CognitoOptions = CognitoOptions(this)
    }
}
