// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



/**
 * Specifies the Auto-Tune options: the Auto-Tune desired state for the domain, rollback state when disabling Auto-Tune options and list of maintenance schedules.
 */
class AutoTuneOptions private constructor(builder: Builder) {
    /**
     * Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
     */
    val desiredState: aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneDesiredState? = builder.desiredState
    /**
     * Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide for more information.
     */
    val maintenanceSchedules: List<AutoTuneMaintenanceSchedule>? = builder.maintenanceSchedules
    /**
     * Specifies the rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK.
     */
    val rollbackOnDisable: aws.sdk.kotlin.services.elasticsearchservice.model.RollbackOnDisable? = builder.rollbackOnDisable

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoTuneOptions(")
        append("desiredState=$desiredState,")
        append("maintenanceSchedules=$maintenanceSchedules,")
        append("rollbackOnDisable=$rollbackOnDisable)")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredState?.hashCode() ?: 0
        result = 31 * result + (maintenanceSchedules?.hashCode() ?: 0)
        result = 31 * result + (rollbackOnDisable?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoTuneOptions

        if (desiredState != other.desiredState) return false
        if (maintenanceSchedules != other.maintenanceSchedules) return false
        if (rollbackOnDisable != other.rollbackOnDisable) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
         */
        var desiredState: aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneDesiredState? = null
        /**
         * Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide for more information.
         */
        var maintenanceSchedules: List<AutoTuneMaintenanceSchedule>? = null
        /**
         * Specifies the rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK.
         */
        var rollbackOnDisable: aws.sdk.kotlin.services.elasticsearchservice.model.RollbackOnDisable? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneOptions) : this() {
            this.desiredState = x.desiredState
            this.maintenanceSchedules = x.maintenanceSchedules
            this.rollbackOnDisable = x.rollbackOnDisable
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.AutoTuneOptions = AutoTuneOptions(this)
    }
}
