// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model



/**
 * Status of the advanced options for the specified Elasticsearch domain. Currently, the following advanced options are available:
 *
 * Option to allow references to indices in an HTTP request body.  Must be false when configuring access to individual sub-resources.  By default, the value is true.
 * See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options for more information.
 * Option to specify the percentage of heap space that is allocated to field data. By default, this setting is unbounded.
 *
 * For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options">Configuring Advanced Options.
 */
class AdvancedOptionsStatus private constructor(builder: Builder) {
    /**
     * Specifies the status of advanced options for the specified Elasticsearch domain.
     */
    val options: Map<String, String>? = builder.options
    /**
     * Specifies the status of OptionStatus for advanced options for the specified Elasticsearch domain.
     */
    val status: aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedOptionsStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedOptionsStatus(")
        append("options=$options,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = options?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedOptionsStatus

        if (options != other.options) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedOptionsStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the status of advanced options for the specified Elasticsearch domain.
         */
        var options: Map<String, String>? = null
        /**
         * Specifies the status of OptionStatus for advanced options for the specified Elasticsearch domain.
         */
        var status: aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedOptionsStatus) : this() {
            this.options = x.options
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedOptionsStatus = AdvancedOptionsStatus(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus.invoke(block)
        }
    }
}
