// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.elasticsearchservice.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.elasticsearchservice.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * <fullname>Amazon Elasticsearch Configuration Service</fullname>
 * Use the Amazon Elasticsearch Configuration API to create, configure, and manage Elasticsearch domains.
 * For sample code that uses the Configuration API, see the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-samples.html">Amazon Elasticsearch Service Developer Guide.
 * The guide also contains <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-request-signing.html">sample code for sending signed HTTP requests to the Elasticsearch APIs.
 * The endpoint for configuration service requests is region-specific: es.region.amazonaws.com.
 * For example, es.us-east-1.amazonaws.com. For a current list of supported regions and endpoints,
 * see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticsearch-service-regions" target="_blank">Regions and Endpoints.
 */
interface ElasticsearchClient : SdkClient {

    override val serviceName: String
        get() = "Elasticsearch Service"
    /**
     * ElasticsearchClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ElasticsearchClient {
            val config = Config.Builder().apply(block).build()
            return DefaultElasticsearchClient(config)
        }

        operator fun invoke(config: Config): ElasticsearchClient = DefaultElasticsearchClient(config)

        /**
         * Construct a [ElasticsearchClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ElasticsearchClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultElasticsearchClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
     */
    suspend fun acceptInboundCrossClusterSearchConnection(input: AcceptInboundCrossClusterSearchConnectionRequest): AcceptInboundCrossClusterSearchConnectionResponse

    /**
     * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
     */
    suspend fun acceptInboundCrossClusterSearchConnection(block: AcceptInboundCrossClusterSearchConnectionRequest.Builder.() -> Unit) = acceptInboundCrossClusterSearchConnection(AcceptInboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

    /**
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags.  See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging" target="_blank">
     * Tagging Amazon Elasticsearch Service Domains for more information.
     */
    suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags.  See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging" target="_blank">
     * Tagging Amazon Elasticsearch Service Domains for more information.
     */
    suspend fun addTags(block: AddTagsRequest.Builder.() -> Unit) = addTags(AddTagsRequest.Builder().apply(block).build())

    /**
     * Associates a package with an Amazon ES domain.
     */
    suspend fun associatePackage(input: AssociatePackageRequest): AssociatePackageResponse

    /**
     * Associates a package with an Amazon ES domain.
     */
    suspend fun associatePackage(block: AssociatePackageRequest.Builder.() -> Unit) = associatePackage(AssociatePackageRequest.Builder().apply(block).build())

    /**
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the AutomatedUpdateDate and when the UpdateStatus is in the PENDING_UPDATE state.
     */
    suspend fun cancelElasticsearchServiceSoftwareUpdate(input: CancelElasticsearchServiceSoftwareUpdateRequest): CancelElasticsearchServiceSoftwareUpdateResponse

    /**
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the AutomatedUpdateDate and when the UpdateStatus is in the PENDING_UPDATE state.
     */
    suspend fun cancelElasticsearchServiceSoftwareUpdate(block: CancelElasticsearchServiceSoftwareUpdateRequest.Builder.() -> Unit) = cancelElasticsearchServiceSoftwareUpdate(CancelElasticsearchServiceSoftwareUpdateRequest.Builder().apply(block).build())

    /**
     * Creates a new Elasticsearch domain. For more information,
     * see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains in the Amazon Elasticsearch Service Developer Guide.
     */
    suspend fun createElasticsearchDomain(input: CreateElasticsearchDomainRequest): CreateElasticsearchDomainResponse

    /**
     * Creates a new Elasticsearch domain. For more information,
     * see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains in the Amazon Elasticsearch Service Developer Guide.
     */
    suspend fun createElasticsearchDomain(block: CreateElasticsearchDomainRequest.Builder.() -> Unit) = createElasticsearchDomain(CreateElasticsearchDomainRequest.Builder().apply(block).build())

    /**
     * Creates a new cross-cluster search connection from a source domain to a destination domain.
     */
    suspend fun createOutboundCrossClusterSearchConnection(input: CreateOutboundCrossClusterSearchConnectionRequest): CreateOutboundCrossClusterSearchConnectionResponse

    /**
     * Creates a new cross-cluster search connection from a source domain to a destination domain.
     */
    suspend fun createOutboundCrossClusterSearchConnection(block: CreateOutboundCrossClusterSearchConnectionRequest.Builder.() -> Unit) = createOutboundCrossClusterSearchConnection(CreateOutboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

    /**
     * Create a package for use with Amazon ES domains.
     */
    suspend fun createPackage(input: CreatePackageRequest): CreatePackageResponse

    /**
     * Create a package for use with Amazon ES domains.
     */
    suspend fun createPackage(block: CreatePackageRequest.Builder.() -> Unit) = createPackage(CreatePackageRequest.Builder().apply(block).build())

    /**
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.
     */
    suspend fun deleteElasticsearchDomain(input: DeleteElasticsearchDomainRequest): DeleteElasticsearchDomainResponse

    /**
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.
     */
    suspend fun deleteElasticsearchDomain(block: DeleteElasticsearchDomainRequest.Builder.() -> Unit) = deleteElasticsearchDomain(DeleteElasticsearchDomainRequest.Builder().apply(block).build())

    /**
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr" target="_blank">Deleting Elasticsearch Service Role in VPC Endpoints for Amazon Elasticsearch Service Domains.
     */
    suspend fun deleteElasticsearchServiceRole(input: DeleteElasticsearchServiceRoleRequest): DeleteElasticsearchServiceRoleResponse

    /**
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr" target="_blank">Deleting Elasticsearch Service Role in VPC Endpoints for Amazon Elasticsearch Service Domains.
     */
    suspend fun deleteElasticsearchServiceRole(block: DeleteElasticsearchServiceRoleRequest.Builder.() -> Unit) = deleteElasticsearchServiceRole(DeleteElasticsearchServiceRoleRequest.Builder().apply(block).build())

    /**
     * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
     */
    suspend fun deleteInboundCrossClusterSearchConnection(input: DeleteInboundCrossClusterSearchConnectionRequest): DeleteInboundCrossClusterSearchConnectionResponse

    /**
     * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
     */
    suspend fun deleteInboundCrossClusterSearchConnection(block: DeleteInboundCrossClusterSearchConnectionRequest.Builder.() -> Unit) = deleteInboundCrossClusterSearchConnection(DeleteInboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

    /**
     * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
     */
    suspend fun deleteOutboundCrossClusterSearchConnection(input: DeleteOutboundCrossClusterSearchConnectionRequest): DeleteOutboundCrossClusterSearchConnectionResponse

    /**
     * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
     */
    suspend fun deleteOutboundCrossClusterSearchConnection(block: DeleteOutboundCrossClusterSearchConnectionRequest.Builder.() -> Unit) = deleteOutboundCrossClusterSearchConnection(DeleteOutboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

    /**
     * Delete the package.
     */
    suspend fun deletePackage(input: DeletePackageRequest): DeletePackageResponse

    /**
     * Delete the package.
     */
    suspend fun deletePackage(block: DeletePackageRequest.Builder.() -> Unit) = deletePackage(DeletePackageRequest.Builder().apply(block).build())

    /**
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.
     */
    suspend fun describeDomainAutoTunes(input: DescribeDomainAutoTunesRequest): DescribeDomainAutoTunesResponse

    /**
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.
     */
    suspend fun describeDomainAutoTunes(block: DescribeDomainAutoTunesRequest.Builder.() -> Unit) = describeDomainAutoTunes(DescribeDomainAutoTunesRequest.Builder().apply(block).build())

    /**
     * Returns information about the current blue/green deployment happening on a domain, including
     * a change ID, status, and progress stages.
     */
    suspend fun describeDomainChangeProgress(input: DescribeDomainChangeProgressRequest): DescribeDomainChangeProgressResponse

    /**
     * Returns information about the current blue/green deployment happening on a domain, including
     * a change ID, status, and progress stages.
     */
    suspend fun describeDomainChangeProgress(block: DescribeDomainChangeProgressRequest.Builder.() -> Unit) = describeDomainChangeProgress(DescribeDomainChangeProgressRequest.Builder().apply(block).build())

    /**
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.
     */
    suspend fun describeElasticsearchDomain(input: DescribeElasticsearchDomainRequest): DescribeElasticsearchDomainResponse

    /**
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.
     */
    suspend fun describeElasticsearchDomain(block: DescribeElasticsearchDomainRequest.Builder.() -> Unit) = describeElasticsearchDomain(DescribeElasticsearchDomainRequest.Builder().apply(block).build())

    /**
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.
     */
    suspend fun describeElasticsearchDomainConfig(input: DescribeElasticsearchDomainConfigRequest): DescribeElasticsearchDomainConfigResponse

    /**
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.
     */
    suspend fun describeElasticsearchDomainConfig(block: DescribeElasticsearchDomainConfigRequest.Builder.() -> Unit) = describeElasticsearchDomainConfig(DescribeElasticsearchDomainConfigRequest.Builder().apply(block).build())

    /**
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.
     */
    suspend fun describeElasticsearchDomains(input: DescribeElasticsearchDomainsRequest): DescribeElasticsearchDomainsResponse

    /**
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.
     */
    suspend fun describeElasticsearchDomains(block: DescribeElasticsearchDomainsRequest.Builder.() -> Unit) = describeElasticsearchDomains(DescribeElasticsearchDomainsRequest.Builder().apply(block).build())

    /**
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion.
     * When modifying existing Domain, specify the
     *
     * DomainName
     *
     * to know what Limits are supported for modifying.
     */
    suspend fun describeElasticsearchInstanceTypeLimits(input: DescribeElasticsearchInstanceTypeLimitsRequest): DescribeElasticsearchInstanceTypeLimitsResponse

    /**
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion.
     * When modifying existing Domain, specify the
     *
     * DomainName
     *
     * to know what Limits are supported for modifying.
     */
    suspend fun describeElasticsearchInstanceTypeLimits(block: DescribeElasticsearchInstanceTypeLimitsRequest.Builder.() -> Unit) = describeElasticsearchInstanceTypeLimits(DescribeElasticsearchInstanceTypeLimitsRequest.Builder().apply(block).build())

    /**
     * Lists all the inbound cross-cluster search connections for a destination domain.
     */
    suspend fun describeInboundCrossClusterSearchConnections(input: DescribeInboundCrossClusterSearchConnectionsRequest): DescribeInboundCrossClusterSearchConnectionsResponse

    /**
     * Lists all the inbound cross-cluster search connections for a destination domain.
     */
    suspend fun describeInboundCrossClusterSearchConnections(block: DescribeInboundCrossClusterSearchConnectionsRequest.Builder.() -> Unit) = describeInboundCrossClusterSearchConnections(DescribeInboundCrossClusterSearchConnectionsRequest.Builder().apply(block).build())

    /**
     * Lists all the outbound cross-cluster search connections for a source domain.
     */
    suspend fun describeOutboundCrossClusterSearchConnections(input: DescribeOutboundCrossClusterSearchConnectionsRequest): DescribeOutboundCrossClusterSearchConnectionsResponse

    /**
     * Lists all the outbound cross-cluster search connections for a source domain.
     */
    suspend fun describeOutboundCrossClusterSearchConnections(block: DescribeOutboundCrossClusterSearchConnectionsRequest.Builder.() -> Unit) = describeOutboundCrossClusterSearchConnections(DescribeOutboundCrossClusterSearchConnectionsRequest.Builder().apply(block).build())

    /**
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.
     */
    suspend fun describePackages(input: DescribePackagesRequest): DescribePackagesResponse

    /**
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.
     */
    suspend fun describePackages(block: DescribePackagesRequest.Builder.() -> Unit) = describePackages(DescribePackagesRequest.Builder().apply(block).build())

    /**
     * Lists available reserved Elasticsearch instance offerings.
     */
    suspend fun describeReservedElasticsearchInstanceOfferings(input: DescribeReservedElasticsearchInstanceOfferingsRequest): DescribeReservedElasticsearchInstanceOfferingsResponse

    /**
     * Lists available reserved Elasticsearch instance offerings.
     */
    suspend fun describeReservedElasticsearchInstanceOfferings(block: DescribeReservedElasticsearchInstanceOfferingsRequest.Builder.() -> Unit) = describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsRequest.Builder().apply(block).build())

    /**
     * Returns information about reserved Elasticsearch instances for this account.
     */
    suspend fun describeReservedElasticsearchInstances(input: DescribeReservedElasticsearchInstancesRequest): DescribeReservedElasticsearchInstancesResponse

    /**
     * Returns information about reserved Elasticsearch instances for this account.
     */
    suspend fun describeReservedElasticsearchInstances(block: DescribeReservedElasticsearchInstancesRequest.Builder.() -> Unit) = describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesRequest.Builder().apply(block).build())

    /**
     * Dissociates a package from the Amazon ES domain.
     */
    suspend fun dissociatePackage(input: DissociatePackageRequest): DissociatePackageResponse

    /**
     * Dissociates a package from the Amazon ES domain.
     */
    suspend fun dissociatePackage(block: DissociatePackageRequest.Builder.() -> Unit) = dissociatePackage(DissociatePackageRequest.Builder().apply(block).build())

    /**
     * Returns a list of upgrade compatible Elastisearch versions.
     * You can optionally pass a
     *
     * DomainName
     *
     * to get all upgrade compatible Elasticsearch versions for that specific domain.
     */
    suspend fun getCompatibleElasticsearchVersions(input: GetCompatibleElasticsearchVersionsRequest): GetCompatibleElasticsearchVersionsResponse

    /**
     * Returns a list of upgrade compatible Elastisearch versions.
     * You can optionally pass a
     *
     * DomainName
     *
     * to get all upgrade compatible Elasticsearch versions for that specific domain.
     */
    suspend fun getCompatibleElasticsearchVersions(block: GetCompatibleElasticsearchVersionsRequest.Builder.() -> Unit) = getCompatibleElasticsearchVersions(GetCompatibleElasticsearchVersionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of versions of the package, along with their creation time and commit message.
     */
    suspend fun getPackageVersionHistory(input: GetPackageVersionHistoryRequest): GetPackageVersionHistoryResponse

    /**
     * Returns a list of versions of the package, along with their creation time and commit message.
     */
    suspend fun getPackageVersionHistory(block: GetPackageVersionHistoryRequest.Builder.() -> Unit) = getPackageVersionHistory(GetPackageVersionHistoryRequest.Builder().apply(block).build())

    /**
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     */
    suspend fun getUpgradeHistory(input: GetUpgradeHistoryRequest): GetUpgradeHistoryResponse

    /**
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     */
    suspend fun getUpgradeHistory(block: GetUpgradeHistoryRequest.Builder.() -> Unit) = getUpgradeHistory(GetUpgradeHistoryRequest.Builder().apply(block).build())

    /**
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     */
    suspend fun getUpgradeStatus(input: GetUpgradeStatusRequest): GetUpgradeStatusResponse

    /**
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     */
    suspend fun getUpgradeStatus(block: GetUpgradeStatusRequest.Builder.() -> Unit) = getUpgradeStatus(GetUpgradeStatusRequest.Builder().apply(block).build())

    /**
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     */
    suspend fun listDomainNames(input: ListDomainNamesRequest): ListDomainNamesResponse

    /**
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     */
    suspend fun listDomainNames(block: ListDomainNamesRequest.Builder.() -> Unit) = listDomainNames(ListDomainNamesRequest.Builder().apply(block).build())

    /**
     * Lists all Amazon ES domains associated with the package.
     */
    suspend fun listDomainsForPackage(input: ListDomainsForPackageRequest): ListDomainsForPackageResponse

    /**
     * Lists all Amazon ES domains associated with the package.
     */
    suspend fun listDomainsForPackage(block: ListDomainsForPackageRequest.Builder.() -> Unit) = listDomainsForPackage(ListDomainsForPackageRequest.Builder().apply(block).build())

    /**
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     */
    suspend fun listElasticsearchInstanceTypes(input: ListElasticsearchInstanceTypesRequest): ListElasticsearchInstanceTypesResponse

    /**
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     */
    suspend fun listElasticsearchInstanceTypes(block: ListElasticsearchInstanceTypesRequest.Builder.() -> Unit) = listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesRequest.Builder().apply(block).build())

    /**
     * List all supported Elasticsearch versions
     */
    suspend fun listElasticsearchVersions(input: ListElasticsearchVersionsRequest): ListElasticsearchVersionsResponse

    /**
     * List all supported Elasticsearch versions
     */
    suspend fun listElasticsearchVersions(block: ListElasticsearchVersionsRequest.Builder.() -> Unit) = listElasticsearchVersions(ListElasticsearchVersionsRequest.Builder().apply(block).build())

    /**
     * Lists all packages associated with the Amazon ES domain.
     */
    suspend fun listPackagesForDomain(input: ListPackagesForDomainRequest): ListPackagesForDomainResponse

    /**
     * Lists all packages associated with the Amazon ES domain.
     */
    suspend fun listPackagesForDomain(block: ListPackagesForDomainRequest.Builder.() -> Unit) = listPackagesForDomain(ListPackagesForDomainRequest.Builder().apply(block).build())

    /**
     * Returns all tags for the given Elasticsearch domain.
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Returns all tags for the given Elasticsearch domain.
     */
    suspend fun listTags(block: ListTagsRequest.Builder.() -> Unit) = listTags(ListTagsRequest.Builder().apply(block).build())

    /**
     * Allows you to purchase reserved Elasticsearch instances.
     */
    suspend fun purchaseReservedElasticsearchInstanceOffering(input: PurchaseReservedElasticsearchInstanceOfferingRequest): PurchaseReservedElasticsearchInstanceOfferingResponse

    /**
     * Allows you to purchase reserved Elasticsearch instances.
     */
    suspend fun purchaseReservedElasticsearchInstanceOffering(block: PurchaseReservedElasticsearchInstanceOfferingRequest.Builder.() -> Unit) = purchaseReservedElasticsearchInstanceOffering(PurchaseReservedElasticsearchInstanceOfferingRequest.Builder().apply(block).build())

    /**
     * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
     */
    suspend fun rejectInboundCrossClusterSearchConnection(input: RejectInboundCrossClusterSearchConnectionRequest): RejectInboundCrossClusterSearchConnectionResponse

    /**
     * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
     */
    suspend fun rejectInboundCrossClusterSearchConnection(block: RejectInboundCrossClusterSearchConnectionRequest.Builder.() -> Unit) = rejectInboundCrossClusterSearchConnection(RejectInboundCrossClusterSearchConnectionRequest.Builder().apply(block).build())

    /**
     * Removes the specified set of tags from the specified Elasticsearch domain.
     */
    suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Removes the specified set of tags from the specified Elasticsearch domain.
     */
    suspend fun removeTags(block: RemoveTagsRequest.Builder.() -> Unit) = removeTags(RemoveTagsRequest.Builder().apply(block).build())

    /**
     * Schedules a service software update for an Amazon ES domain.
     */
    suspend fun startElasticsearchServiceSoftwareUpdate(input: StartElasticsearchServiceSoftwareUpdateRequest): StartElasticsearchServiceSoftwareUpdateResponse

    /**
     * Schedules a service software update for an Amazon ES domain.
     */
    suspend fun startElasticsearchServiceSoftwareUpdate(block: StartElasticsearchServiceSoftwareUpdateRequest.Builder.() -> Unit) = startElasticsearchServiceSoftwareUpdate(StartElasticsearchServiceSoftwareUpdateRequest.Builder().apply(block).build())

    /**
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances.
     */
    suspend fun updateElasticsearchDomainConfig(input: UpdateElasticsearchDomainConfigRequest): UpdateElasticsearchDomainConfigResponse

    /**
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances.
     */
    suspend fun updateElasticsearchDomainConfig(block: UpdateElasticsearchDomainConfigRequest.Builder.() -> Unit) = updateElasticsearchDomainConfig(UpdateElasticsearchDomainConfigRequest.Builder().apply(block).build())

    /**
     * Updates a package for use with Amazon ES domains.
     */
    suspend fun updatePackage(input: UpdatePackageRequest): UpdatePackageResponse

    /**
     * Updates a package for use with Amazon ES domains.
     */
    suspend fun updatePackage(block: UpdatePackageRequest.Builder.() -> Unit) = updatePackage(UpdatePackageRequest.Builder().apply(block).build())

    /**
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.
     */
    suspend fun upgradeElasticsearchDomain(input: UpgradeElasticsearchDomainRequest): UpgradeElasticsearchDomainResponse

    /**
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.
     */
    suspend fun upgradeElasticsearchDomain(block: UpgradeElasticsearchDomainRequest.Builder.() -> Unit) = upgradeElasticsearchDomain(UpgradeElasticsearchDomainRequest.Builder().apply(block).build())
}
