// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.serde

import aws.sdk.kotlin.services.elasticsearchservice.model.DryRunResults
import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchDomainConfig
import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.UpdateElasticsearchDomainConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateElasticsearchDomainConfigOperationDeserializer: HttpDeserializer.NonStreaming<UpdateElasticsearchDomainConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateElasticsearchDomainConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateElasticsearchDomainConfigError(context, call, payload)
        }
        val builder = UpdateElasticsearchDomainConfigResponse.Builder()

        if (payload != null) {
            deserializeUpdateElasticsearchDomainConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateElasticsearchDomainConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTypeException" -> InvalidTypeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateElasticsearchDomainConfigOperationBody(builder: UpdateElasticsearchDomainConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOMAINCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DomainConfig"))
    val DRYRUNRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DryRunResults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAINCONFIG_DESCRIPTOR)
        field(DRYRUNRESULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMAINCONFIG_DESCRIPTOR.index -> builder.domainConfig = deserializeElasticsearchDomainConfigDocument(deserializer)
                DRYRUNRESULTS_DESCRIPTOR.index -> builder.dryRunResults = deserializeDryRunResultsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
