// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.serde

import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.GetUpgradeStatusResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStatus
import aws.sdk.kotlin.services.elasticsearchservice.model.UpgradeStep
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetUpgradeStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetUpgradeStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetUpgradeStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetUpgradeStatusError(context, call, payload)
        }
        val builder = GetUpgradeStatusResponse.Builder()

        if (payload != null) {
            deserializeGetUpgradeStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetUpgradeStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUpgradeStatusOperationBody(builder: GetUpgradeStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val STEPSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("StepStatus"))
    val UPGRADENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UpgradeName"))
    val UPGRADESTEP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UpgradeStep"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STEPSTATUS_DESCRIPTOR)
        field(UPGRADENAME_DESCRIPTOR)
        field(UPGRADESTEP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                STEPSTATUS_DESCRIPTOR.index -> builder.stepStatus = deserializeString().let { UpgradeStatus.fromValue(it) }
                UPGRADENAME_DESCRIPTOR.index -> builder.upgradeName = deserializeString()
                UPGRADESTEP_DESCRIPTOR.index -> builder.upgradeStep = deserializeString().let { UpgradeStep.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
