// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.serde

import aws.sdk.kotlin.services.elasticsearchservice.model.CreateOutboundCrossClusterSearchConnectionResponse
import aws.sdk.kotlin.services.elasticsearchservice.model.DomainInformation
import aws.sdk.kotlin.services.elasticsearchservice.model.ElasticsearchException
import aws.sdk.kotlin.services.elasticsearchservice.model.OutboundCrossClusterSearchConnectionStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateOutboundCrossClusterSearchConnectionOperationDeserializer: HttpDeserializer.NonStreaming<CreateOutboundCrossClusterSearchConnectionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateOutboundCrossClusterSearchConnectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateOutboundCrossClusterSearchConnectionError(context, call, payload)
        }
        val builder = CreateOutboundCrossClusterSearchConnectionResponse.Builder()

        if (payload != null) {
            deserializeCreateOutboundCrossClusterSearchConnectionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateOutboundCrossClusterSearchConnectionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticsearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticsearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOutboundCrossClusterSearchConnectionOperationBody(builder: CreateOutboundCrossClusterSearchConnectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionAlias"))
    val CONNECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionStatus"))
    val CROSSCLUSTERSEARCHCONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CrossClusterSearchConnectionId"))
    val DESTINATIONDOMAININFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DestinationDomainInfo"))
    val SOURCEDOMAININFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceDomainInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONALIAS_DESCRIPTOR)
        field(CONNECTIONSTATUS_DESCRIPTOR)
        field(CROSSCLUSTERSEARCHCONNECTIONID_DESCRIPTOR)
        field(DESTINATIONDOMAININFO_DESCRIPTOR)
        field(SOURCEDOMAININFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONALIAS_DESCRIPTOR.index -> builder.connectionAlias = deserializeString()
                CONNECTIONSTATUS_DESCRIPTOR.index -> builder.connectionStatus = deserializeOutboundCrossClusterSearchConnectionStatusDocument(deserializer)
                CROSSCLUSTERSEARCHCONNECTIONID_DESCRIPTOR.index -> builder.crossClusterSearchConnectionId = deserializeString()
                DESTINATIONDOMAININFO_DESCRIPTOR.index -> builder.destinationDomainInfo = deserializeDomainInformationDocument(deserializer)
                SOURCEDOMAININFO_DESCRIPTOR.index -> builder.sourceDomainInfo = deserializeDomainInformationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
