// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Options to specify the subnets and security groups for VPC endpoint. For more information, see [ VPC Endpoints for Amazon Elasticsearch Service Domains](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
 */
public class VpcDerivedInfo private constructor(builder: Builder) {
    /**
     * The availability zones for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Specifies the security groups for VPC endpoint.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Specifies the subnets for VPC endpoint.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The VPC Id for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.VpcDerivedInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcDerivedInfo(")
        append("availabilityZones=$availabilityZones,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcDerivedInfo

        if (availabilityZones != other.availabilityZones) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.VpcDerivedInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The availability zones for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Specifies the security groups for VPC endpoint.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * Specifies the subnets for VPC endpoint.
         */
        public var subnetIds: List<String>? = null
        /**
         * The VPC Id for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.VpcDerivedInfo) : this() {
            this.availabilityZones = x.availabilityZones
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.VpcDerivedInfo = VpcDerivedInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
