// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies details of the scheduled Auto-Tune action. See the [Developer Guide](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html) for more information.
 */
public class ScheduledAutoTuneDetails private constructor(builder: Builder) {
    /**
     * Specifies Auto-Tune action description.
     */
    public val action: kotlin.String? = builder.action
    /**
     * Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
     */
    public val actionType: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneActionType? = builder.actionType
    /**
     * Specifies timestamp for the Auto-Tune action scheduled for the domain.
     */
    public val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
     */
    public val severity: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneSeverityType? = builder.severity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledAutoTuneDetails(")
        append("action=$action,")
        append("actionType=$actionType,")
        append("date=$date,")
        append("severity=$severity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (actionType?.hashCode() ?: 0)
        result = 31 * result + (date?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledAutoTuneDetails

        if (action != other.action) return false
        if (actionType != other.actionType) return false
        if (date != other.date) return false
        if (severity != other.severity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies Auto-Tune action description.
         */
        public var action: kotlin.String? = null
        /**
         * Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
         */
        public var actionType: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneActionType? = null
        /**
         * Specifies timestamp for the Auto-Tune action scheduled for the domain.
         */
        public var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
         */
        public var severity: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneSeverityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneDetails) : this() {
            this.action = x.action
            this.actionType = x.actionType
            this.date = x.date
            this.severity = x.severity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.ScheduledAutoTuneDetails = ScheduledAutoTuneDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
