// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the SAML application configuration for the domain.
 */
public class SamlOptionsInput private constructor(builder: Builder) {
    /**
     * True if SAML is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Specifies the SAML Identity Provider's information.
     */
    public val idp: aws.sdk.kotlin.services.elasticsearchservice.model.SamlIdp? = builder.idp
    /**
     * The backend role to which the SAML master user is mapped to.
     */
    public val masterBackendRole: kotlin.String? = builder.masterBackendRole
    /**
     * The SAML master username, which is stored in the Amazon Elasticsearch Service domain's internal database.
     */
    public val masterUserName: kotlin.String? = builder.masterUserName
    /**
     * The key to use for matching the SAML Roles attribute.
     */
    public val rolesKey: kotlin.String? = builder.rolesKey
    /**
     * The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.
     */
    public val sessionTimeoutMinutes: kotlin.Int? = builder.sessionTimeoutMinutes
    /**
     * The key to use for matching the SAML Subject attribute.
     */
    public val subjectKey: kotlin.String? = builder.subjectKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.SamlOptionsInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SamlOptionsInput(")
        append("enabled=$enabled,")
        append("idp=$idp,")
        append("masterBackendRole=$masterBackendRole,")
        append("masterUserName=*** Sensitive Data Redacted ***,")
        append("rolesKey=$rolesKey,")
        append("sessionTimeoutMinutes=$sessionTimeoutMinutes,")
        append("subjectKey=$subjectKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (idp?.hashCode() ?: 0)
        result = 31 * result + (masterBackendRole?.hashCode() ?: 0)
        result = 31 * result + (masterUserName?.hashCode() ?: 0)
        result = 31 * result + (rolesKey?.hashCode() ?: 0)
        result = 31 * result + (sessionTimeoutMinutes ?: 0)
        result = 31 * result + (subjectKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SamlOptionsInput

        if (enabled != other.enabled) return false
        if (idp != other.idp) return false
        if (masterBackendRole != other.masterBackendRole) return false
        if (masterUserName != other.masterUserName) return false
        if (rolesKey != other.rolesKey) return false
        if (sessionTimeoutMinutes != other.sessionTimeoutMinutes) return false
        if (subjectKey != other.subjectKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.SamlOptionsInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * True if SAML is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Specifies the SAML Identity Provider's information.
         */
        public var idp: aws.sdk.kotlin.services.elasticsearchservice.model.SamlIdp? = null
        /**
         * The backend role to which the SAML master user is mapped to.
         */
        public var masterBackendRole: kotlin.String? = null
        /**
         * The SAML master username, which is stored in the Amazon Elasticsearch Service domain's internal database.
         */
        public var masterUserName: kotlin.String? = null
        /**
         * The key to use for matching the SAML Roles attribute.
         */
        public var rolesKey: kotlin.String? = null
        /**
         * The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.
         */
        public var sessionTimeoutMinutes: kotlin.Int? = null
        /**
         * The key to use for matching the SAML Subject attribute.
         */
        public var subjectKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.SamlOptionsInput) : this() {
            this.enabled = x.enabled
            this.idp = x.idp
            this.masterBackendRole = x.masterBackendRole
            this.masterUserName = x.masterUserName
            this.rolesKey = x.rolesKey
            this.sessionTimeoutMinutes = x.sessionTimeoutMinutes
            this.subjectKey = x.subjectKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.SamlOptionsInput = SamlOptionsInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.SamlIdp] inside the given [block]
         */
        public fun idp(block: aws.sdk.kotlin.services.elasticsearchservice.model.SamlIdp.Builder.() -> kotlin.Unit) {
            this.idp = aws.sdk.kotlin.services.elasticsearchservice.model.SamlIdp.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
