// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for the parameters to the ` <a>ListElasticsearchVersions</a> ` operation.
 *
 *  Use ` <a>MaxResults</a> ` to control the maximum number of results to retrieve in a single call.
 *
 *  Use ` <a>NextToken</a> ` in response to retrieve more results. If the received response does not contain a NextToken, then there are no more results to retrieve.
 */
public class ListElasticsearchVersionsRequest private constructor(builder: Builder) {
    /**
     * Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListElasticsearchVersionsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListElasticsearchVersionsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchVersionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchVersionsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.ListElasticsearchVersionsRequest = ListElasticsearchVersionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
