// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the advanced security configuration: whether advanced security is enabled, whether the internal database option is enabled, master username and password (if internal database is enabled), and master user ARN (if IAM is enabled).
 */
public class AdvancedSecurityOptionsInput private constructor(builder: Builder) {
    /**
     * True if Anonymous auth is enabled. Anonymous auth can be enabled only when AdvancedSecurity is enabled on existing domains.
     */
    public val anonymousAuthEnabled: kotlin.Boolean? = builder.anonymousAuthEnabled
    /**
     * True if advanced security is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * True if the internal user database is enabled.
     */
    public val internalUserDatabaseEnabled: kotlin.Boolean? = builder.internalUserDatabaseEnabled
    /**
     * Credentials for the master user: username and password, ARN, or both.
     */
    public val masterUserOptions: aws.sdk.kotlin.services.elasticsearchservice.model.MasterUserOptions? = builder.masterUserOptions
    /**
     * Specifies the SAML application configuration for the domain.
     */
    public val samlOptions: aws.sdk.kotlin.services.elasticsearchservice.model.SamlOptionsInput? = builder.samlOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedSecurityOptionsInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedSecurityOptionsInput(")
        append("anonymousAuthEnabled=$anonymousAuthEnabled,")
        append("enabled=$enabled,")
        append("internalUserDatabaseEnabled=$internalUserDatabaseEnabled,")
        append("masterUserOptions=$masterUserOptions,")
        append("samlOptions=$samlOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anonymousAuthEnabled?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (internalUserDatabaseEnabled?.hashCode() ?: 0)
        result = 31 * result + (masterUserOptions?.hashCode() ?: 0)
        result = 31 * result + (samlOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedSecurityOptionsInput

        if (anonymousAuthEnabled != other.anonymousAuthEnabled) return false
        if (enabled != other.enabled) return false
        if (internalUserDatabaseEnabled != other.internalUserDatabaseEnabled) return false
        if (masterUserOptions != other.masterUserOptions) return false
        if (samlOptions != other.samlOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedSecurityOptionsInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * True if Anonymous auth is enabled. Anonymous auth can be enabled only when AdvancedSecurity is enabled on existing domains.
         */
        public var anonymousAuthEnabled: kotlin.Boolean? = null
        /**
         * True if advanced security is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * True if the internal user database is enabled.
         */
        public var internalUserDatabaseEnabled: kotlin.Boolean? = null
        /**
         * Credentials for the master user: username and password, ARN, or both.
         */
        public var masterUserOptions: aws.sdk.kotlin.services.elasticsearchservice.model.MasterUserOptions? = null
        /**
         * Specifies the SAML application configuration for the domain.
         */
        public var samlOptions: aws.sdk.kotlin.services.elasticsearchservice.model.SamlOptionsInput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedSecurityOptionsInput) : this() {
            this.anonymousAuthEnabled = x.anonymousAuthEnabled
            this.enabled = x.enabled
            this.internalUserDatabaseEnabled = x.internalUserDatabaseEnabled
            this.masterUserOptions = x.masterUserOptions
            this.samlOptions = x.samlOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedSecurityOptionsInput = AdvancedSecurityOptionsInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.MasterUserOptions] inside the given [block]
         */
        public fun masterUserOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.MasterUserOptions.Builder.() -> kotlin.Unit) {
            this.masterUserOptions = aws.sdk.kotlin.services.elasticsearchservice.model.MasterUserOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.SamlOptionsInput] inside the given [block]
         */
        public fun samlOptions(block: aws.sdk.kotlin.services.elasticsearchservice.model.SamlOptionsInput.Builder.() -> kotlin.Unit) {
            this.samlOptions = aws.sdk.kotlin.services.elasticsearchservice.model.SamlOptionsInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
