// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Status of the advanced options for the specified Elasticsearch domain. Currently, the following advanced options are available:
 * + Option to allow references to indices in an HTTP request body. Must be `false` when configuring access to individual sub-resources. By default, the value is `true`. See [Configuration Advanced Options](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options) for more information.
 * + Option to specify the percentage of heap space that is allocated to field data. By default, this setting is unbounded.
 *
 * For more information, see [Configuring Advanced Options](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options).
 */
public class AdvancedOptionsStatus private constructor(builder: Builder) {
    /**
     * Specifies the status of advanced options for the specified Elasticsearch domain.
     */
    public val options: Map<String, String> = requireNotNull(builder.options) { "A non-null value must be provided for options" }
    /**
     * Specifies the status of `OptionStatus` for advanced options for the specified Elasticsearch domain.
     */
    public val status: aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedOptionsStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedOptionsStatus(")
        append("options=$options,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = options.hashCode()
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedOptionsStatus

        if (options != other.options) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedOptionsStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the status of advanced options for the specified Elasticsearch domain.
         */
        public var options: Map<String, String>? = null
        /**
         * Specifies the status of `OptionStatus` for advanced options for the specified Elasticsearch domain.
         */
        public var status: aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedOptionsStatus) : this() {
            this.options = x.options
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticsearchservice.model.AdvancedOptionsStatus = AdvancedOptionsStatus(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.elasticsearchservice.model.OptionStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (options == null) options = emptyMap()
            return this
        }
    }
}
